/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.spdxspreadsheet.AbstractSheet;
import org.spdx.spdxspreadsheet.SpreadsheetException;

public class VerificationSheet
extends AbstractSheet {
    private static final int COL_WIDTH = 40;

    public VerificationSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    @Override
    public String verify() {
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle defaultStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        for (int i = 0; i < 25; ++i) {
            sheet.setColumnWidth(i, 10240);
            sheet.setDefaultColumnStyle(i, defaultStyle);
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
        }
    }

    public void importVerificationErrors(List<String>[] verificationErrors, String[] docNames) throws SpreadsheetException {
        if (verificationErrors == null) {
            throw new SpreadsheetException("Verification errors not specified on import (null value).");
        }
        if (docNames == null) {
            throw new SpreadsheetException("Document names errors not specified on import (null value).");
        }
        if (verificationErrors.length != docNames.length) {
            throw new SpreadsheetException("Number of verification errors does not equal the number of documents.");
        }
        if (docNames.length > 25) {
            throw new SpreadsheetException("Too many compare documents - must be less than " + String.valueOf(26));
        }
        Row header = this.sheet.getRow(0);
        int lastRowCreated = 0;
        for (int i = 0; i < docNames.length; ++i) {
            Cell hCell = header.getCell(i);
            hCell.setCellValue(docNames[i]);
            List<String> errors = verificationErrors[i];
            if (errors == null) continue;
            for (int j = 0; j < errors.size(); ++j) {
                Row errorRow;
                if (j + 1 > lastRowCreated) {
                    errorRow = this.sheet.createRow(j + 1);
                    lastRowCreated = j + 1;
                } else {
                    errorRow = this.sheet.getRow(j + 1);
                }
                Cell errorCell = errorRow.createCell(i);
                errorCell.setCellValue(errors.get(j));
            }
        }
    }
}

