/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.spdx.spdxspreadsheet.SPDXLicenseSpreadsheet;

public class LicenseTOCHTMLFile {
    static final String TEMPLATE_CLASS_PATH = "resources/htmlTemplate";
    static final String TEMPLATE_ROOT_PATH = "resources" + File.separator + "htmlTemplate";
    static final String HTML_TEMPLATE = "TocHTMLTemplate.html";
    List<ListedSpdxLicense> listedLicenses = Lists.newArrayList();
    List<DeprecatedLicense> deprecatedLicenses = Lists.newArrayList();
    private int currentRefNumber = 1;
    String version;
    String releaseDate;

    private String generateVersionString(String version, String releaseDate) {
        if (version == null || version.trim().isEmpty()) {
            return "";
        }
        String retval = version.trim();
        if (releaseDate != null && !releaseDate.trim().isEmpty()) {
            retval = retval + " " + releaseDate.trim();
        }
        return retval;
    }

    public LicenseTOCHTMLFile(String version, String releaseDate) {
        this.version = version;
        this.releaseDate = releaseDate;
    }

    public void addLicense(SpdxListedLicense license, String licHTMLReference) {
        this.listedLicenses.add(new ListedSpdxLicense(licHTMLReference, String.valueOf(this.currentRefNumber), license.getLicenseId(), license.isOsiApproved(), license.getFsfLibre(), license.getName()));
        ++this.currentRefNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(File htmlFile) throws IOException, MustacheException {
        FileOutputStream stream = null;
        OutputStreamWriter writer = null;
        if (!htmlFile.exists() && !htmlFile.createNewFile()) {
            throw new IOException("Can not create new file " + htmlFile.getName());
        }
        String templateDirName = TEMPLATE_ROOT_PATH;
        File templateDirectoryRoot = new File(templateDirName);
        if (!templateDirectoryRoot.exists() || !templateDirectoryRoot.isDirectory()) {
            templateDirName = TEMPLATE_CLASS_PATH;
        }
        try {
            stream = new FileOutputStream(htmlFile);
            writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");
            DefaultMustacheFactory builder = new DefaultMustacheFactory(templateDirName);
            Map<String, Object> mustacheMap = this.buildMustachMap();
            Mustache mustache = builder.compile(HTML_TEMPLATE);
            mustache.execute((Writer)writer, mustacheMap);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (stream != null) {
                stream.close();
            }
        }
    }

    private Map<String, Object> buildMustachMap() {
        HashMap retval = Maps.newHashMap();
        retval.put("version", this.generateVersionString(this.version, this.releaseDate));
        retval.put("listedLicenses", this.listedLicenses);
        retval.put("deprecatedLicenses", this.deprecatedLicenses);
        return retval;
    }

    public void addDeprecatedLicense(SPDXLicenseSpreadsheet.DeprecatedLicenseInfo deprecatedLicense, String licHTMLReference) {
        this.deprecatedLicenses.add(new DeprecatedLicense(licHTMLReference, String.valueOf(this.currentRefNumber), deprecatedLicense.getLicense().getLicenseId(), deprecatedLicense.getLicense().getName(), deprecatedLicense.getDeprecatedVersion()));
        ++this.currentRefNumber;
    }

    public static class ListedSpdxLicense {
        private String reference;
        private String refNumber;
        private String licenseId;
        private String osiApproved;
        private String fsfLibre;
        private String licenseName;

        public ListedSpdxLicense() {
            this.reference = null;
            this.refNumber = null;
            this.licenseId = null;
            this.osiApproved = null;
            this.licenseName = null;
            this.fsfLibre = null;
        }

        public ListedSpdxLicense(String reference, String refNumber, String licenseId, boolean isOsiApproved, Boolean fsfLibre, String licenseName) {
            this.reference = reference;
            this.refNumber = refNumber;
            this.licenseId = licenseId;
            this.osiApproved = isOsiApproved ? "Y" : "";
            this.fsfLibre = fsfLibre != null && fsfLibre != false ? "Y" : "";
            this.licenseName = licenseName;
        }

        public String getReference() {
            return this.reference;
        }

        public void setReference(String reference) {
            this.reference = reference;
        }

        public String getRefNumber() {
            return this.refNumber;
        }

        public void setRefNumber(String refNumber) {
            this.refNumber = refNumber;
        }

        public String getLicenseId() {
            return this.licenseId;
        }

        public void setLicenseId(String licenseId) {
            this.licenseId = licenseId;
        }

        public String getOsiApproved() {
            return this.osiApproved;
        }

        public String getFsfLibre() {
            return this.fsfLibre;
        }

        public void setOsiApproved(String osiApproved) {
            this.osiApproved = osiApproved;
        }

        public String getLicenseName() {
            return this.licenseName;
        }

        public void setLicenseName(String licenseName) {
            this.licenseName = licenseName;
        }
    }

    public static class DeprecatedLicense {
        private String reference;
        private String refNumber;
        private String licenseId;
        private String licenseName;
        private String deprecatedVersion;

        public DeprecatedLicense(String reference, String refNumber, String licenseId, String licenseName, String deprecatedVersion) {
            this.reference = reference;
            this.refNumber = refNumber;
            this.licenseId = licenseId;
            this.licenseName = licenseName;
            this.deprecatedVersion = deprecatedVersion;
        }

        public String getReference() {
            return this.reference;
        }

        public void setReference(String reference) {
            this.reference = reference;
        }

        public String getRefNumber() {
            return this.refNumber;
        }

        public void setRefNumber(String refNumber) {
            this.refNumber = refNumber;
        }

        public String getLicenseId() {
            return this.licenseId;
        }

        public void setLicenseId(String licenseId) {
            this.licenseId = licenseId;
        }

        public String getLicenseName() {
            return this.licenseName;
        }

        public void setLicenseName(String licenseName) {
            this.licenseName = licenseName;
        }

        public String getDeprecatedVersion() {
            return this.deprecatedVersion;
        }

        public void setDeprecatedVersion(String deprecatedVersion) {
            this.deprecatedVersion = deprecatedVersion;
        }
    }
}

