/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licensexml;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.licensexml.LicenseXmlDocument;
import org.spdx.licensexml.LicenseXmlException;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.ISpdxListedLicenseProvider;
import org.spdx.rdfparser.license.LicenseException;
import org.spdx.rdfparser.license.LicenseRestrictionException;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.spdx.rdfparser.license.SpdxListedLicenseException;
import org.spdx.spdxspreadsheet.SPDXLicenseSpreadsheet;
import org.spdx.spdxspreadsheet.SpreadsheetException;

public class XmlLicenseProvider
implements ISpdxListedLicenseProvider {
    Logger logger = LoggerFactory.getLogger((String)XmlLicenseProvider.class.getName());
    private List<String> warnings = new ArrayList<String>();
    private List<File> xmlFiles = new ArrayList<File>();

    public XmlLicenseProvider(File xmlFileDirectory) throws SpdxListedLicenseException {
        if (!xmlFileDirectory.isDirectory()) {
            throw new SpdxListedLicenseException("XML File Directory is not a directory");
        }
        this.xmlFiles = new ArrayList<File>();
        this.addXmlFiles(xmlFileDirectory, this.xmlFiles);
    }

    private void addXmlFiles(File xmlFileDirectory, List<File> alFiles) {
        File[] localFiles;
        File[] directories = xmlFileDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (directories != null) {
            for (File subDir : directories) {
                this.addXmlFiles(subDir, alFiles);
            }
        }
        if ((localFiles = xmlFileDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && "xml".equals(Files.getFileExtension((String)pathname.getName().toLowerCase()));
            }
        })) != null) {
            for (File file : localFiles) {
                alFiles.add(file);
            }
        }
    }

    @Override
    public Iterator<SpdxListedLicense> getLicenseIterator() throws SpdxListedLicenseException {
        return new XmlLicenseIterator();
    }

    @Override
    public Iterator<LicenseException> getExceptionIterator() throws LicenseRestrictionException, SpreadsheetException {
        return new XmlExceptionIterator();
    }

    @Override
    public Iterator<SPDXLicenseSpreadsheet.DeprecatedLicenseInfo> getDeprecatedLicenseIterator() {
        return new XmlDeprecatedLicenseIterator();
    }

    @Override
    public List<String> getWarnings() {
        return this.warnings;
    }

    class XmlDeprecatedLicenseIterator
    implements Iterator<SPDXLicenseSpreadsheet.DeprecatedLicenseInfo> {
        private int xmlFileIndex = 0;
        private SPDXLicenseSpreadsheet.DeprecatedLicenseInfo nextDeprecatedLicense = null;
        private Iterator<SPDXLicenseSpreadsheet.DeprecatedLicenseInfo> fileDeprecatedLicenses = null;

        public XmlDeprecatedLicenseIterator() {
            this.findNextItem();
        }

        private void findNextItem() {
            this.nextDeprecatedLicense = null;
            if (this.fileDeprecatedLicenses == null || !this.fileDeprecatedLicenses.hasNext()) {
                this.fileDeprecatedLicenses = null;
                while (this.xmlFileIndex < XmlLicenseProvider.this.xmlFiles.size() && this.fileDeprecatedLicenses == null) {
                    try {
                        LicenseXmlDocument licDoc = new LicenseXmlDocument((File)XmlLicenseProvider.this.xmlFiles.get(this.xmlFileIndex));
                        List<SPDXLicenseSpreadsheet.DeprecatedLicenseInfo> depList = licDoc.getDeprecatedLicenseInfos();
                        if (depList != null && !depList.isEmpty()) {
                            this.fileDeprecatedLicenses = depList.iterator();
                        }
                    }
                    catch (LicenseXmlException e) {
                        XmlLicenseProvider.this.warnings.add(e.getMessage() + ", Skipping file " + ((File)XmlLicenseProvider.this.xmlFiles.get(this.xmlFileIndex)).getName());
                        XmlLicenseProvider.this.logger.warn(e.getMessage() + ", Skipping file " + ((File)XmlLicenseProvider.this.xmlFiles.get(this.xmlFileIndex)).getName());
                    }
                    catch (InvalidSPDXAnalysisException e) {
                        XmlLicenseProvider.this.warnings.add(e.getMessage() + ", Skipping file " + ((File)XmlLicenseProvider.this.xmlFiles.get(this.xmlFileIndex)).getName());
                        XmlLicenseProvider.this.logger.warn(e.getMessage() + ", Skipping file " + ((File)XmlLicenseProvider.this.xmlFiles.get(this.xmlFileIndex)).getName());
                    }
                    ++this.xmlFileIndex;
                }
            }
            if (this.fileDeprecatedLicenses != null && this.fileDeprecatedLicenses.hasNext()) {
                this.nextDeprecatedLicense = this.fileDeprecatedLicenses.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextDeprecatedLicense != null;
        }

        @Override
        public SPDXLicenseSpreadsheet.DeprecatedLicenseInfo next() {
            SPDXLicenseSpreadsheet.DeprecatedLicenseInfo retval = this.nextDeprecatedLicense;
            this.findNextItem();
            return retval;
        }

        @Override
        public void remove() {
        }
    }

    class XmlExceptionIterator
    implements Iterator<LicenseException> {
        private int xmlFileIndex = 0;
        private LicenseException nextLicenseException = null;
        private Iterator<LicenseException> fileExceptionIterator = null;

        public XmlExceptionIterator() {
            this.findNextItem();
        }

        private void findNextItem() {
            this.nextLicenseException = null;
            if (this.fileExceptionIterator == null || !this.fileExceptionIterator.hasNext()) {
                this.fileExceptionIterator = null;
                while (this.xmlFileIndex < XmlLicenseProvider.this.xmlFiles.size() && this.fileExceptionIterator == null) {
                    try {
                        LicenseXmlDocument licDoc = new LicenseXmlDocument((File)XmlLicenseProvider.this.xmlFiles.get(this.xmlFileIndex));
                        List<LicenseException> exceptionList = licDoc.getLicenseExceptions();
                        if (exceptionList != null && !exceptionList.isEmpty()) {
                            this.fileExceptionIterator = exceptionList.iterator();
                        }
                    }
                    catch (LicenseXmlException e) {
                        XmlLicenseProvider.this.warnings.add(e.getMessage() + ", Skipping file " + ((File)XmlLicenseProvider.this.xmlFiles.get(this.xmlFileIndex)).getName());
                        XmlLicenseProvider.this.logger.warn(e.getMessage() + ", Skipping file " + ((File)XmlLicenseProvider.this.xmlFiles.get(this.xmlFileIndex)).getName());
                    }
                    ++this.xmlFileIndex;
                }
            }
            if (this.fileExceptionIterator != null && this.fileExceptionIterator.hasNext()) {
                this.nextLicenseException = this.fileExceptionIterator.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextLicenseException != null;
        }

        @Override
        public LicenseException next() {
            LicenseException retval = this.nextLicenseException;
            this.findNextItem();
            return retval;
        }

        @Override
        public void remove() {
        }
    }

    class XmlLicenseIterator
    implements Iterator<SpdxListedLicense> {
        private int xmlFileIndex = 0;
        private SpdxListedLicense nextListedLicense = null;
        private Iterator<SpdxListedLicense> fileListedLicenseIter = null;

        public XmlLicenseIterator() {
            this.findNextItem();
        }

        private void findNextItem() {
            this.nextListedLicense = null;
            if (this.fileListedLicenseIter == null || !this.fileListedLicenseIter.hasNext()) {
                this.fileListedLicenseIter = null;
                while (this.xmlFileIndex < XmlLicenseProvider.this.xmlFiles.size() && this.fileListedLicenseIter == null) {
                    try {
                        LicenseXmlDocument licDoc = new LicenseXmlDocument((File)XmlLicenseProvider.this.xmlFiles.get(this.xmlFileIndex));
                        try {
                            List<SpdxListedLicense> licList = licDoc.getListedLicenses();
                            if (licList == null || licList.isEmpty()) continue;
                            this.fileListedLicenseIter = licList.iterator();
                        }
                        catch (InvalidSPDXAnalysisException e) {
                            XmlLicenseProvider.this.warnings.add(e.getMessage() + ", Skipping file " + ((File)XmlLicenseProvider.this.xmlFiles.get(this.xmlFileIndex)).getName());
                            XmlLicenseProvider.this.logger.warn(e.getMessage() + ", Skipping file " + ((File)XmlLicenseProvider.this.xmlFiles.get(this.xmlFileIndex)).getName());
                        }
                    }
                    catch (LicenseXmlException e) {
                        XmlLicenseProvider.this.warnings.add(e.getMessage() + ", Skipping file " + ((File)XmlLicenseProvider.this.xmlFiles.get(this.xmlFileIndex)).getName());
                        XmlLicenseProvider.this.logger.warn(e.getMessage() + ", Skipping file " + ((File)XmlLicenseProvider.this.xmlFiles.get(this.xmlFileIndex)).getName());
                    }
                    finally {
                        ++this.xmlFileIndex;
                    }
                }
            }
            if (this.fileListedLicenseIter != null && this.fileListedLicenseIter.hasNext()) {
                this.nextListedLicense = this.fileListedLicenseIter.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextListedLicense != null;
        }

        @Override
        public SpdxListedLicense next() {
            SpdxListedLicense retval = this.nextListedLicense;
            this.findNextItem();
            return retval;
        }

        @Override
        public void remove() {
        }
    }
}

