/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.model.pointer;

import com.google.common.base.Objects;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.model.IRdfModel;
import org.spdx.rdfparser.model.SpdxElement;
import org.spdx.rdfparser.model.pointer.SinglePointer;

public class ByteOffsetPointer
extends SinglePointer {
    private Integer offset;

    public ByteOffsetPointer(SpdxElement reference, int offset) {
        super(reference);
        this.offset = offset;
    }

    public ByteOffsetPointer(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        super(modelContainer, node);
        this.getMyPropertiesFromModel();
    }

    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
        super.getPropertiesFromModel();
        this.getMyPropertiesFromModel();
    }

    private void getMyPropertiesFromModel() throws InvalidSPDXAnalysisException {
        this.offset = this.findIntPropertyValue("http://www.w3.org/2009/pointers#", "offset");
    }

    @Override
    public String getUri(IModelContainer modelContainer) throws InvalidSPDXAnalysisException {
        return null;
    }

    @Override
    public Resource getType(Model model) {
        return model.createResource("http://www.w3.org/2009/pointers#ByteOffsetPointer");
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
        super.populateModel();
        this.setPropertyValue("http://www.w3.org/2009/pointers#", "offset", this.offset);
    }

    @Override
    public boolean equivalent(IRdfModel o) {
        if (!super.equivalent(o)) {
            return false;
        }
        if (!(o instanceof ByteOffsetPointer)) {
            return false;
        }
        ByteOffsetPointer comp = (ByteOffsetPointer)o;
        return Objects.equal((Object)this.getOffset(), (Object)comp.getOffset());
    }

    public Integer getOffset() {
        if (this.resource != null && this.refreshOnGet) {
            this.offset = this.findIntPropertyValue("http://www.w3.org/2009/pointers#", "offset");
        }
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
        this.setPropertyValue("http://www.w3.org/2009/pointers#", "offset", this.offset);
    }

    @Override
    public List<String> verify() {
        List<String> retval = super.verify();
        if (this.offset == null) {
            retval.add("Missing byte offset offset value");
        } else if (this.offset < 0) {
            retval.add("Offset most not be negative for a byte pointer: " + this.offset.toString());
        }
        return retval;
    }

    @Override
    public ByteOffsetPointer clone() {
        SpdxElement newReference = null;
        if (this.reference != null) {
            newReference = this.reference.clone();
        }
        return new ByteOffsetPointer(newReference, this.offset);
    }

    @Override
    public int compareTo(SinglePointer o) {
        if (o == null) {
            return 1;
        }
        int retval = this.compareReferences(o);
        if (retval != 0) {
            return retval;
        }
        if (!(o instanceof ByteOffsetPointer)) {
            return 1;
        }
        Integer compByteOffset = ((ByteOffsetPointer)o).getOffset();
        if (this.offset == null) {
            return -1;
        }
        return this.offset.compareTo(compByteOffset);
    }

    public String toString() {
        if (this.offset != null) {
            return "byte offset " + this.offset.toString();
        }
        return "Unknown byte offset";
    }
}

