/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.referencetype;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.referencetype.ReferenceType;

public class ListedReferenceTypes {
    static final Logger logger = LoggerFactory.getLogger(ListedReferenceTypes.class);
    private static final ReadWriteLock listedReferenceTypesModificationLock = new ReentrantReadWriteLock();
    private static final String LISTED_REFERENCE_TYPE__RDF_LOCAL_DIR = "resources/listedexternaltypes";
    private static final String LISTED_REFERENCE_TYPE_PROPERTIES_FILENAME = "resources/listedexternaltypes/listedreferencetypes.properties";
    private static final String LISTED_REFERENCE_TYPE_PROPERTIES_CLASS_PATH = "org/spdx/rdfparser/referencetype/listedreferencetypes.properties";
    private static final String PROPERTY_LISTED_REFERENCE_TYPES = "listedReferenceTypes";
    private static ListedReferenceTypes listedReferenceTypes;
    private Properties listedReferenceTypeProperties;
    List<String> listedReferenceNames = new ArrayList<String>();
    ConcurrentMap<String, ReferenceType> listedReferenceTypeCache = Maps.newConcurrentMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListedReferenceTypes() {
        this.listedReferenceTypeProperties = new Properties();
        InputStream in = null;
        try {
            in = LicenseInfoFactory.class.getResourceAsStream("/resources/listedexternaltypes/listedreferencetypes.properties");
            this.listedReferenceTypeProperties.load(in);
        }
        catch (IOException e) {
            logger.warn("IO Exception reading listed reference type properties file: " + e.getMessage() + ", loading properties from class properties file.");
            try {
                in = ListedReferenceTypes.class.getClassLoader().getResourceAsStream(LISTED_REFERENCE_TYPE_PROPERTIES_CLASS_PATH);
                this.listedReferenceTypeProperties.load(in);
            }
            catch (IOException ex2) {
                logger.error("IO exception reading listed reference type properties from class properties file: " + e.getMessage());
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.warn("Unable to close listed license properties file: " + e.getMessage());
                }
            }
        }
        this.loadReferenceTypeNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadReferenceTypeNames() {
        listedReferenceTypesModificationLock.readLock().lock();
        try {
            String[] referenceTypeNamesAr;
            String referenceTypeNamesStr = this.listedReferenceTypeProperties.getProperty(PROPERTY_LISTED_REFERENCE_TYPES);
            for (String name : referenceTypeNamesAr = referenceTypeNamesStr.split(",")) {
                this.listedReferenceNames.add(name.trim());
            }
        }
        finally {
            listedReferenceTypesModificationLock.readLock().unlock();
        }
    }

    public static ListedReferenceTypes getListedReferenceTypes() {
        if (listedReferenceTypes == null) {
            listedReferenceTypesModificationLock.writeLock().lock();
            try {
                if (listedReferenceTypes == null) {
                    listedReferenceTypes = new ListedReferenceTypes();
                }
            }
            finally {
                listedReferenceTypesModificationLock.writeLock().unlock();
            }
        }
        return listedReferenceTypes;
    }

    public static ListedReferenceTypes resetListedReferenceTypes() {
        listedReferenceTypesModificationLock.writeLock().lock();
        try {
            ListedReferenceTypes listedReferenceTypes = ListedReferenceTypes.listedReferenceTypes = new ListedReferenceTypes();
            return listedReferenceTypes;
        }
        finally {
            listedReferenceTypesModificationLock.writeLock().unlock();
        }
    }

    public boolean isListedReferenceType(URI uri) {
        if (uri.toString().startsWith("http://spdx.org/rdf/references/")) {
            String referenceTypeName = uri.toString().substring("http://spdx.org/rdf/references/".length());
            return this.listedReferenceNames.contains(referenceTypeName);
        }
        return false;
    }

    public URI getListedReferenceUri(String listedReferenceName) throws InvalidSPDXAnalysisException {
        URI retval;
        try {
            retval = new URI("http://spdx.org/rdf/references/" + listedReferenceName);
        }
        catch (URISyntaxException e) {
            logger.error("Error forming listed license URI", (Throwable)e);
            throw new InvalidSPDXAnalysisException(listedReferenceName + " is not a valid SPDX listed reference type syntax.");
        }
        if (!this.isListedReferenceType(retval)) {
            throw new InvalidSPDXAnalysisException(listedReferenceName + " is not a valid SPDX listed reference type.");
        }
        return retval;
    }

    public ReferenceType getListedReferenceTypeByName(String listedReferenceName) throws InvalidSPDXAnalysisException {
        URI listedRefUri;
        ReferenceType oldValue;
        ReferenceType retval = (ReferenceType)this.listedReferenceTypeCache.get(listedReferenceName);
        if (retval == null && (oldValue = this.listedReferenceTypeCache.putIfAbsent(listedReferenceName, retval = new ReferenceType(listedRefUri = this.getListedReferenceUri(listedReferenceName), null, null, null))) != null) {
            retval = oldValue;
        }
        return retval;
    }

    public String getListedReferenceName(URI uri) throws InvalidSPDXAnalysisException {
        if (!this.isListedReferenceType(uri)) {
            throw new InvalidSPDXAnalysisException(uri.toString() + " is not a valid URI for an SPDX listed reference type.");
        }
        return uri.toString().substring("http://spdx.org/rdf/references/".length());
    }
}

