/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import java.io.File;
import java.text.SimpleDateFormat;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.licenseTemplate.LicenseTemplateRuleException;
import org.spdx.licenseTemplate.SpdxLicenseTemplateHelper;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.spdx.spdxspreadsheet.AbstractSheet;
import org.spdx.spdxspreadsheet.LicenseSheet;

public class DeprecatedLicenseSheet
extends AbstractSheet {
    static final Logger logger = LoggerFactory.getLogger((String)LicenseSheet.class.getName());
    static final int NUM_COLS = 8;
    static final int COL_NAME = 0;
    static final int COL_ID = 1;
    static final int COL_SOURCE_URL = 2;
    static final int COL_NOTES = 3;
    static final int COL_OSI_APPROVED = 4;
    static final int COL_STANDARD_LICENSE_HEADER = 5;
    static final int COL_TEMPLATE = 6;
    static final int COL_DEPRECATED_VERSION = 7;
    static final SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy");
    static final boolean[] REQUIRED = new boolean[]{true, true, false, false, false, false, true, false, true};
    static final String[] HEADER_TITLES = new String[]{"Full name of License", "License Identifier", "Source/url", "Notes on Deprecation", "OSI Approved", "Standard License Header", "Template", "Deprecated as of:"};
    static final String TEXT_EXTENSION = ".txt";
    static final String ENCODING = "UTF-8";
    String workbookPath;

    public DeprecatedLicenseSheet(Workbook workbook, String sheetName, File workbookFile) {
        super(workbook, sheetName);
        this.workbookPath = workbookFile.getParent();
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        Row row = sheet.createRow(0);
        for (int i = 0; i < HEADER_TITLES.length; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(HEADER_TITLES[i]);
        }
    }

    public void add(SpdxListedLicense license, String deprecatedVersion) {
        Row row = this.addRow();
        Cell nameCell = row.createCell(0);
        nameCell.setCellValue(license.getName());
        Cell idCell = row.createCell(1);
        idCell.setCellValue(license.getLicenseId());
        if (license.getSeeAlso() != null && license.getSeeAlso().length > 0) {
            Cell sourceUrlCell = row.createCell(2);
            StringBuilder sb = new StringBuilder();
            sb.append(license.getSeeAlso()[0]);
            for (int i = 1; i < license.getSeeAlso().length; ++i) {
                sb.append(' ');
                sb.append(license.getSeeAlso()[i]);
            }
            sourceUrlCell.setCellValue(sb.toString());
        }
        if (license.getComment() != null) {
            Cell notesCell = row.createCell(3);
            notesCell.setCellValue(license.getComment());
        }
        if (license.getStandardLicenseHeader() != null) {
            Cell standardLicenseHeaderCell = row.createCell(5);
            standardLicenseHeaderCell.setCellValue(license.getStandardLicenseHeader());
        }
        Cell templateCell = row.createCell(6);
        String templateText = license.getStandardLicenseTemplate();
        if (templateText == null || templateText.trim().isEmpty()) {
            templateText = license.getLicenseText();
        }
        LicenseSheet.setTemplateText(templateCell, templateText, license.getLicenseId(), this.workbookPath, this.workbook);
        if (license.isOsiApproved()) {
            Cell osiApprovedCell = row.createCell(4);
            osiApprovedCell.setCellValue("YES");
        }
        Cell deprecatedVersionCell = row.createCell(7);
        deprecatedVersionCell.setCellValue(deprecatedVersion);
    }

    public SpdxListedLicense getLicense(int rowNum) throws InvalidSPDXAnalysisException {
        String osiApprovedStr;
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        String id = null;
        Cell idCell = row.getCell(1);
        if (idCell != null) {
            id = idCell.getStringCellValue();
        }
        String name = null;
        Cell nameCell = row.getCell(0);
        if (nameCell != null) {
            name = nameCell.getStringCellValue();
        }
        String notes = null;
        Cell notesCell = row.getCell(3);
        if (notesCell != null) {
            notes = notesCell.getStringCellValue();
        }
        String[] sourceURL = null;
        Cell sourceURLCell = row.getCell(2);
        if (sourceURLCell != null) {
            try {
                String stSourceURL = sourceURLCell.getStringCellValue();
                sourceURL = stSourceURL.split("\\s");
                for (int i = 0; i < sourceURL.length; ++i) {
                    sourceURL[i] = sourceURL[i].trim();
                }
            }
            catch (Exception ex) {
                sourceURL = new String[]{"Exception getting URL: " + ex.getMessage()};
            }
        }
        String stdLicHeader = null;
        Cell stdLicHeaderCell = row.getCell(5);
        if (stdLicHeaderCell != null) {
            stdLicHeader = stdLicHeaderCell.getStringCellValue();
        }
        String template = null;
        String text = null;
        Cell templateCell = row.getCell(6);
        if (templateCell != null) {
            template = LicenseSheet.getLicenseTemplateText(templateCell, this.workbookPath);
            try {
                text = SpdxLicenseTemplateHelper.templateToText(template);
            }
            catch (LicenseTemplateRuleException e) {
                throw new InvalidSPDXAnalysisException("Invalid template for " + id + ": " + e.getMessage(), e);
            }
        }
        boolean osiApproved = false;
        Cell osiApprovedCell = row.getCell(4);
        if (osiApprovedCell != null && (osiApprovedStr = osiApprovedCell.getStringCellValue()) != null && !osiApprovedStr.isEmpty() && osiApprovedStr.toUpperCase().trim().charAt(0) == 'Y') {
            osiApproved = true;
        }
        return new SpdxListedLicense(name, id, text, sourceURL, notes, stdLicHeader, template, osiApproved);
    }

    public String getDeprecatedVersion(int rowNum) {
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        Cell deprecatedVersionCell = row.getCell(7);
        if (deprecatedVersionCell == null) {
            return null;
        }
        return deprecatedVersionCell.getStringCellValue();
    }

    @Override
    public String verify() {
        try {
            if (this.sheet == null) {
                return "Worksheet for Deprecated Licenses does not exist";
            }
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            for (int i = 0; i < 8; ++i) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell != null && cell.getStringCellValue() != null && cell.getStringCellValue().equals(HEADER_TITLES[i])) continue;
                return "Column " + HEADER_TITLES[i] + " missing for Deprecated Licenses worksheet";
            }
            boolean done = false;
            int rowNum = this.firstRowNum + 1;
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(this.firstCellNum) == null) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying Deprecated License work sheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        for (int i = 0; i < 8; ++i) {
            Cell cell = row.getCell(i);
            if (cell != null || !REQUIRED[i]) continue;
            return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(row.getRowNum());
        }
        return null;
    }
}

