/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.ISpdxListedLicenseProvider;
import org.spdx.rdfparser.license.LicenseException;
import org.spdx.rdfparser.license.LicenseRestrictionException;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.spdx.spdxspreadsheet.AbstractSpreadsheet;
import org.spdx.spdxspreadsheet.DeprecatedLicenseSheet;
import org.spdx.spdxspreadsheet.LicenseExceptionSheet;
import org.spdx.spdxspreadsheet.LicenseSheet;
import org.spdx.spdxspreadsheet.SpreadsheetException;

public class SPDXLicenseSpreadsheet
extends AbstractSpreadsheet
implements ISpdxListedLicenseProvider {
    static final String LICENSE_SHEET_NAME = "Licenses";
    static final String EXCEPTION_SHEET_NAME = "exceptions";
    static final String DEPRECATED_SHEET_NAME = "deprecated";
    private LicenseSheet licenseSheet;
    private LicenseExceptionSheet exceptionSheet;
    private DeprecatedLicenseSheet deprecatedLicenseSheet;
    private List<String> warnings = new ArrayList<String>();

    public SPDXLicenseSpreadsheet(File spreadsheetFile, boolean create, boolean readonly) throws SpreadsheetException {
        super(spreadsheetFile, create, readonly);
        this.licenseSheet = new LicenseSheet(this.workbook, LICENSE_SHEET_NAME, spreadsheetFile);
        this.deprecatedLicenseSheet = new DeprecatedLicenseSheet(this.workbook, DEPRECATED_SHEET_NAME, spreadsheetFile);
        this.exceptionSheet = new LicenseExceptionSheet(this.workbook, EXCEPTION_SHEET_NAME);
        String verifyMsg = this.verifyWorkbook();
        if (verifyMsg != null) {
            logger.error(verifyMsg);
            throw new SpreadsheetException(verifyMsg);
        }
    }

    @Override
    public void create(File spreadsheetFile) throws IOException, SpreadsheetException {
        this.create(spreadsheetFile, "Unknown", "Unknown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(File spreadsheetFile, String version, String releaseDate) throws IOException, SpreadsheetException {
        if (!spreadsheetFile.createNewFile()) {
            logger.error("Unable to create " + spreadsheetFile.getName());
            throw new SpreadsheetException("Unable to create " + spreadsheetFile.getName());
        }
        try (FileOutputStream excelOut = null;){
            excelOut = new FileOutputStream(spreadsheetFile);
            HSSFWorkbook wb = new HSSFWorkbook();
            LicenseSheet.create((Workbook)wb, LICENSE_SHEET_NAME, version, releaseDate);
            LicenseExceptionSheet.create((Workbook)wb, EXCEPTION_SHEET_NAME);
            DeprecatedLicenseSheet.create((Workbook)wb, DEPRECATED_SHEET_NAME);
            wb.write((OutputStream)excelOut);
        }
    }

    @Override
    public void clear() {
        this.licenseSheet.clear();
        this.exceptionSheet.clear();
        this.deprecatedLicenseSheet.clear();
    }

    @Override
    public String verifyWorkbook() {
        String retval = this.exceptionSheet.verify();
        if (retval != null && !retval.isEmpty()) {
            return retval;
        }
        retval = this.deprecatedLicenseSheet.verify();
        if (retval != null && !retval.isEmpty()) {
            return retval;
        }
        return this.licenseSheet.verify();
    }

    public LicenseSheet getLicenseSheet() {
        return this.licenseSheet;
    }

    @Override
    public Iterator<SpdxListedLicense> getLicenseIterator() {
        try {
            return new LicenseIterator();
        }
        catch (SpreadsheetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<DeprecatedLicenseInfo> getDeprecatedLicenseIterator() {
        try {
            return new DeprecatedLicenseIterator();
        }
        catch (SpreadsheetException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<LicenseException> getExceptionIterator() throws LicenseRestrictionException, SpreadsheetException {
        return new LicenseExceptionIterator();
    }

    public LicenseExceptionSheet getLicenseExceptionSheet() {
        return this.exceptionSheet;
    }

    public DeprecatedLicenseSheet getDeprecatedLicenseSheet() {
        return this.deprecatedLicenseSheet;
    }

    @Override
    public List<String> getWarnings() {
        return this.warnings;
    }

    public class DeprecatedLicenseIterator
    implements Iterator<DeprecatedLicenseInfo> {
        private int currentRowNum;
        DeprecatedLicenseInfo currentDeprecatedLicense;

        public DeprecatedLicenseIterator() throws SpreadsheetException, InvalidSPDXAnalysisException {
            this.currentRowNum = SPDXLicenseSpreadsheet.this.deprecatedLicenseSheet.getFirstDataRow();
            this.updateCurrentDeprecatedLicense();
        }

        private void updateCurrentDeprecatedLicense() throws InvalidSPDXAnalysisException {
            SpdxListedLicense license = SPDXLicenseSpreadsheet.this.deprecatedLicenseSheet.getLicense(this.currentRowNum);
            this.currentDeprecatedLicense = license == null ? null : new DeprecatedLicenseInfo(license, SPDXLicenseSpreadsheet.this.deprecatedLicenseSheet.getDeprecatedVersion(this.currentRowNum));
        }

        @Override
        public boolean hasNext() {
            return this.currentDeprecatedLicense != null;
        }

        @Override
        public DeprecatedLicenseInfo next() {
            DeprecatedLicenseInfo retval = this.currentDeprecatedLicense;
            ++this.currentRowNum;
            try {
                this.updateCurrentDeprecatedLicense();
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new RuntimeException(e);
            }
            return retval;
        }

        @Override
        public void remove() {
        }
    }

    public static class DeprecatedLicenseInfo {
        private SpdxListedLicense license;
        private String deprecatedVersion;

        public DeprecatedLicenseInfo(SpdxListedLicense license, String deprecatedVersion) {
            this.license = license;
            this.deprecatedVersion = deprecatedVersion;
        }

        public SpdxListedLicense getLicense() {
            return this.license;
        }

        public void setLicense(SpdxListedLicense license) {
            this.license = license;
        }

        public String getDeprecatedVersion() {
            return this.deprecatedVersion;
        }

        public void setDeprecatedVersion(String deprecatedVersion) {
            this.deprecatedVersion = deprecatedVersion;
        }
    }

    public class LicenseExceptionIterator
    implements Iterator<LicenseException> {
        private int currentRowNum;
        LicenseException currentException;

        public LicenseExceptionIterator() throws SpreadsheetException {
            this.currentRowNum = SPDXLicenseSpreadsheet.this.exceptionSheet.getFirstDataRow();
            this.currentException = SPDXLicenseSpreadsheet.this.exceptionSheet.getException(this.currentRowNum);
        }

        @Override
        public boolean hasNext() {
            return this.currentException != null;
        }

        @Override
        public LicenseException next() {
            LicenseException retval = this.currentException;
            ++this.currentRowNum;
            this.currentException = SPDXLicenseSpreadsheet.this.exceptionSheet.getException(this.currentRowNum);
            return retval;
        }

        @Override
        public void remove() {
        }
    }

    public class LicenseIterator
    implements Iterator<SpdxListedLicense> {
        private int currentRowNum;
        SpdxListedLicense currentLicense;

        public LicenseIterator() throws SpreadsheetException {
            this.currentRowNum = SPDXLicenseSpreadsheet.this.licenseSheet.getFirstDataRow();
            try {
                this.currentLicense = SPDXLicenseSpreadsheet.this.licenseSheet.getLicense(this.currentRowNum);
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new SpreadsheetException(e.getMessage());
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentLicense != null;
        }

        @Override
        public SpdxListedLicense next() {
            SpdxListedLicense retval = this.currentLicense;
            ++this.currentRowNum;
            try {
                this.currentLicense = SPDXLicenseSpreadsheet.this.licenseSheet.getLicense(this.currentRowNum);
            }
            catch (InvalidSPDXAnalysisException e) {
                throw new RuntimeException(e.getMessage());
            }
            return retval;
        }

        @Override
        public void remove() {
        }
    }
}

