/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.spdx.licensexml.LicenseXmlException;
import org.spdx.rdfparser.SpdxRdfConstants;
import org.spdx.tools.LicenseXmlConverterException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ConvertLicenseListXml
implements SpdxRdfConstants {
    public static final String OLD_ROOT_ELEMENT_NAME = "SPDX";
    public static final String OLD_NAME_ATTRIBUTE = "name";
    public static final String OLD_ID_ATTRIBUTE = "identifier";
    public static final String OLD_LICENSE_TAG = "license";
    public static final String OLD_EXCEPTION_TAG = "exception";
    public static final String OLD_BODY_TAG = "body";
    public static final String OLD_DEPRECATED_ATTRIBUTE = "deprecated";
    public static final String OLD_NOTES_TAG = "notes";
    public static final String OLD_URLS_TAG = "urls";
    public static final String OLD_URL_TAG = "url";
    public static final String OLD_HEADER_TAG = "header";
    public static final String OLD_OSI_APPROVED_ATTRIBUTE = "osi-approved";
    public static final String OLD_COPYRIGHT_TAG = "copyright";
    public static final String OLD_TITLE_TAG = "title";
    public static final String OLD_LIST_ITEM_TAG = "li";
    public static final String OLD_LIST_TAG = "list";
    public static final String OLD_ALTERNATIVE_TAG = "alt";
    public static final String OLD_OPTIONAL_TAG = "optional";
    public static final String OLD_BREAK_TAG = "br";
    public static final String OLD_PARAGRAPH_TAG = "p";
    public static final String OLD_VAR_NAME_ATTRIBUTE = "name";
    public static final String OLD_VAR_ORIGINAL_ATTRIBUTE = "original";
    public static final String OLD_VAR_MATCH_ATTRIBUTE = "match";
    public static final String OLD_BULLET_TAG = "b";
    private static final String OLD_LICENSE_LIST_VERSION_ATTRIBUTE = "listVersionAdded";
    private static final String NAMESPACE = "http://www.spdx.org/license";
    public static Map<String, String> TAG_MAP = new HashMap<String, String>();

    public static void main(String[] args) {
        File[] directoryFiles;
        File outputDirFile;
        Path outputDir;
        Path inputDir;
        if (args.length != 2) {
            ConvertLicenseListXml.error("Invalid number of parameters");
        }
        if (!Files.exists(inputDir = Paths.get(args[0].trim(), new String[0]), new LinkOption[0])) {
            ConvertLicenseListXml.error("Input directory " + args[0] + " does not exist");
        }
        if (!Files.isDirectory(inputDir, new LinkOption[0])) {
            ConvertLicenseListXml.error(args[0] + " is not a directory");
        }
        if (!Files.exists(outputDir = Paths.get(args[1].trim(), new String[0]), new LinkOption[0])) {
            ConvertLicenseListXml.error("Output directory " + args[1] + " does not exist");
        }
        if (!Files.isDirectory(outputDir, new LinkOption[0])) {
            ConvertLicenseListXml.error(args[1] + " is not a directory");
        }
        if ((outputDirFile = outputDir.toFile()) != null && (directoryFiles = outputDirFile.listFiles()) != null && directoryFiles.length > 0) {
            ConvertLicenseListXml.error("Output directory must be empty");
        }
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(inputDir, "*.xml");){
            for (Path inputFile : dirStream) {
                Path outputFile = outputDir.resolve(inputFile.getFileName());
                try {
                    ConvertLicenseListXml.convertLicenseXmlFile(inputFile, outputFile);
                }
                catch (LicenseXmlException e) {
                    System.out.println("Error convering " + inputFile.getFileName() + ".  Skipping. : " + e.getMessage());
                }
            }
        }
        catch (DirectoryIteratorException ex) {
            ConvertLicenseListXml.error("Error listing input directory: " + ex.getMessage());
        }
        catch (IOException ex) {
            ConvertLicenseListXml.error("IO error: " + ex.getMessage());
        }
        catch (LicenseXmlConverterException e) {
            ConvertLicenseListXml.error("Conversion error: " + e.getMessage());
        }
    }

    public static void convertLicenseXmlFile(Path inputFile, Path outputFile) throws LicenseXmlConverterException, LicenseXmlException {
        Document inputXmlDocument;
        DocumentBuilder builder;
        if (!Files.exists(inputFile, new LinkOption[0])) {
            throw new LicenseXmlConverterException("Input file " + inputFile.toString() + " does not exist.");
        }
        if (!Files.exists(outputFile, new LinkOption[0])) {
            try {
                Files.createFile(outputFile, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new LicenseXmlConverterException("Error creating output file: " + e.getMessage(), e);
            }
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new LicenseXmlConverterException("Error creating parser for license XML file");
        }
        try {
            inputXmlDocument = builder.parse(inputFile.toFile());
        }
        catch (SAXException e) {
            throw new LicenseXmlConverterException("Unable to parse license XML file " + inputFile.getFileName() + ": " + e.getMessage());
        }
        catch (IOException e) {
            throw new LicenseXmlConverterException("I/O Error reading XML file" + inputFile.getFileName() + ": " + e.getMessage());
        }
        try {
            ConvertLicenseListXml.assertValid(inputXmlDocument);
        }
        catch (LicenseXmlConverterException ex) {
            throw new LicenseXmlConverterException("File " + inputFile.getFileName() + " is invalid: " + ex.getMessage());
        }
        Document outputXmlDocument = builder.newDocument();
        ConvertLicenseListXml.convertLicenseXmlDocument(inputXmlDocument, outputXmlDocument);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new LicenseXmlConverterException("Unable to create XML transformer: " + e.getMessage());
        }
        DOMSource source = new DOMSource(outputXmlDocument);
        StreamResult result = new StreamResult(outputFile.toFile());
        try {
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new LicenseXmlConverterException("Error saving the converted XML file" + outputFile.getFileName() + ": " + e.getMessage());
        }
    }

    private static void convertLicenseXmlDocument(Document inputXmlDocument, Document outputXmlDocument) throws LicenseXmlConverterException {
        Element inputRootElement = inputXmlDocument.getDocumentElement();
        Element outputRootElement = outputXmlDocument.createElementNS(NAMESPACE, "SPDXLicenseCollection");
        outputRootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE);
        outputXmlDocument.appendChild(outputRootElement);
        NodeList licenseNodes = inputRootElement.getElementsByTagName(OLD_LICENSE_TAG);
        for (int i = 0; i < licenseNodes.getLength(); ++i) {
            Element outputLicenseElement = outputXmlDocument.createElementNS(NAMESPACE, OLD_LICENSE_TAG);
            ConvertLicenseListXml.convertLicense(outputXmlDocument, inputRootElement, (Element)licenseNodes.item(i), outputLicenseElement);
            outputRootElement.appendChild(outputLicenseElement);
        }
        NodeList exceptioneNodes = inputRootElement.getElementsByTagName(OLD_EXCEPTION_TAG);
        for (int i = 0; i < exceptioneNodes.getLength(); ++i) {
            Element outputExceptionElement = outputXmlDocument.createElementNS(NAMESPACE, OLD_EXCEPTION_TAG);
            ConvertLicenseListXml.convertLicense(outputXmlDocument, inputRootElement, (Element)exceptioneNodes.item(i), outputExceptionElement);
            outputRootElement.appendChild(outputExceptionElement);
        }
    }

    private static void convertLicense(Document outputXmlDocument, Element inputRootElement, Element licenseOrException, Element outputElement) throws LicenseXmlConverterException {
        int i;
        NodeList urls;
        if (inputRootElement.hasAttribute(OLD_ID_ATTRIBUTE)) {
            outputElement.setAttribute("licenseId", inputRootElement.getAttribute(OLD_ID_ATTRIBUTE));
        }
        if (inputRootElement.hasAttribute(OLD_DEPRECATED_ATTRIBUTE)) {
            outputElement.setAttribute("isDeprecated", inputRootElement.getAttribute(OLD_DEPRECATED_ATTRIBUTE));
        }
        if (inputRootElement.hasAttribute("name")) {
            outputElement.setAttribute("name", inputRootElement.getAttribute("name"));
        }
        if (inputRootElement.hasAttribute(OLD_OSI_APPROVED_ATTRIBUTE)) {
            outputElement.setAttribute("isOsiApproved", inputRootElement.getAttribute(OLD_OSI_APPROVED_ATTRIBUTE));
        }
        if (inputRootElement.hasAttribute(OLD_LICENSE_LIST_VERSION_ATTRIBUTE)) {
            outputElement.setAttribute(OLD_LICENSE_LIST_VERSION_ATTRIBUTE, inputRootElement.getAttribute(OLD_LICENSE_LIST_VERSION_ATTRIBUTE));
        }
        if ((urls = inputRootElement.getElementsByTagName(OLD_URLS_TAG)).getLength() > 0) {
            Element outputCrossRefs = outputXmlDocument.createElementNS(NAMESPACE, "crossRefs");
            outputElement.appendChild(outputCrossRefs);
            for (i = 0; i < urls.getLength(); ++i) {
                NodeList urlsUrls = ((Element)urls.item(i)).getElementsByTagName(OLD_URL_TAG);
                for (int j = 0; j < urlsUrls.getLength(); ++j) {
                    Element outputCrossRef = outputXmlDocument.createElementNS(NAMESPACE, "crossRef");
                    outputCrossRef.setTextContent(urlsUrls.item(j).getTextContent());
                    outputCrossRefs.appendChild(outputCrossRef);
                }
            }
        }
        NodeList headers = inputRootElement.getElementsByTagName(OLD_HEADER_TAG);
        for (i = 0; i < headers.getLength(); ++i) {
            Element outputHeader = outputXmlDocument.createElementNS(NAMESPACE, "standardLicenseHeader");
            ConvertLicenseListXml.convertMixedBody((Element)headers.item(i), outputHeader, outputXmlDocument);
            outputElement.appendChild(outputHeader);
        }
        NodeList notes = inputRootElement.getElementsByTagName(OLD_NOTES_TAG);
        for (int i2 = 0; i2 < notes.getLength(); ++i2) {
            Element outputNotes = outputXmlDocument.createElementNS(NAMESPACE, OLD_NOTES_TAG);
            outputNotes.setTextContent(notes.item(i2).getTextContent());
            outputElement.appendChild(outputNotes);
        }
        ConvertLicenseListXml.convertMixedBody(licenseOrException, outputElement, outputXmlDocument);
    }

    private static Node convertNode(Node source, Document outputXmlDocument) throws LicenseXmlConverterException {
        if (source.getNodeType() == 1) {
            Element sourceElement = (Element)source;
            String tagName = TAG_MAP.get(sourceElement.getTagName());
            if (tagName == null) {
                throw new LicenseXmlConverterException("Unrecognized source element tag: " + sourceElement.getTagName());
            }
            Element destinationElement = outputXmlDocument.createElementNS(NAMESPACE, tagName);
            if (ConvertLicenseListXml.hasBulletFollowedByParagraph(sourceElement.getChildNodes())) {
                ConvertLicenseListXml.convertRemovingPragraphAfterBullet(sourceElement, destinationElement, outputXmlDocument);
            } else {
                ConvertLicenseListXml.convertMixedBody(sourceElement, destinationElement, outputXmlDocument);
            }
            return destinationElement;
        }
        if (source.getNodeType() == 2) {
            throw new LicenseXmlConverterException("Unexpected attribute: " + source.getNodeName());
        }
        if (source.getNodeType() == 3) {
            if (source.hasChildNodes()) {
                throw new LicenseXmlConverterException("Unexpected CDATA children");
            }
            return outputXmlDocument.createTextNode(((Text)source).getWholeText());
        }
        throw new LicenseXmlConverterException("Unexpected node type: " + source.getNodeType());
    }

    private static void convertRemovingPragraphAfterBullet(Element sourceElement, Element destinationElement, Document outputXmlDocument) throws LicenseXmlConverterException {
        if (!sourceElement.getTagName().equals(OLD_LIST_ITEM_TAG)) {
            throw new LicenseXmlConverterException("Can not convert removing paragraph after bullet for anything other than a list item");
        }
        NodeList children = sourceElement.getChildNodes();
        Element firstElement = null;
        Element secondElement = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node convertedNode;
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                if (firstElement == null) {
                    firstElement = (Element)child;
                    if (!firstElement.getTagName().equals(OLD_BULLET_TAG)) {
                        throw new LicenseXmlConverterException("Missing bullet tag");
                    }
                    convertedNode = ConvertLicenseListXml.convertNode(child, outputXmlDocument);
                    destinationElement.appendChild(convertedNode);
                    continue;
                }
                if (secondElement == null) {
                    secondElement = (Element)child;
                    if (!secondElement.getTagName().equals(OLD_PARAGRAPH_TAG)) {
                        throw new LicenseXmlConverterException("Missing paragraph tag");
                    }
                    NodeList grandChildren = secondElement.getChildNodes();
                    for (int j = 0; j < grandChildren.getLength(); ++j) {
                        Node convertedNode2 = ConvertLicenseListXml.convertNode(grandChildren.item(j), outputXmlDocument);
                        destinationElement.appendChild(convertedNode2);
                    }
                    continue;
                }
                convertedNode = ConvertLicenseListXml.convertNode(child, outputXmlDocument);
                destinationElement.appendChild(convertedNode);
                continue;
            }
            convertedNode = ConvertLicenseListXml.convertNode(child, outputXmlDocument);
            destinationElement.appendChild(convertedNode);
        }
    }

    private static boolean hasBulletFollowedByParagraph(NodeList childNodes) {
        Element firstElement = null;
        Element secondElement = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (childNodes.item(i).getNodeType() != 1) continue;
            Element childElement = (Element)childNodes.item(i);
            if (firstElement == null) {
                firstElement = childElement;
                if (firstElement.getTagName().equals(OLD_BULLET_TAG)) continue;
                return false;
            }
            if (secondElement != null) continue;
            secondElement = childElement;
            return secondElement.getTagName().equals(OLD_PARAGRAPH_TAG);
        }
        return false;
    }

    private static void convertMixedBody(Element sourceElement, Element destinationElement, Document destinationDocument) throws LicenseXmlConverterException {
        String tag = sourceElement.getTagName();
        if (OLD_ALTERNATIVE_TAG.equals(tag)) {
            if (sourceElement.hasAttribute("name")) {
                destinationElement.setAttribute("name", sourceElement.getAttribute("name"));
            }
            if (sourceElement.hasAttribute(OLD_VAR_MATCH_ATTRIBUTE)) {
                destinationElement.setAttribute(OLD_VAR_MATCH_ATTRIBUTE, sourceElement.getAttribute(OLD_VAR_MATCH_ATTRIBUTE));
            }
        }
        NodeList children = sourceElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && OLD_BODY_TAG.equals(((Element)child).getTagName())) {
                ConvertLicenseListXml.convertMixedBody((Element)child, destinationElement, destinationDocument);
                continue;
            }
            Node convertedNode = ConvertLicenseListXml.convertNode(child, destinationDocument);
            destinationElement.appendChild(convertedNode);
        }
    }

    private static void assertValid(Document xmlDocument) throws LicenseXmlConverterException {
        Element rootElement = xmlDocument.getDocumentElement();
        if (!OLD_ROOT_ELEMENT_NAME.equals(rootElement.getTagName().toUpperCase())) {
            throw new LicenseXmlConverterException("Incorrect document element name - expected 'SPDX', found '" + rootElement.getTagName() + "'");
        }
        if (!rootElement.hasAttribute("name")) {
            throw new LicenseXmlConverterException("Missing required license name");
        }
        if (!rootElement.hasAttribute(OLD_ID_ATTRIBUTE)) {
            throw new LicenseXmlConverterException("Missing required license ID");
        }
        NamedNodeMap rootAttributes = rootElement.getAttributes();
        for (int i = 0; i < rootAttributes.getLength(); ++i) {
            if (TAG_MAP.get(rootAttributes.item(i).getNodeName()) != null) continue;
            throw new LicenseXmlConverterException("Unknown attribute " + rootAttributes.item(i).getNodeName());
        }
        NodeList rootChildren = rootElement.getChildNodes();
        for (int i = 0; i < rootChildren.getLength(); ++i) {
            if (rootChildren.item(i).getNodeType() != 1 || TAG_MAP.get(rootChildren.item(i).getNodeName()) != null) continue;
            throw new LicenseXmlConverterException("Unknown element " + rootChildren.item(i).getNodeName());
        }
        NodeList licenseNodes = rootElement.getElementsByTagName(OLD_LICENSE_TAG);
        NodeList exceptionNodes = rootElement.getElementsByTagName(OLD_EXCEPTION_TAG);
        if (licenseNodes.getLength() < 1 && exceptionNodes.getLength() < 1) {
            throw new LicenseXmlConverterException("Missing required license or exception element");
        }
        if (licenseNodes.getLength() + exceptionNodes.getLength() > 1) {
            throw new LicenseXmlConverterException("More than one license and exception elements");
        }
        Node licenseNode = licenseNodes.getLength() > 0 ? licenseNodes.item(0) : exceptionNodes.item(0);
        if (licenseNode.getNodeType() != 1) {
            throw new LicenseXmlConverterException("Invalid node type for license");
        }
        NodeList headerNodes = rootElement.getElementsByTagName(OLD_HEADER_TAG);
        if (headerNodes.getLength() > 1) {
            throw new LicenseXmlConverterException("More than one standard license header elements");
        }
    }

    private static void error(String msg) {
        System.out.println(msg);
        ConvertLicenseListXml.usage();
        System.exit(1);
    }

    private static void usage() {
        System.out.println("Usage: ConvertLicenseListXml inputDir outputDir");
        System.out.println("\tinputDir contains license list XML files in pre-Jun 2017 format");
        System.out.println("\toutputDir is an empty output directory to store the converted xml files");
    }

    static {
        TAG_MAP.put(OLD_ROOT_ELEMENT_NAME, "SPDXLicenseCollection");
        TAG_MAP.put("name", "name");
        TAG_MAP.put(OLD_ID_ATTRIBUTE, "licenseId");
        TAG_MAP.put(OLD_LICENSE_LIST_VERSION_ATTRIBUTE, OLD_LICENSE_LIST_VERSION_ATTRIBUTE);
        TAG_MAP.put(OLD_LICENSE_TAG, OLD_LICENSE_TAG);
        TAG_MAP.put(OLD_EXCEPTION_TAG, OLD_EXCEPTION_TAG);
        TAG_MAP.put(OLD_DEPRECATED_ATTRIBUTE, "isDeprecated");
        TAG_MAP.put(OLD_NOTES_TAG, OLD_NOTES_TAG);
        TAG_MAP.put(OLD_URLS_TAG, "crossRefs");
        TAG_MAP.put(OLD_URL_TAG, "crossRef");
        TAG_MAP.put(OLD_HEADER_TAG, "standardLicenseHeader");
        TAG_MAP.put(OLD_OSI_APPROVED_ATTRIBUTE, "isOsiApproved");
        TAG_MAP.put(OLD_COPYRIGHT_TAG, "copyrightText");
        TAG_MAP.put(OLD_TITLE_TAG, "titleText");
        TAG_MAP.put(OLD_LIST_ITEM_TAG, "item");
        TAG_MAP.put(OLD_LIST_TAG, OLD_LIST_TAG);
        TAG_MAP.put(OLD_ALTERNATIVE_TAG, OLD_ALTERNATIVE_TAG);
        TAG_MAP.put(OLD_OPTIONAL_TAG, OLD_OPTIONAL_TAG);
        TAG_MAP.put(OLD_BREAK_TAG, OLD_BREAK_TAG);
        TAG_MAP.put(OLD_PARAGRAPH_TAG, OLD_PARAGRAPH_TAG);
        TAG_MAP.put("name", "name");
        TAG_MAP.put(OLD_VAR_MATCH_ATTRIBUTE, OLD_VAR_MATCH_ATTRIBUTE);
        TAG_MAP.put(OLD_BULLET_TAG, "bullet");
    }
}

