/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.tools.LicenseGeneratorException;
import org.spdx.tools.LicensePublisherException;
import org.spdx.tools.LicenseRDFAGenerator;

public class LicenseListPublisher {
    static final Comparator<String> versionComparer = new Comparator<String>(){
        Pattern versionPattern = Pattern.compile("(\\d+\\.)?(\\d+\\.)?(\\*|\\d+)$");

        @Override
        public int compare(String arg0, String arg1) {
            Matcher matcher0 = this.versionPattern.matcher(arg0);
            Matcher matcher1 = this.versionPattern.matcher(arg1);
            if (!matcher0.find()) {
                if (!matcher1.find()) {
                    return 0;
                }
                return -1;
            }
            if (!matcher1.find()) {
                return 1;
            }
            String version0 = matcher0.group(0);
            String version1 = matcher1.group(0);
            return version0.compareTo(version1);
        }
    };
    static final Logger logger = LoggerFactory.getLogger(LicenseListPublisher.class);
    static final int ERROR_STATUS = 1;
    private static final String LICENSE_XML_URI = "https://github.com/spdx/license-list-XML.git";
    private static final String TEST_DIRECTORY_PATH = "test/original";
    private static final String LICENSE_DATA_URI = "https://github.com/spdx/license-list-data.git";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Options options = LicenseListPublisher.createOptions();
        if (args.length == 1 && "-h".equals(args[0])) {
            LicenseListPublisher.usage(options);
            System.exit(0);
        }
        DefaultParser parser = new DefaultParser();
        CommandLine cmdLine = null;
        try {
            cmdLine = parser.parse(options, args);
        }
        catch (ParseException e1) {
            System.out.println(e1.getMessage());
            LicenseListPublisher.usage(options);
            System.exit(1);
        }
        boolean debug = cmdLine.hasOption("z");
        if (cmdLine.hasOption("h")) {
            LicenseListPublisher.usage(options);
            System.exit(0);
        }
        boolean testOnly = cmdLine.hasOption("t");
        if (debug) {
            System.out.println("Test only value: " + testOnly);
        }
        String outputRepository = cmdLine.getOptionValue("O", LICENSE_DATA_URI).trim();
        if (debug) {
            System.out.println("Output Repository: " + outputRepository);
        }
        boolean ignoreWarnings = cmdLine.hasOption("I");
        if (debug) {
            System.out.println("Ignore all warnings: " + ignoreWarnings);
        }
        String[] ignoredWarnings = new String[]{};
        if (cmdLine.hasOption("w")) {
            if (debug) {
                System.out.println("Ignored warnings specified: " + cmdLine.getOptionValue("w"));
            }
            CSVReader reader = null;
            try {
                File warningsFile = new File(cmdLine.getOptionValue("w").trim());
                if (warningsFile.exists()) {
                    reader = new CSVReader((Reader)new FileReader(warningsFile));
                    if (debug) {
                        System.out.println("Reading skipped warnings from file " + warningsFile.getName());
                    }
                } else {
                    reader = new CSVReader((Reader)new StringReader(cmdLine.getOptionValue("w").trim()));
                    if (debug) {
                        System.out.println("Reading skipped warnings from string");
                    }
                }
                ignoredWarnings = reader.readNext();
                if (debug) {
                    System.out.println("Number of ignored warnings: " + ignoredWarnings.length);
                }
            }
            catch (IOException e) {
                System.out.println("IO Error reading ignored warnings: " + e.getMessage());
                System.exit(1);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        System.out.println("IO Error closing ignored warnings string: " + e.getMessage());
                        System.exit(1);
                    }
                }
            }
        }
        String release = null;
        if (cmdLine.hasOption("r")) {
            release = cmdLine.getOptionValue("r").trim();
            if (debug) {
                System.out.println("Release specified as " + release);
            }
        }
        String gitUserName = cmdLine.getOptionValue("u").trim();
        if (debug) {
            System.out.println("User name: " + gitUserName);
        }
        String gitPassword = cmdLine.getOptionValue("p", "").trim();
        if (debug) {
            System.out.println("User password: " + gitPassword);
        }
        String licenseXmlGitUri = cmdLine.getOptionValue("x", LICENSE_XML_URI).trim();
        if (debug) {
            System.out.println("License XML git URI: " + licenseXmlGitUri);
        }
        try {
            UsernamePasswordCredentialsProvider githubCredentials = new UsernamePasswordCredentialsProvider(gitUserName, gitPassword);
            String version = null;
            if (cmdLine.hasOption("d")) {
                File licenseXmlDir;
                if (debug) {
                    System.out.println("License XML directory specified: " + cmdLine.getOptionValue("d"));
                }
                if (!(licenseXmlDir = new File(cmdLine.getOptionValue("d").trim())).exists()) {
                    System.out.println("License XML directory " + cmdLine.getOptionValue("d") + " does not exist.");
                    LicenseListPublisher.usage(options);
                }
                if (!licenseXmlDir.isDirectory()) {
                    System.out.println("License XML directory " + cmdLine.getOptionValue("d") + " is not a directory.");
                    LicenseListPublisher.usage(options);
                }
                version = LicenseListPublisher.publishLicenseList(licenseXmlDir, release, (CredentialsProvider)githubCredentials, ignoreWarnings, ignoredWarnings, outputRepository, testOnly);
            } else {
                version = LicenseListPublisher.publishLicenseList(licenseXmlGitUri, release, (CredentialsProvider)githubCredentials, ignoreWarnings, ignoredWarnings, outputRepository, testOnly);
            }
            if (testOnly) {
                System.out.println("Testing complete without any unexpected errors or warnings.");
            } else if (version != null) {
                System.out.println("Version " + version + " published to " + outputRepository);
            } else {
                System.out.println("No version was publish (publisher returned a null value)");
            }
        }
        catch (LicensePublisherException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
        catch (LicenseGeneratorException e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
    }

    private static Options createOptions() {
        Options retval = new Options();
        retval.addOption(Option.builder((String)"O").longOpt("outputrepo").desc("Git repository to output the license list data to.  The git user must have update access to this repository").hasArg(true).required(false).build());
        retval.addOption(Option.builder((String)"I").longOpt("ignoreAllWarnings").desc("Ignore all warnings").required(false).build());
        retval.addOption(Option.builder((String)"w").longOpt("ignoreWarnings").desc("Ignore specific warning messages").hasArg(true).required(false).build());
        retval.addOption(Option.builder((String)"u").longOpt("user").desc("Github Username").hasArg(true).required(true).build());
        retval.addOption(Option.builder((String)"p").longOpt("password").desc("Github password").hasArg(true).required(false).build());
        retval.addOption(Option.builder((String)"d").longOpt("directory").desc("Input XML directory").hasArg(true).required(false).build());
        retval.addOption(Option.builder((String)"x").longOpt("xmlrepo").desc("Input license XML repository").hasArg(true).required(false).build());
        retval.addOption(Option.builder((String)"r").longOpt("release").desc("License list release tag or version").required(false).hasArg(true).build());
        retval.addOption(Option.builder((String)"h").longOpt("help").desc("Prints out this message").required(false).hasArg(false).build());
        retval.addOption(Option.builder((String)"t").longOpt("testOnly").desc("Only tests the license XML files - does not update or publish the results").required(false).hasArg(false).build());
        retval.addOption(Option.builder((String)"z").longOpt("debug").desc("Prints debug information while processing").required(false).hasArg(false).build());
        return retval;
    }

    private static String publishLicenseList(String licenseXmlGithubUri, String release, CredentialsProvider githubCredentials, boolean ignoreWarnings, String[] ignoredWarnings, String outputRepository, boolean testOnly) throws LicensePublisherException, LicenseGeneratorException {
        File licenseXmlDir = null;
        Git licenseXmlGit = null;
        try {
            Object releaseTag;
            licenseXmlDir = Files.createTempDirectory("LicenseXML", new FileAttribute[0]).toFile();
            System.out.println("Cloning the license XML repository - this could take a while...");
            licenseXmlGit = ((CloneCommand)Git.cloneRepository().setCredentialsProvider(githubCredentials)).setDirectory(licenseXmlDir).setURI(licenseXmlGithubUri).call();
            if (release != null) {
                releaseTag = (Ref)licenseXmlGit.getRepository().getTags().get(release);
                if (releaseTag == null) {
                    throw new LicensePublisherException("Release " + release + " not found as a tag in the License List XML repository");
                }
                licenseXmlGit.checkout().setName(releaseTag.getName()).call();
            }
            releaseTag = LicenseListPublisher.publishLicenseList(licenseXmlDir, release, githubCredentials, ignoreWarnings, ignoredWarnings, outputRepository, testOnly);
            return releaseTag;
        }
        catch (IOException e) {
            throw new LicensePublisherException("I/O Error publishing license list", e);
        }
        catch (InvalidRemoteException e) {
            throw new LicensePublisherException("Invalid remote error trying to access the git repositories", e);
        }
        catch (TransportException e) {
            throw new LicensePublisherException("Transport error trying to access the git repositories", e);
        }
        catch (GitAPIException e) {
            throw new LicensePublisherException("GIT API error trying to access the git repositories", e);
        }
        finally {
            if (licenseXmlGit != null) {
                licenseXmlGit.close();
            }
            if (licenseXmlDir != null) {
                LicenseListPublisher.deleteDir(licenseXmlDir);
            }
        }
    }

    private static String publishLicenseList(File sourceDirectory, String release, CredentialsProvider githubCredentials, boolean ignoreWarnings, String[] ignoredWarnings, String outputRepository, boolean testOnly) throws LicensePublisherException, LicenseGeneratorException {
        File licenseTestDir = new File(sourceDirectory.getAbsolutePath() + File.separator + TEST_DIRECTORY_PATH);
        File licenseDataDir = null;
        Git licenseDataGit = null;
        boolean dataReleaseTagExists = false;
        try {
            licenseDataDir = Files.createTempDirectory("LicenseData", new FileAttribute[0]).toFile();
            if (!testOnly) {
                Ref dataReleaseTag;
                System.out.println("Cloning the license data repository - this could take a while...");
                licenseDataGit = ((CloneCommand)Git.cloneRepository().setCredentialsProvider(githubCredentials)).setDirectory(licenseDataDir).setURI(outputRepository).call();
                if (release != null && (dataReleaseTag = (Ref)licenseDataGit.getRepository().getTags().get(release)) != null) {
                    dataReleaseTagExists = true;
                    licenseDataGit.checkout().setName(dataReleaseTag.getName()).call();
                }
            }
            LicenseListPublisher.cleanLicenseDataDir(licenseDataDir);
            String todayDate = new SimpleDateFormat("dd-MMM-yyyy").format(Calendar.getInstance().getTime());
            String version = null;
            version = release != null ? release : LicenseListPublisher.getVersionFromGitTag(sourceDirectory);
            List<String> warnings = LicenseRDFAGenerator.generateLicenseData(new File(sourceDirectory.getPath() + File.separator + "src"), licenseDataDir, version, todayDate, licenseTestDir);
            if (warnings.size() > 0 && !ignoreWarnings) {
                ArrayList nonIgnoredWarnings = Lists.newArrayList();
                for (String warning : warnings) {
                    boolean ignore = false;
                    for (String ignoredWarning : ignoredWarnings) {
                        if (!warning.equalsIgnoreCase(ignoredWarning)) continue;
                        ignore = true;
                        System.out.println("Ignoring warning message: '" + warning + "'");
                        break;
                    }
                    if (ignore) continue;
                    nonIgnoredWarnings.add(warning);
                }
                if (nonIgnoredWarnings.size() > 0) {
                    StringBuilder errorMsg = new StringBuilder("The following errors or warnings occured while processing the license input data:\n");
                    for (String warning : nonIgnoredWarnings) {
                        errorMsg.append(warning);
                        errorMsg.append("\n");
                    }
                    throw new LicensePublisherException(errorMsg.toString());
                }
            }
            if (!testOnly) {
                licenseDataGit.add().addFilepattern(".").call();
                String commitMsg = "Auotomated License List Publisher";
                if (release != null) {
                    commitMsg = commitMsg + " for License List Version " + release;
                } else if (version != null) {
                    commitMsg = commitMsg + " for license list tag/commit " + version;
                }
                licenseDataGit.commit().setAll(true).setCommitter("SPDX License List Publisher", "spdx-tech@lists.spdx.org").setMessage(commitMsg).call();
                PushCommand push = ((PushCommand)licenseDataGit.push().setCredentialsProvider(githubCredentials)).setRemote("origin");
                if (!dataReleaseTagExists && release != null) {
                    licenseDataGit.tag().setName(release).setMessage("SPDX License List release " + release).call();
                    push.setPushTags();
                }
                push.call();
                String string = version;
                return string;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            throw new LicensePublisherException("I/O Error publishing license list", e);
        }
        catch (InvalidRemoteException e) {
            throw new LicensePublisherException("Invalid remote error trying to access the git repositories", e);
        }
        catch (TransportException e) {
            throw new LicensePublisherException("Transport error trying to access the git repositories", e);
        }
        catch (GitAPIException e) {
            throw new LicensePublisherException("GIT API error trying to access the git repositories", e);
        }
        finally {
            if (licenseDataGit != null) {
                licenseDataGit.close();
            }
            if (licenseDataDir != null) {
                LicenseListPublisher.deleteDir(licenseDataDir);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static String getVersionFromGitTag(File sourceDirectory) throws IOException, GitAPIException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void cleanLicenseDataDir(File licenseDataDir) {
        File[] children = licenseDataDir.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child == null || !child.isDirectory()) continue;
                LicenseListPublisher.deleteOnlyFiles(child);
            }
        }
    }

    private static void deleteOnlyFiles(File file) {
        if (file.getName().startsWith(".")) {
            return;
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    if (child == null) continue;
                    if (child.isDirectory()) {
                        LicenseListPublisher.deleteOnlyFiles(child);
                        continue;
                    }
                    if (child.delete()) continue;
                    logger.warn("Unable to delete file " + child.getName());
                }
            }
        } else {
            file.delete();
        }
    }

    private static boolean deleteDir(File dir) {
        File[] children;
        if (dir.isDirectory() && (children = dir.listFiles()) != null) {
            for (File child : children) {
                if (child == null || LicenseListPublisher.deleteDir(child)) continue;
                return false;
            }
        }
        return dir.delete();
    }

    private static void usage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("LicenseListPublisher", options);
    }
}

