/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.licensegenerator;

import java.io.File;
import java.io.IOException;
import org.spdx.html.ExceptionTOCJSONFile;
import org.spdx.html.LicenseExceptionJSONFile;
import org.spdx.html.LicenseJSONFile;
import org.spdx.html.LicenseTOCJSONFile;
import org.spdx.rdfparser.license.LicenseException;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.spdx.tools.licensegenerator.ILicenseFormatWriter;
import org.spdx.tools.licensegenerator.LicenseHtmlFormatWriter;

public class LicenseJsonFormatWriter
implements ILicenseFormatWriter {
    static final String LICENSE_TOC_JSON_FILE_NAME = "licenses.json";
    static final String EXCEPTION_JSON_TOC_FILE_NAME = "exceptions.json";
    private File jsonFolder;
    private File jsonFolderExceptions;
    private File jsonFolderDetails;
    LicenseJSONFile licJson;
    LicenseTOCJSONFile tableOfContentsJSON;
    ExceptionTOCJSONFile jsonExceptionToc;

    public LicenseJsonFormatWriter(String version, String releaseDate, File jsonFolder, File jsonFolderDetails, File jsonFolderExceptions) {
        this.jsonFolder = jsonFolder;
        this.jsonFolderDetails = jsonFolderDetails;
        this.jsonFolderExceptions = jsonFolderExceptions;
        this.licJson = new LicenseJSONFile();
        this.tableOfContentsJSON = new LicenseTOCJSONFile(version, releaseDate);
        this.jsonExceptionToc = new ExceptionTOCJSONFile(version, releaseDate);
    }

    public File getJsonFolder() {
        return this.jsonFolder;
    }

    public void setJsonFolder(File jsonFolder) {
        this.jsonFolder = jsonFolder;
    }

    public File getJsonFolderExceptions() {
        return this.jsonFolderExceptions;
    }

    public void setJsonFolderExceptions(File jsonFolderExceptions) {
        this.jsonFolderExceptions = jsonFolderExceptions;
    }

    public File getJsonFolderDetails() {
        return this.jsonFolderDetails;
    }

    public void setJsonFolderDetails(File jsonFolderDetails) {
        this.jsonFolderDetails = jsonFolderDetails;
    }

    @Override
    public void writeLicense(SpdxListedLicense license, boolean deprecated, String deprecatedVersion) throws IOException {
        this.licJson.setLicense(license, deprecated);
        String licBaseHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(license.getLicenseId());
        String licHtmlFileName = licBaseHtmlFileName + ".html";
        String licJsonFileName = licBaseHtmlFileName + ".json";
        String licHTMLReference = "./" + licHtmlFileName;
        String licJSONReference = "./" + licJsonFileName;
        File licJsonFile = new File(this.jsonFolder.getPath() + File.separator + "details" + File.separator + licJsonFileName);
        this.licJson.writeToFile(licJsonFile);
        this.tableOfContentsJSON.addLicense(license, licHTMLReference, licJSONReference, deprecated);
    }

    @Override
    public void writeToC() throws IOException {
        File tocJsonFile = new File(this.jsonFolder.getPath() + File.separator + LICENSE_TOC_JSON_FILE_NAME);
        this.tableOfContentsJSON.writeToFile(tocJsonFile);
        File exceptionJsonTocFile = new File(this.jsonFolder.getPath() + File.separator + EXCEPTION_JSON_TOC_FILE_NAME);
        this.jsonExceptionToc.writeToFile(exceptionJsonTocFile);
    }

    @Override
    public void writeException(LicenseException exception, boolean deprecated, String deprecatedVersion) throws IOException {
        String exceptionHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(exception.getLicenseExceptionId());
        String exceptionJsonFileName = exceptionHtmlFileName + ".json";
        String exceptionJSONReference = "./" + exceptionJsonFileName;
        String exceptionHTMLReference = "./" + exceptionHtmlFileName + ".html";
        LicenseExceptionJSONFile exceptionJson = new LicenseExceptionJSONFile();
        this.jsonExceptionToc.addException(exception, exceptionHTMLReference, exceptionJSONReference, deprecated);
        exceptionJson.setException(exception, deprecated);
        File exceptionJsonFile = new File(this.jsonFolder.getPath() + File.separator + "exceptions" + File.separator + exceptionJsonFileName);
        exceptionJson.writeToFile(exceptionJsonFile);
    }
}

