/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.licensegenerator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.LicenseException;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.spdx.tools.LicenseContainer;
import org.spdx.tools.LicenseGeneratorException;
import org.spdx.tools.licensegenerator.ILicenseFormatWriter;
import org.spdx.tools.licensegenerator.LicenseHtmlFormatWriter;

public class LicenseRdfFormatWriter
implements ILicenseFormatWriter {
    private File rdfXml;
    private File rdfTurtle;
    private File rdfNt;
    private LicenseContainer container;

    public LicenseRdfFormatWriter(File rdfXml, File rdfTurtle, File rdfNt) {
        this.rdfXml = rdfXml;
        this.rdfTurtle = rdfTurtle;
        this.rdfNt = rdfNt;
        this.container = new LicenseContainer();
    }

    public File getRdfXml() {
        return this.rdfXml;
    }

    public void setRdfXml(File rdfXml) {
        this.rdfXml = rdfXml;
    }

    public File getRdfTurtle() {
        return this.rdfTurtle;
    }

    public void setRdfTurtle(File rdfTurtle) {
        this.rdfTurtle = rdfTurtle;
    }

    public File getRdfNt() {
        return this.rdfNt;
    }

    public void setRdfNt(File rdfNt) {
        this.rdfNt = rdfNt;
    }

    @Override
    public void writeLicense(SpdxListedLicense license, boolean deprecated, String deprecatedVersion) throws IOException, LicenseGeneratorException {
        AnyLicenseInfo licenseClone = license.clone();
        LicenseContainer onlyThisLicense = new LicenseContainer();
        try {
            licenseClone.createResource(onlyThisLicense);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new LicenseGeneratorException("SPDX Analysis error cloning license: " + e.getMessage(), e);
        }
        String licBaseFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(license.getLicenseId());
        LicenseRdfFormatWriter.writeRdf(onlyThisLicense, this.rdfXml, this.rdfTurtle, this.rdfNt, licBaseFileName);
        try {
            license.createResource(this.container);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new LicenseGeneratorException("SPDX Analysis error creating license resource: " + e.getMessage(), e);
        }
    }

    private static void writeRdf(IModelContainer container, File rdfXml, File rdfTurtle, File rdfNt, String name) throws LicenseGeneratorException {
        if (rdfXml != null) {
            LicenseRdfFormatWriter.writeRdf(container, rdfXml.getPath() + File.separator + name + ".rdf", "RDF/XML-ABBREV");
        }
        if (rdfTurtle != null) {
            LicenseRdfFormatWriter.writeRdf(container, rdfTurtle.getPath() + File.separator + name + ".turtle", "TURTLE");
        }
        if (rdfNt != null) {
            LicenseRdfFormatWriter.writeRdf(container, rdfNt.getPath() + File.separator + name + ".nt", "NT");
        }
    }

    private static void writeRdf(IModelContainer container, String fileName, String format) throws LicenseGeneratorException {
        File outFile = new File(fileName);
        if (!outFile.exists()) {
            try {
                if (!outFile.createNewFile()) {
                    throw new LicenseGeneratorException("Can not create RDF output file " + fileName);
                }
            }
            catch (IOException e) {
                throw new LicenseGeneratorException("Can not create RDF output file " + fileName);
            }
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outFile);
            container.getModel().write((OutputStream)out, format);
        }
        catch (FileNotFoundException e1) {
            throw new LicenseGeneratorException("Can not create RDF output file " + fileName);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    System.out.println("Warning - unable to close RDF output file " + fileName);
                }
            }
        }
    }

    @Override
    public void writeToC() throws IOException, LicenseGeneratorException {
        LicenseRdfFormatWriter.writeRdf(this.container, this.rdfXml, this.rdfTurtle, this.rdfNt, "licenses");
    }

    @Override
    public void writeException(LicenseException exception, boolean deprecated, String deprecatedVersion) throws IOException, LicenseGeneratorException {
        String exceptionHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(exception.getLicenseExceptionId());
        LicenseException exceptionClone = exception.clone();
        LicenseContainer onlyThisException = new LicenseContainer();
        try {
            exceptionClone.createResource(onlyThisException);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new LicenseGeneratorException("SPDX Analysis error cloning exception: " + e.getMessage(), e);
        }
        LicenseRdfFormatWriter.writeRdf(onlyThisException, this.rdfXml, this.rdfTurtle, this.rdfNt, exceptionHtmlFileName);
        try {
            exception.createResource(this.container);
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new LicenseGeneratorException("SPDX Analysis error creating exception resource: " + e.getMessage(), e);
        }
    }
}

