/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.licensegenerator;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.spdx.compare.CompareTemplateOutputHandler;
import org.spdx.compare.LicenseCompareHelper;
import org.spdx.compare.SpdxCompareException;
import org.spdx.rdfparser.license.License;
import org.spdx.rdfparser.license.LicenseException;
import org.spdx.tools.licensegenerator.ILicenseTester;

public class SimpleLicenseTester
implements ILicenseTester {
    private Charset utf8 = Charset.forName("UTF-8");
    private File testFileDir;

    public SimpleLicenseTester(File testFileDir) {
        this.testFileDir = testFileDir;
    }

    @Override
    public List<String> testException(LicenseException exception) throws IOException {
        File exceptionFile = new File(this.testFileDir.getPath() + File.separator + exception.getLicenseExceptionId() + ".txt");
        ArrayList<String> retval = new ArrayList<String>();
        if (!exceptionFile.exists()) {
            retval.add("No test text exists for license exception ID " + exception.getLicenseExceptionId());
        } else {
            String compareText = this.readText(exceptionFile);
            try {
                CompareTemplateOutputHandler.DifferenceDescription result = LicenseCompareHelper.isTextStandardException(exception, compareText);
                if (result.isDifferenceFound()) {
                    retval.add("Test for exception ID " + exception.getLicenseExceptionId() + " failed due to difference found " + result.getDifferenceMessage());
                }
            }
            catch (SpdxCompareException e) {
                retval.add("Invalid template found for exception ID " + exception.getLicenseExceptionId() + ": " + e.getMessage());
            }
        }
        return retval;
    }

    private String readText(File f) throws IOException {
        StringBuilder text = new StringBuilder();
        Files.lines(f.toPath(), this.utf8).forEach(line -> {
            text.append((String)line);
            text.append("\n");
        });
        return text.toString();
    }

    @Override
    public List<String> testLicense(License license) throws IOException {
        ArrayList<String> retval = new ArrayList<String>();
        File licenseTextFile = new File(this.testFileDir.getPath() + File.separator + license.getLicenseId() + ".txt");
        if (!licenseTextFile.exists()) {
            if (!license.isDeprecated()) {
                retval.add("No test text exists for license ID " + license.getLicenseId());
            }
        } else {
            String compareText = this.readText(licenseTextFile);
            try {
                CompareTemplateOutputHandler.DifferenceDescription result = LicenseCompareHelper.isTextStandardLicense(license, compareText);
                if (result.isDifferenceFound()) {
                    retval.add("Test for license ID " + license.getLicenseId() + " failed due to difference found " + result.getDifferenceMessage());
                }
            }
            catch (SpdxCompareException e) {
                retval.add("Invalid template found for license ID " + license.getLicenseId() + ": " + e.getMessage());
            }
        }
        return retval;
    }
}

