/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.licensegenerator;

import com.github.mustachejava.MustacheException;
import java.io.File;
import java.io.IOException;
import org.spdx.html.ExceptionHtml;
import org.spdx.html.ExceptionHtmlToc;
import org.spdx.html.ExceptionTOCJSONFile;
import org.spdx.html.InvalidLicenseTemplateException;
import org.spdx.html.LicenseExceptionJSONFile;
import org.spdx.html.LicenseHTMLFile;
import org.spdx.html.LicenseJSONFile;
import org.spdx.html.LicenseTOCHTMLFile;
import org.spdx.html.LicenseTOCJSONFile;
import org.spdx.rdfparser.license.LicenseException;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.spdx.spdxspreadsheet.SPDXLicenseSpreadsheet;
import org.spdx.tools.LicenseGeneratorException;
import org.spdx.tools.licensegenerator.ILicenseFormatWriter;
import org.spdx.tools.licensegenerator.LicenseHtmlFormatWriter;

public class SpdxWebsiteFormatWriter
implements ILicenseFormatWriter {
    static final String LICENSE_TOC_JSON_FILE_NAME = "licenses.json";
    static final String LICENSE_TOC_HTML_FILE_NAME = "index.html";
    static final String EXCEPTION_TOC_FILE_NAME = "exceptions-index.html";
    static final String EXCEPTION_JSON_TOC_FILE_NAME = "exceptions.json";
    private File websiteFolder;
    private LicenseHTMLFile licHtml;
    private LicenseTOCHTMLFile tableOfContentsHTML;
    LicenseJSONFile licJson;
    LicenseTOCJSONFile tableOfContentsJSON;
    String exceptionHtmlTocReference = "./exceptions-index.html";
    ExceptionHtmlToc htmlExceptionToc;
    ExceptionTOCJSONFile jsonExceptionToc;
    private String version;
    private String releaseDate;

    public SpdxWebsiteFormatWriter(String version, String releaseDate, File websiteFolder) {
        this.websiteFolder = websiteFolder;
        this.tableOfContentsHTML = new LicenseTOCHTMLFile(version, releaseDate);
        this.licHtml = new LicenseHTMLFile();
        this.licJson = new LicenseJSONFile();
        this.tableOfContentsJSON = new LicenseTOCJSONFile(version, releaseDate);
        this.htmlExceptionToc = new ExceptionHtmlToc();
        this.jsonExceptionToc = new ExceptionTOCJSONFile(version, releaseDate);
        this.version = version;
        this.releaseDate = releaseDate;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(String releaseDate) {
        this.releaseDate = releaseDate;
    }

    public LicenseJSONFile getLicJson() {
        return this.licJson;
    }

    public LicenseTOCJSONFile getTableOfContentsJSON() {
        return this.tableOfContentsJSON;
    }

    public ExceptionHtmlToc getHtmlExceptionToc() {
        return this.htmlExceptionToc;
    }

    public ExceptionTOCJSONFile getJsonExceptionToc() {
        return this.jsonExceptionToc;
    }

    public File getWebsiteFolder() {
        return this.websiteFolder;
    }

    public void setWebsiteFolder(File websiteFolder) {
        this.websiteFolder = websiteFolder;
    }

    public LicenseHTMLFile getLicHtml() {
        return this.licHtml;
    }

    public void setLicHtml(LicenseHTMLFile licHtml) {
        this.licHtml = licHtml;
    }

    public LicenseTOCHTMLFile getTableOfContentsHTML() {
        return this.tableOfContentsHTML;
    }

    public void setTableOfContentsHTML(LicenseTOCHTMLFile tableOfContentsHTML) {
        this.tableOfContentsHTML = tableOfContentsHTML;
    }

    @Override
    public void writeLicense(SpdxListedLicense license, boolean deprecated, String deprecatedVersion) throws IOException, LicenseGeneratorException {
        this.licHtml.setLicense(license);
        this.licHtml.setDeprecated(deprecated);
        if (deprecatedVersion != null) {
            this.licHtml.setDeprecatedVersion(deprecatedVersion);
        }
        String licBaseHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(license.getLicenseId());
        String licHtmlFileName = licBaseHtmlFileName + ".html";
        String licJsonFileName = licBaseHtmlFileName + ".json";
        String licHTMLReference = "./" + licHtmlFileName;
        String licJSONReference = "./" + licJsonFileName;
        String tocHTMLReference = "./index.html";
        File licBaseHtmlFile = new File(this.websiteFolder.getPath() + File.separator + licBaseHtmlFileName);
        File licJsonFile = new File(this.websiteFolder.getPath() + File.separator + licJsonFileName);
        File licHtmlFile = new File(this.websiteFolder.getPath() + File.separator + licHtmlFileName);
        try {
            this.licHtml.writeToFile(licBaseHtmlFile, tocHTMLReference);
            this.licHtml.writeToFile(licHtmlFile, tocHTMLReference);
        }
        catch (MustacheException e) {
            throw new LicenseGeneratorException("Template error for license HTML file: " + e.getMessage(), e);
        }
        catch (InvalidLicenseTemplateException e) {
            throw new LicenseGeneratorException("License template error for license HTML file: " + e.getMessage(), e);
        }
        this.licJson.setLicense(license, deprecated);
        this.licJson.writeToFile(licJsonFile);
        this.tableOfContentsJSON.addLicense(license, licHTMLReference, licJSONReference, deprecated);
        if (deprecated) {
            this.tableOfContentsHTML.addDeprecatedLicense(new SPDXLicenseSpreadsheet.DeprecatedLicenseInfo(license, deprecatedVersion), licHTMLReference);
        } else {
            this.tableOfContentsHTML.addLicense(license, licHTMLReference);
        }
    }

    @Override
    public void writeToC() throws IOException {
        File tocJsonFile = new File(this.websiteFolder.getPath() + File.separator + LICENSE_TOC_JSON_FILE_NAME);
        File tocHtmlFile = new File(this.websiteFolder.getPath() + File.separator + LICENSE_TOC_HTML_FILE_NAME);
        File exceptionTocFile = new File(this.websiteFolder.getPath() + File.separator + EXCEPTION_TOC_FILE_NAME);
        this.tableOfContentsJSON.writeToFile(tocJsonFile);
        this.tableOfContentsHTML.writeToFile(tocHtmlFile);
        this.htmlExceptionToc.writeToFile(exceptionTocFile, this.version);
        File exceptionJsonTocFile = new File(this.websiteFolder.getPath() + File.separator + EXCEPTION_JSON_TOC_FILE_NAME);
        this.jsonExceptionToc.writeToFile(exceptionJsonTocFile);
    }

    @Override
    public void writeException(LicenseException exception, boolean deprecated, String deprecatedVersion) throws IOException, InvalidLicenseTemplateException {
        ExceptionHtml exceptionHtml = new ExceptionHtml(exception);
        String exceptionHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(exception.getLicenseExceptionId());
        String exceptionHTMLReference = "./" + exceptionHtmlFileName + ".html";
        String exceptionJsonFileName = exceptionHtmlFileName + ".json";
        String exceptionJSONReference = "./" + exceptionJsonFileName;
        File exceptionHtmlFile = new File(this.websiteFolder.getPath() + File.separator + exceptionHtmlFileName + ".html");
        exceptionHtml.writeToFile(exceptionHtmlFile, this.exceptionHtmlTocReference);
        this.htmlExceptionToc.addException(exception, exceptionHTMLReference);
        this.jsonExceptionToc.addException(exception, exceptionHTMLReference, exceptionJSONReference, deprecated);
        LicenseExceptionJSONFile exceptionJson = new LicenseExceptionJSONFile();
        exceptionJson.setException(exception, deprecated);
        File exceptionJsonFile = new File(this.websiteFolder.getPath() + File.separator + exceptionJsonFileName);
        exceptionJson.writeToFile(exceptionJsonFile);
    }
}

