/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.model;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.RdfModelHelper;
import org.spdx.rdfparser.RdfParserHelper;
import org.spdx.rdfparser.SpdxPackageVerificationCode;
import org.spdx.rdfparser.SpdxRdfConstants;
import org.spdx.rdfparser.SpdxVerificationHelper;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.OrLaterOperator;
import org.spdx.rdfparser.license.SimpleLicensingInfo;
import org.spdx.rdfparser.license.SpdxNoAssertionLicense;
import org.spdx.rdfparser.license.SpdxNoneLicense;
import org.spdx.rdfparser.license.WithExceptionOperator;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.Checksum;
import org.spdx.rdfparser.model.ExternalRef;
import org.spdx.rdfparser.model.IRdfModel;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxElement;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxItem;

public class SpdxPackage
extends SpdxItem
implements SpdxRdfConstants,
Comparable<SpdxPackage> {
    AnyLicenseInfo licenseDeclared;
    Checksum[] checksums;
    String description;
    String downloadLocation;
    String homepage;
    String originator;
    String packageFileName;
    SpdxPackageVerificationCode packageVerificationCode;
    String sourceInfo;
    String summary;
    String supplier;
    String versionInfo;
    SpdxFile[] files;
    boolean filesAnalyzed = true;
    ExternalRef[] externalRefs;

    public SpdxPackage(String name, String comment, Annotation[] annotations, Relationship[] relationships, AnyLicenseInfo licenseConcluded, AnyLicenseInfo[] licenseInfosFromFiles, String copyrightText, String licenseComment, AnyLicenseInfo licenseDeclared, Checksum[] checksums, String description, String downloadLocation, SpdxFile[] files, String homepage, String originator, String packageFileName, SpdxPackageVerificationCode packageVerificationCode, String sourceInfo, String summary, String supplier, String versionInfo, boolean filesAnalyzed, ExternalRef[] externalRefs) {
        super(name, comment, annotations, relationships, licenseConcluded, licenseInfosFromFiles, copyrightText, licenseComment);
        this.licenseDeclared = licenseDeclared;
        this.checksums = checksums;
        if (this.checksums == null) {
            this.checksums = new Checksum[0];
        }
        this.description = description;
        this.downloadLocation = downloadLocation;
        this.files = files;
        if (this.files == null) {
            this.files = new SpdxFile[0];
        }
        this.homepage = homepage;
        this.originator = originator;
        this.packageFileName = packageFileName;
        this.packageVerificationCode = packageVerificationCode;
        this.sourceInfo = sourceInfo;
        this.summary = summary;
        this.supplier = supplier;
        this.versionInfo = versionInfo;
        this.filesAnalyzed = filesAnalyzed;
        this.externalRefs = externalRefs;
    }

    public SpdxPackage(String name, String comment, Annotation[] annotations, Relationship[] relationships, AnyLicenseInfo licenseConcluded, AnyLicenseInfo[] licenseInfosFromFiles, String copyrightText, String licenseComment, AnyLicenseInfo licenseDeclared, Checksum[] checksums, String description, String downloadLocation, SpdxFile[] files, String homepage, String originator, String packageFileName, SpdxPackageVerificationCode packageVerificationCode, String sourceInfo, String summary, String supplier, String versionInfo) {
        this(name, comment, annotations, relationships, licenseConcluded, licenseInfosFromFiles, copyrightText, licenseComment, licenseDeclared, checksums, description, downloadLocation, files, homepage, originator, packageFileName, packageVerificationCode, sourceInfo, summary, supplier, versionInfo, true, new ExternalRef[0]);
    }

    public SpdxPackage(String name, AnyLicenseInfo licenseConcluded, AnyLicenseInfo[] licenseInfosFromFiles, String copyrightText, AnyLicenseInfo licenseDeclared, String downloadLocation, SpdxFile[] files, SpdxPackageVerificationCode packageVerificationCode) {
        this(name, null, null, null, licenseConcluded, licenseInfosFromFiles, copyrightText, null, licenseDeclared, null, null, downloadLocation, files, null, null, null, packageVerificationCode, null, null, null, null, true, new ExternalRef[0]);
    }

    public SpdxPackage(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        super(modelContainer, node);
        this.getMyPropertiesFromModel();
    }

    public SpdxPackage(String name, String comment, Annotation[] annotations, Relationship[] relationships, AnyLicenseInfo licenseConcluded, AnyLicenseInfo[] licenseInfosFromFiles, String copyrightText, String licenseComment, AnyLicenseInfo licenseDeclared, Checksum[] checksums, String description, String downloadLocation, SpdxFile[] files, String homepage, String originator, String packageFileName, SpdxPackageVerificationCode packageVerificationCode, String sourceInfo, String summary, String supplier, String versionInfo, boolean filesAnalyzed, ExternalRef[] externalRefs, String[] attributionText) {
        this(name, comment, annotations, relationships, licenseConcluded, licenseInfosFromFiles, copyrightText, licenseComment, licenseDeclared, checksums, description, downloadLocation, files, homepage, originator, packageFileName, packageVerificationCode, sourceInfo, summary, supplier, versionInfo, filesAnalyzed, externalRefs);
        this.attributionText = attributionText;
    }

    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
        super.getPropertiesFromModel();
        this.getMyPropertiesFromModel();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void getMyPropertiesFromModel() throws InvalidSPDXAnalysisException {
        this.licenseDeclared = this.findAnyLicenseInfoPropertyValue("http://spdx.org/rdf/terms#", "licenseDeclared");
        this.checksums = this.findMultipleChecksumPropertyValues("http://spdx.org/rdf/terms#", "checksum");
        this.description = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "description");
        this.downloadLocation = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "downloadLocation");
        this.homepage = this.findSinglePropertyValue("http://usefulinc.com/ns/doap#", "homepage");
        this.originator = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "originator");
        this.packageFileName = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "packageFileName");
        this.packageVerificationCode = this.findVerificationCodePropertyValue("http://spdx.org/rdf/terms#", "packageVerificationCode");
        this.sourceInfo = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "sourceInfo");
        this.summary = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "summary");
        this.supplier = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "supplier");
        this.versionInfo = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "versionInfo");
        SpdxElement[] filesE = this.findMultipleElementPropertyValues("http://spdx.org/rdf/terms#", "hasFile");
        this.files = new SpdxFile[filesE.length];
        for (int i = 0; i < filesE.length; ++i) {
            if (!(filesE[i] instanceof SpdxFile)) {
                throw new InvalidSPDXAnalysisException("Incorrect type for a file belonging to a package: " + filesE[i].getName());
            }
            this.files[i] = (SpdxFile)filesE[i];
        }
        String filesAnalyzedString = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "filesAnalyzed");
        if (filesAnalyzedString != null) {
            if ((filesAnalyzedString = filesAnalyzedString.trim()).equals("true") || filesAnalyzedString.equals("1")) {
                this.filesAnalyzed = true;
            } else {
                if (!filesAnalyzedString.equals("false") && !filesAnalyzedString.equals("0")) throw new InvalidSPDXAnalysisException("Invalid value for files analyzed - must be {true, false, 0, 1}");
                this.filesAnalyzed = false;
            }
        } else {
            this.filesAnalyzed = true;
        }
        this.externalRefs = this.findExternalRefPropertyValues("http://spdx.org/rdf/terms#", "externalRef");
    }

    @Override
    public Resource findDuplicateResource(IModelContainer modelContainer, String uri) throws InvalidSPDXAnalysisException {
        if (this.name == null || this.name.isEmpty()) {
            return null;
        }
        if (this.packageVerificationCode == null) {
            return null;
        }
        if (this.packageVerificationCode.getValue() == null || this.packageVerificationCode.getValue().isEmpty()) {
            return null;
        }
        Model localModel = modelContainer.getModel();
        Node nameProperty = localModel.getProperty("http://spdx.org/rdf/terms#", this.getNamePropertyName()).asNode();
        Node verificationCodeProperty = localModel.getProperty("http://spdx.org/rdf/terms#", "packageVerificationCode").asNode();
        Node verificationCodeValueProperty = localModel.getProperty("http://spdx.org/rdf/terms#", "packageVerificationCodeValue").asNode();
        Triple nameMatch = Triple.createMatch(null, (Node)nameProperty, (Node)NodeFactory.createLiteral((String)this.name));
        ExtendedIterator nameleIter = localModel.getGraph().find(nameMatch);
        while (nameleIter.hasNext()) {
            Triple t = (Triple)nameleIter.next();
            Node packageNode = t.getSubject();
            Triple verifcationMatch = Triple.createMatch((Node)packageNode, (Node)verificationCodeProperty, null);
            ExtendedIterator verificationIter = localModel.getGraph().find(verifcationMatch);
            while (verificationIter.hasNext()) {
                Triple vt = (Triple)verificationIter.next();
                Triple valueMatch = Triple.createMatch((Node)vt.getObject(), (Node)verificationCodeValueProperty, null);
                ExtendedIterator valueIter = localModel.getGraph().find(valueMatch);
                while (valueIter.hasNext()) {
                    Triple valuetrip = (Triple)valueIter.next();
                    String verificationCodeValue = valuetrip.getObject().toString(false);
                    if (!this.packageVerificationCode.getValue().equals(verificationCodeValue)) continue;
                    return RdfParserHelper.convertToResource(localModel, packageNode);
                }
            }
        }
        return null;
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
        super.populateModel();
        this.setPropertyValue("http://spdx.org/rdf/terms#", "licenseDeclared", this.licenseDeclared);
        this.setPropertyValues("http://spdx.org/rdf/terms#", "checksum", this.checksums);
        this.setPropertyValue("http://spdx.org/rdf/terms#", "description", this.description);
        this.setPropertyValue("http://spdx.org/rdf/terms#", "downloadLocation", this.downloadLocation);
        this.setPropertyValue("http://usefulinc.com/ns/doap#", "homepage", this.homepage);
        this.setPropertyValue("http://spdx.org/rdf/terms#", "originator", this.originator);
        this.setPropertyValue("http://spdx.org/rdf/terms#", "packageFileName", this.packageFileName);
        this.setPropertyValue("http://spdx.org/rdf/terms#", "packageVerificationCode", this.packageVerificationCode);
        this.setPropertyValue("http://spdx.org/rdf/terms#", "sourceInfo", this.sourceInfo);
        this.setPropertyValue("http://spdx.org/rdf/terms#", "summary", this.summary);
        this.setPropertyValue("http://spdx.org/rdf/terms#", "supplier", this.supplier);
        this.setPropertyValue("http://spdx.org/rdf/terms#", "versionInfo", this.versionInfo);
        this.setPropertyValue("http://spdx.org/rdf/terms#", "hasFile", this.files);
        this.setPropertyValue("http://spdx.org/rdf/terms#", "filesAnalyzed", this.filesAnalyzed);
        this.setPropertyValue("http://spdx.org/rdf/terms#", "externalRef", this.externalRefs);
    }

    @Override
    protected String getNamePropertyName() {
        return "name";
    }

    @Override
    public Resource getType(Model model) {
        return model.createResource("http://spdx.org/rdf/terms#Package");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isFilesAnalyzed() throws InvalidSPDXAnalysisException {
        if (this.resource == null || !this.refreshOnGet) return this.filesAnalyzed;
        String filesAnalyzedString = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "filesAnalyzed");
        if (filesAnalyzedString != null) {
            if ((filesAnalyzedString = filesAnalyzedString.trim()).equals("true") || filesAnalyzedString.equals("1")) {
                this.filesAnalyzed = true;
                return this.filesAnalyzed;
            } else {
                if (!filesAnalyzedString.equals("false") && !filesAnalyzedString.equals("0")) throw new InvalidSPDXAnalysisException("Invalid value for files analyzed - must be {true, false, 0, 1}");
                this.filesAnalyzed = false;
            }
            return this.filesAnalyzed;
        } else {
            this.filesAnalyzed = true;
        }
        return this.filesAnalyzed;
    }

    public void setFilesAnalyzed(boolean filesAnalyzed) {
        this.filesAnalyzed = filesAnalyzed;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "filesAnalyzed", filesAnalyzed);
    }

    public AnyLicenseInfo getLicenseDeclared() throws InvalidSPDXAnalysisException {
        AnyLicenseInfo refresh;
        if (this.resource != null && this.refreshOnGet && ((refresh = this.findAnyLicenseInfoPropertyValue("http://spdx.org/rdf/terms#", "licenseDeclared")) == null || !refresh.equals(this.licenseDeclared))) {
            this.licenseDeclared = refresh;
        }
        return this.licenseDeclared;
    }

    public void setLicenseDeclared(AnyLicenseInfo licenseDeclared) throws InvalidSPDXAnalysisException {
        this.licenseDeclared = licenseDeclared;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "licenseDeclared", this.licenseDeclared);
    }

    public Checksum[] getChecksums() throws InvalidSPDXAnalysisException {
        IRdfModel[] refresh;
        if (this.resource != null && this.refreshOnGet && !this.arraysEquivalent(refresh = this.findMultipleChecksumPropertyValues("http://spdx.org/rdf/terms#", "checksum"), this.checksums, true)) {
            this.checksums = refresh;
        }
        return this.checksums;
    }

    public void setChecksums(Checksum[] checksums) throws InvalidSPDXAnalysisException {
        this.checksums = checksums;
        this.setPropertyValues("http://spdx.org/rdf/terms#", "checksum", this.checksums);
    }

    public void addChecksum(Checksum checksum) throws InvalidSPDXAnalysisException {
        if (checksum == null) {
            return;
        }
        this.checksums = Arrays.copyOf(this.checksums, this.checksums.length + 1);
        this.checksums[this.checksums.length - 1] = checksum;
        this.addPropertyValue("http://spdx.org/rdf/terms#", "checksum", checksum);
    }

    public String getDescription() {
        if (this.resource != null && this.refreshOnGet) {
            this.description = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "description");
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "description", this.description);
    }

    public String getDownloadLocation() {
        if (this.resource != null && this.refreshOnGet) {
            this.downloadLocation = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "downloadLocation");
        }
        return this.downloadLocation;
    }

    public void setDownloadLocation(String downloadLocation) {
        this.downloadLocation = downloadLocation;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "downloadLocation", this.downloadLocation);
    }

    public String getHomepage() {
        if (this.resource != null && this.refreshOnGet) {
            this.homepage = this.findSinglePropertyValue("http://usefulinc.com/ns/doap#", "homepage");
        }
        return this.homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
        this.setPropertyValue("http://usefulinc.com/ns/doap#", "homepage", this.homepage);
    }

    public String getOriginator() {
        if (this.resource != null && this.refreshOnGet) {
            this.originator = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "originator");
        }
        return this.originator;
    }

    public void setOriginator(String originator) {
        this.originator = originator;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "originator", this.originator);
    }

    public String getPackageFileName() {
        if (this.resource != null && this.refreshOnGet) {
            this.packageFileName = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "packageFileName");
        }
        return this.packageFileName;
    }

    public void setPackageFileName(String packageFileName) {
        this.packageFileName = packageFileName;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "packageFileName", this.packageFileName);
    }

    public SpdxPackageVerificationCode getPackageVerificationCode() throws InvalidSPDXAnalysisException {
        SpdxPackageVerificationCode refresh;
        if (this.resource != null && this.refreshOnGet && ((refresh = this.findVerificationCodePropertyValue("http://spdx.org/rdf/terms#", "packageVerificationCode")) == null || !refresh.equivalent(this.packageVerificationCode))) {
            this.packageVerificationCode = refresh;
        }
        return this.packageVerificationCode;
    }

    public void setPackageVerificationCode(SpdxPackageVerificationCode packageVerificationCode) throws InvalidSPDXAnalysisException {
        this.packageVerificationCode = packageVerificationCode;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "packageVerificationCode", this.packageVerificationCode);
    }

    public String getSourceInfo() {
        if (this.resource != null && this.refreshOnGet) {
            this.sourceInfo = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "sourceInfo");
        }
        return this.sourceInfo;
    }

    public void setSourceInfo(String sourceInfo) {
        this.sourceInfo = sourceInfo;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "sourceInfo", this.sourceInfo);
    }

    public String getSummary() {
        if (this.resource != null && this.refreshOnGet) {
            this.summary = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "summary");
        }
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "summary", this.summary);
    }

    public String getSupplier() {
        if (this.resource != null && this.refreshOnGet) {
            this.supplier = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "supplier");
        }
        return this.supplier;
    }

    public void setSupplier(String supplier) {
        this.supplier = supplier;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "supplier", this.supplier);
    }

    public String getVersionInfo() {
        if (this.resource != null && this.refreshOnGet) {
            this.versionInfo = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "versionInfo");
        }
        return this.versionInfo;
    }

    public void setVersionInfo(String versionInfo) {
        this.versionInfo = versionInfo;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "versionInfo", this.versionInfo);
    }

    public ExternalRef[] getExternalRefs() throws InvalidSPDXAnalysisException {
        if (this.resource != null && this.refreshOnGet) {
            this.externalRefs = this.findExternalRefPropertyValues("http://spdx.org/rdf/terms#", "externalRef");
        }
        return this.externalRefs;
    }

    public void setExternalRefs(ExternalRef[] externalRefs) throws InvalidSPDXAnalysisException {
        this.setPropertyValue("http://spdx.org/rdf/terms#", "externalRef", externalRefs);
        this.externalRefs = externalRefs;
    }

    public SpdxFile[] getFiles() throws InvalidSPDXAnalysisException {
        return this.getFiles(true);
    }

    public SpdxFile[] getFiles(boolean checkRelationships) throws InvalidSPDXAnalysisException {
        IRdfModel[] filesE;
        if (this.resource != null && this.refreshOnGet && !this.arraysEquivalent(filesE = this.findMultipleElementPropertyValues("http://spdx.org/rdf/terms#", "hasFile"), this.files, checkRelationships)) {
            this.files = new SpdxFile[filesE.length];
            for (int i = 0; i < filesE.length; ++i) {
                if (!(filesE[i] instanceof SpdxFile)) {
                    throw new InvalidSPDXAnalysisException("Incorrect type for a file belonging to a package: " + ((SpdxElement)filesE[i]).getName());
                }
                this.files[i] = (SpdxFile)filesE[i];
            }
        }
        return this.files;
    }

    public void setFiles(SpdxFile[] files) throws InvalidSPDXAnalysisException {
        this.files = files;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "hasFile", this.files);
    }

    public void addFile(SpdxFile file) throws InvalidSPDXAnalysisException {
        if (file == null) {
            return;
        }
        if (this.files == null) {
            this.files = new SpdxFile[]{file};
        } else {
            this.files = Arrays.copyOf(this.files, this.files.length + 1);
            this.files[this.files.length - 1] = file;
        }
        this.addPropertyValue("http://spdx.org/rdf/terms#", "hasFile", file);
    }

    @Override
    public boolean equivalent(IRdfModel o) {
        return this.equivalent(o, true);
    }

    @Override
    public boolean equivalent(IRdfModel o, boolean testRelationships) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpdxPackage)) {
            return false;
        }
        if (!super.equivalent(o, testRelationships)) {
            return false;
        }
        SpdxPackage comp = (SpdxPackage)o;
        try {
            SpdxPackageVerificationCode myVerificationCode = this.getPackageVerificationCode();
            if (myVerificationCode == null ? comp.getPackageVerificationCode() != null : !myVerificationCode.equivalent(comp.getPackageVerificationCode())) {
                return false;
            }
            if (this.isFilesAnalyzed() != comp.isFilesAnalyzed()) {
                return false;
            }
            return this.equivalentConsideringNull(this.getLicenseDeclared(), comp.getLicenseDeclared()) && this.arraysEquivalent(this.getChecksums(), comp.getChecksums(), testRelationships) && RdfModelHelper.stringsEquivalent(this.getDescription(), comp.getDescription()) && RdfModelHelper.stringsEquivalent(this.getDownloadLocation(), comp.getDownloadLocation()) && this.arraysEquivalent(this.getFiles(false), comp.getFiles(false), testRelationships) && RdfModelHelper.stringsEquivalent(this.getHomepage(), comp.getHomepage()) && RdfModelHelper.stringsEquivalent(this.getOriginator(), comp.getOriginator()) && RdfModelHelper.stringsEquivalent(this.getPackageFileName(), comp.getPackageFileName()) && RdfModelHelper.stringsEquivalent(this.getSourceInfo(), comp.getSourceInfo()) && RdfModelHelper.stringsEquivalent(this.getSummary(), comp.getSummary()) && RdfModelHelper.stringsEquivalent(this.getSupplier(), comp.getSupplier()) && RdfModelHelper.stringsEquivalent(this.getVersionInfo(), comp.getVersionInfo()) && this.arraysEquivalent(this.getExternalRefs(), comp.getExternalRefs());
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Invalid analysis exception on comparing equivalent: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public SpdxPackage clone(Map<String, SpdxElement> clonedElementIds) {
        if (clonedElementIds.containsKey(this.getId())) {
            return (SpdxPackage)clonedElementIds.get(this.getId());
        }
        SpdxPackage retval = new SpdxPackage(this.name, this.comment, this.cloneAnnotations(), null, this.cloneLicenseConcluded(), this.cloneLicenseInfosFromFiles(), this.copyrightText, this.licenseComments, this.cloneLicenseDeclared(), this.cloneCheckums(), this.description, this.downloadLocation, null, this.homepage, this.originator, this.packageFileName, this.clonePackageVerificationCode(), this.sourceInfo, this.summary, this.supplier, this.versionInfo, this.filesAnalyzed, this.cloneExternalRefs());
        clonedElementIds.put(this.getId(), retval);
        try {
            retval.setRelationships(this.cloneRelationships(clonedElementIds));
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Unexected error setting relationships during clone", (Throwable)e);
        }
        try {
            retval.setFiles(this.cloneFiles(clonedElementIds));
        }
        catch (InvalidSPDXAnalysisException e) {
            logger.error("Unexected error setting relationships during clone", (Throwable)e);
        }
        return retval;
    }

    private ExternalRef[] cloneExternalRefs() {
        if (this.externalRefs == null) {
            return null;
        }
        ExternalRef[] retval = new ExternalRef[this.externalRefs.length];
        for (int i = 0; i < this.externalRefs.length; ++i) {
            retval[i] = this.externalRefs[i].clone();
        }
        return retval;
    }

    @Override
    public SpdxPackage clone() {
        return this.clone((Map)Maps.newHashMap());
    }

    private SpdxPackageVerificationCode clonePackageVerificationCode() {
        if (this.packageVerificationCode == null) {
            return null;
        }
        return new SpdxPackageVerificationCode(this.packageVerificationCode.getValue(), this.packageVerificationCode.getExcludedFileNames());
    }

    private SpdxFile[] cloneFiles(Map<String, SpdxElement> clonedElementIds) {
        if (this.files == null) {
            return new SpdxFile[0];
        }
        SpdxFile[] retval = new SpdxFile[this.files.length];
        for (int i = 0; i < this.files.length; ++i) {
            retval[i] = this.files[i].clone((Map)clonedElementIds);
        }
        return retval;
    }

    private AnyLicenseInfo cloneLicenseDeclared() {
        if (this.licenseDeclared == null) {
            return null;
        }
        return this.licenseDeclared.clone();
    }

    private Checksum[] cloneCheckums() {
        if (this.checksums == null) {
            return new Checksum[0];
        }
        Checksum[] retval = new Checksum[this.checksums.length];
        for (int i = 0; i < this.checksums.length; ++i) {
            retval[i] = this.checksums[i].clone();
        }
        return retval;
    }

    @Override
    public List<String> verify() {
        String error;
        String originator;
        String error2;
        String pkgName = this.name;
        if (pkgName == null) {
            pkgName = "UNKNOWN PACKAGE";
        }
        List<String> retval = super.verify();
        String downloadLocation = this.getDownloadLocation();
        if (downloadLocation == null || downloadLocation.isEmpty()) {
            retval.add("Missing required download location for package " + pkgName);
        }
        for (int i = 0; i < this.checksums.length; ++i) {
            List<String> checksumVerify = this.checksums[i].verify();
            this.addNameToWarnings(checksumVerify);
            retval.addAll(checksumVerify);
        }
        try {
            AnyLicenseInfo declaredLicense = this.getLicenseDeclared();
            if (declaredLicense == null) {
                retval.add("Missing required declared license for package " + pkgName);
            } else {
                List<String> verify = declaredLicense.verify();
                this.addNameToWarnings(verify);
                retval.addAll(verify);
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid package declared license: " + e.getMessage());
        }
        if ((this.licenseInfoFromFiles == null || this.licenseInfoFromFiles.length == 0) && this.filesAnalyzed) {
            retval.add("Missing required license information from files for " + this.name);
        } else {
            boolean foundNonSimpleLic = false;
            for (int i = 0; i < this.licenseInfoFromFiles.length; ++i) {
                AnyLicenseInfo lic = this.licenseInfoFromFiles[i];
                if (lic instanceof SimpleLicensingInfo || lic instanceof SpdxNoAssertionLicense || lic instanceof SpdxNoneLicense || lic instanceof OrLaterOperator || lic instanceof WithExceptionOperator) continue;
                foundNonSimpleLic = true;
                break;
            }
            if (foundNonSimpleLic) {
                retval.add("license info from files contains complex licenses for " + this.name);
            }
        }
        try {
            SpdxFile[] files = this.getFiles();
            if (files == null || files.length == 0) {
                if (this.filesAnalyzed) {
                    retval.add("Missing required package files for " + pkgName);
                }
            } else {
                if (!this.filesAnalyzed) {
                    retval.add("Warning: Found analyzed files for package " + pkgName + " when analyzedFiles is set to false.");
                }
                for (int i = 0; i < files.length; ++i) {
                    List<String> verify = files[i].verify();
                    this.addNameToWarnings(verify);
                    retval.addAll(verify);
                }
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid package files: " + e.getMessage());
        }
        SpdxPackageVerificationCode verificationCode = null;
        try {
            verificationCode = this.getPackageVerificationCode();
            if (verificationCode == null && this.filesAnalyzed) {
                retval.add("Missing required package verification code for package " + pkgName);
            } else if (verificationCode != null && verificationCode.getValue() != null && !verificationCode.getValue().isEmpty() && !this.filesAnalyzed) {
                retval.add("Verification code must not be included when files not analyzed.");
            } else if (this.filesAnalyzed) {
                List<String> verify = verificationCode.verify();
                this.addNameToWarnings(verify);
                retval.addAll(verify);
            }
        }
        catch (InvalidSPDXAnalysisException e) {
            retval.add("Invalid package verification code: " + e.getMessage());
        }
        String supplier = null;
        supplier = this.getSupplier();
        if (supplier != null && !supplier.isEmpty() && (error2 = SpdxVerificationHelper.verifySupplier(supplier)) != null && !error2.isEmpty()) {
            retval.add("Supplier error - " + error2 + " for package " + pkgName);
        }
        if ((originator = this.getOriginator()) != null && !originator.isEmpty() && (error = SpdxVerificationHelper.verifyOriginator(originator)) != null && !error.isEmpty()) {
            retval.add("Originator error - " + error + " for package " + pkgName);
        }
        if (this.externalRefs != null) {
            for (ExternalRef externalRef : this.externalRefs) {
                retval.addAll(externalRef.verify());
            }
        }
        return retval;
    }

    @Deprecated
    public String getDeclaredName() {
        return this.getName();
    }

    @Deprecated
    public String getDownloadUrl() {
        return this.getDownloadLocation();
    }

    @Deprecated
    public String getShortDescription() {
        return this.getSummary();
    }

    @Deprecated
    public String getFileName() {
        return this.getPackageFileName();
    }

    @Deprecated
    public SpdxPackageVerificationCode getVerificationCode() throws InvalidSPDXAnalysisException {
        return this.getPackageVerificationCode();
    }

    @Deprecated
    public String getDeclaredCopyright() {
        return this.getCopyrightText();
    }

    @Deprecated
    public AnyLicenseInfo getDeclaredLicense() throws InvalidSPDXAnalysisException {
        return this.getLicenseDeclared();
    }

    @Deprecated
    public AnyLicenseInfo getConcludedLicenses() {
        return this.getLicenseConcluded();
    }

    @Override
    public int compareTo(SpdxPackage pkg) {
        String compVersion;
        String myVersion;
        String myNameVersion = this.getName();
        String compNameVersion = pkg.getName();
        if (myNameVersion == null) {
            myNameVersion = "";
        }
        if (compNameVersion == null) {
            compNameVersion = "";
        }
        if ((myVersion = this.getVersionInfo()) != null) {
            myNameVersion = myNameVersion + myVersion;
        }
        if ((compVersion = pkg.getVersionInfo()) != null) {
            compNameVersion = compNameVersion + compVersion;
        }
        return myNameVersion.compareToIgnoreCase(compNameVersion);
    }

    public String getSha1() {
        if (this.checksums != null) {
            for (int i = 0; i < this.checksums.length; ++i) {
                if (!this.checksums[i].getAlgorithm().equals((Object)Checksum.ChecksumAlgorithm.checksumAlgorithm_sha1)) continue;
                return this.checksums[i].getValue();
            }
        }
        return "";
    }

    public void addExternalRef(ExternalRef externalRef) throws InvalidSPDXAnalysisException {
        if (externalRef == null) {
            return;
        }
        if (this.externalRefs == null) {
            this.externalRefs = new ExternalRef[]{externalRef};
        } else {
            this.externalRefs = Arrays.copyOf(this.externalRefs, this.externalRefs.length + 1);
            this.externalRefs[this.externalRefs.length - 1] = externalRef;
        }
        this.addPropertyValue("http://spdx.org/rdf/terms#", "externalRef", externalRef);
    }
}

