/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import org.apache.commons.lang3.ArrayUtils;
import org.spdx.rdfparser.license.ListedLicenses;
import org.spdx.tools.CompareMultpleSpdxDocs;
import org.spdx.tools.GenerateVerificationCode;
import org.spdx.tools.MatchingStandardLicenses;
import org.spdx.tools.RdfToHtml;
import org.spdx.tools.RdfToSpreadsheet;
import org.spdx.tools.RdfToTag;
import org.spdx.tools.SpdxViewer;
import org.spdx.tools.SpreadsheetToRDF;
import org.spdx.tools.SpreadsheetToTag;
import org.spdx.tools.TagToRDF;
import org.spdx.tools.TagToSpreadsheet;
import org.spdx.tools.Verify;

public class Main {
    public static void main(String[] args) {
        if (args.length < 1) {
            Main.usage();
            return;
        }
        String spdxTool = args[0];
        args = (String[])ArrayUtils.removeElement((Object[])args, (Object)args[0]);
        if (spdxTool.equalsIgnoreCase("SpdxViewer")) {
            SpdxViewer.main(args);
        } else if (spdxTool.equalsIgnoreCase("TagToSpreadsheet")) {
            TagToSpreadsheet.main(args);
        } else if (spdxTool.equalsIgnoreCase("TagToRDF")) {
            TagToRDF.main(args);
        } else if (spdxTool.equalsIgnoreCase("RdfToTag")) {
            RdfToTag.main(args);
        } else if (spdxTool.equalsIgnoreCase("RdfToHtml")) {
            RdfToHtml.main(args);
        } else if (spdxTool.equalsIgnoreCase("RdfToSpreadsheet")) {
            RdfToSpreadsheet.main(args);
        } else if (spdxTool.equalsIgnoreCase("SpreadsheetToRDF")) {
            SpreadsheetToRDF.main(args);
        } else if (spdxTool.equalsIgnoreCase("SpreadsheetToTag")) {
            SpreadsheetToTag.main(args);
        } else if (spdxTool.equalsIgnoreCase("CompareMultipleSpdxDocs")) {
            CompareMultpleSpdxDocs.main(args);
        } else if (spdxTool.equalsIgnoreCase("CompareSpdxDocs")) {
            System.out.println("This tool has not been updated to the 2.1 spec.  Please use the CompareMultipleSpdxDocs command.");
        } else if (spdxTool.equalsIgnoreCase("Verify")) {
            Verify.main(args);
        } else if (spdxTool.equalsIgnoreCase("GenerateVerificationCode")) {
            GenerateVerificationCode.main(args);
        } else if (spdxTool.equalsIgnoreCase("MergeSpdxDocs")) {
            System.out.println("The merge tools are currently being upgraded to SPDX 2.0");
        } else if (spdxTool.equalsIgnoreCase("MatchingStandardLicenses")) {
            MatchingStandardLicenses.main(args);
        } else if (spdxTool.equalsIgnoreCase("Version")) {
            System.out.println("SPDX Tool Version: 2.2.0; Specification Version: SPDX-2.2; License List Version: " + ListedLicenses.getListedLicenses().getLicenseListVersion());
        } else {
            Main.usage();
        }
    }

    private static void usage() {
        System.out.println("Usage: java -jar spdx-tools-jar-with-dependencies.jar <function> <parameters> \nfunction                 parameter                         example \n------------------------------------------------------------------------------------------------------------------- \nTagToSpreadsheet         inputFile outputFile              Examples/SPDXTagExample.tag TagToSpreadsheet.xls \nTagToRDF                 inputFile outputFile [format]     Examples/SPDXTagExample.tag TagToRDF.rdf \nRdfToTag                 inputFile outputFile              TestFiles/SPDXRdfExample.rdf  RdfToTag.tag \nRdfToHtml                inputFile outputFile              TestFiles/SPDXRdfExample.rdf  RdfToHtml.html \nRdfToSpreadsheet         inputFile outputFile              TestFiles/SPDXRdfExample.rdf RdfToSpreadsheet.xls \nSpreadsheetToRDF         inputFile outputFile              Examples/SPDXSpreadsheetExample.xls SpreadsheetToRDF.rdf \nSpreadsheetToTag         inputFile outputFile              Examples/SPDXSpreadsheetExample.xls SpreadsheetToTag.tag \nSPDXViewer               inputFile                         TestFiles/SPDXRdfExample.rdf \nVerify                   inputFile                         TestFiles/SPDXRdfExample.rdf \nCompareMultipleSpdxDocs  output.xls doc1 doc2 ... docN \nCompareSpdxDocs          doc1 doc2 [output] \nGenerateVerificationCode sourceDirectory\nVersion\nMatchingStandardLicenses licenseTextFile");
    }
}

