/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.spdx.html.AbstractJsonFile;
import org.spdx.rdfparser.license.SpdxListedLicense;

public class LicenseJSONFile
extends AbstractJsonFile {
    private boolean deprecated;
    private SpdxListedLicense license;

    public void setLicense(SpdxListedLicense license, boolean deprecated) {
        this.license = license;
        this.deprecated = deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    private Object isDeprecated() {
        return this.deprecated;
    }

    @Override
    protected JSONObject getJsonObject() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"licenseId", (Object)this.license.getLicenseId());
        jsonObject.put((Object)"isOsiApproved", (Object)this.license.isOsiApproved());
        if (this.license.getFsfLibre() != null) {
            jsonObject.put((Object)"isFsfLibre", (Object)this.license.isFsfLibre());
        }
        jsonObject.put((Object)"name", (Object)this.license.getName());
        String[] seeAlsos = this.license.getSeeAlso();
        String[] crossRefs = this.license.getCrossRef();
        if (seeAlsos != null && seeAlsos.length > 0) {
            JSONArray seeAlsoArray = new JSONArray();
            for (String seeAlso : seeAlsos) {
                seeAlsoArray.add((Object)seeAlso);
            }
            jsonObject.put((Object)"seeAlso", (Object)seeAlsoArray);
        }
        if (crossRefs != null && crossRefs.length > 0) {
            JSONArray crossRefArray = new JSONArray();
            for (String crossRef : crossRefs) {
                crossRefArray.add((Object)crossRef);
            }
            jsonObject.put((Object)"crossRef", (Object)crossRefArray);
        }
        if (this.license.getComment() != null && !this.license.getComment().isEmpty()) {
            jsonObject.put((Object)"licenseComments", (Object)this.license.getComment());
        }
        if (this.license.getLicenseText() != null) {
            jsonObject.put((Object)"licenseText", (Object)this.license.getLicenseText().replaceAll("\\r\\n", "\n").replaceAll("\\r", "\n"));
        }
        if (this.license.getStandardLicenseHeader() != null) {
            jsonObject.put((Object)"standardLicenseHeader", (Object)this.license.getStandardLicenseHeader().replaceAll("\\r\\n", "\n").replaceAll("\\r", "\n"));
            if (this.license.getStandardLicenseHeaderTemplate() != null) {
                jsonObject.put((Object)"standardLicenseHeaderTemplate", (Object)this.license.getStandardLicenseHeaderTemplate().replaceAll("\\r\\n", "\n").replaceAll("\\r", "\n"));
            } else {
                jsonObject.put((Object)"standardLicenseHeaderTemplate", (Object)this.license.getStandardLicenseHeader().replaceAll("\\r\\n", "\n").replaceAll("\\r", "\n"));
            }
        }
        if (this.license.getStandardLicenseTemplate() != null) {
            jsonObject.put((Object)"standardLicenseTemplate", (Object)this.license.getStandardLicenseTemplate().replaceAll("\\r\\n", "\n").replaceAll("\\r", "\n"));
        }
        jsonObject.put((Object)"isDeprecatedLicenseId", this.isDeprecated());
        return jsonObject;
    }
}

