/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.license;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.license.LicenseJsonTOC;
import org.spdx.rdfparser.license.NoListedLicenseRdfModel;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.spdx.rdfparser.model.IRdfModel;

public class ListedLicenses
implements IModelContainer {
    public static final String DEFAULT_LICENSE_LIST_VERSION = "3.5";
    static final Logger logger = LoggerFactory.getLogger((String)ListedLicenses.class.getName());
    static final String LISTED_LICENSE_ID_URL = "http://spdx.org/licenses/";
    public static final String LISTED_LICENSE_URI_PREFIX = "https://spdx.org/licenses/";
    static final String LISTED_LICENSE_RDF_LOCAL_DIR = "resources/stdlicenses";
    private static final String LICENSE_TOC_FILENAME = "licenses.json";
    private static final String LISTED_LICENSE_PROPERTIES_FILENAME = "resources/stdlicenses/licenses.properties";
    private Model listedLicenseModel = null;
    Map<String, String> listdLicenseIds = null;
    Map<String, SpdxListedLicense> listedLicenseCache = null;
    Map<IModelContainer, Map<Node, SpdxListedLicense>> listedLicenseNodeCache = Maps.newHashMap();
    Properties licenseProperties = ListedLicenses.loadLicenseProperties();
    boolean onlyUseLocalLicenses;
    File localLicensesDir = null;
    String licenseListVersion = "3.5";
    private static volatile ListedLicenses listedLicenses = null;
    private static final ReadWriteLock listedLicenseModificationLock = new ReentrantReadWriteLock();
    private static final String JSONLD_URL_SUFFIX = ".jsonld";
    int nextId = 0;

    private ListedLicenses() {
        String stOnlyLicenses = System.getenv("SPDXParser.OnlyUseLocalLicenses");
        this.onlyUseLocalLicenses = Objects.isNull(stOnlyLicenses) || stOnlyLicenses.isEmpty() ? Boolean.parseBoolean(System.getProperty("SPDXParser.OnlyUseLocalLicenses", this.licenseProperties.getProperty("OnlyUseLocalLicenses", "false"))) : Boolean.parseBoolean(stOnlyLicenses);
        if (this.onlyUseLocalLicenses) {
            try {
                String localLicensesDirStr = System.getenv("SPDXParser.LocalLicensesDir");
                if (Objects.isNull(localLicensesDirStr) || localLicensesDirStr.isEmpty()) {
                    localLicensesDirStr = System.getProperty("SPDXParser.LocalLicensesDir", this.licenseProperties.getProperty("SPDXParser.LocalLicensesDir"));
                }
                if (Objects.isNull(localLicensesDirStr)) {
                    this.localLicensesDir = null;
                } else {
                    this.localLicensesDir = new File(localLicensesDirStr);
                    if (!this.localLicensesDir.isDirectory()) {
                        logger.error("Local license directory " + localLicensesDirStr + " is not a directory");
                        this.localLicensesDir = null;
                    }
                }
            }
            catch (Exception ex) {
                logger.error("Error getting local licenses directory", (Throwable)ex);
                this.localLicensesDir = null;
            }
        }
        this.loadListedLicenseIDs();
    }

    public static ListedLicenses getListedLicenses() {
        if (listedLicenses == null) {
            listedLicenseModificationLock.writeLock().lock();
            try {
                if (listedLicenses == null) {
                    listedLicenses = new ListedLicenses();
                }
            }
            finally {
                listedLicenseModificationLock.writeLock().unlock();
            }
        }
        return listedLicenses;
    }

    public static ListedLicenses resetListedLicenses() {
        listedLicenseModificationLock.writeLock().lock();
        try {
            ListedLicenses listedLicenses = ListedLicenses.listedLicenses = new ListedLicenses();
            return listedLicenses;
        }
        finally {
            listedLicenseModificationLock.writeLock().unlock();
        }
    }

    @Override
    public Model getModel() {
        listedLicenseModificationLock.writeLock().lock();
        try {
            if (this.listedLicenseModel == null) {
                this.listedLicenseModel = ModelFactory.createDefaultModel();
            }
        }
        finally {
            listedLicenseModificationLock.writeLock().unlock();
        }
        return this.listedLicenseModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SpdxListedLicense getLicenseFromUri(String uri) throws InvalidSPDXAnalysisException {
        SpdxListedLicense retval;
        URL licenseUrl = null;
        try {
            licenseUrl = new URL(uri);
        }
        catch (MalformedURLException e) {
            throw new InvalidSPDXAnalysisException("Invalid listed license URL: " + e.getMessage());
        }
        String id = this.urlToId(licenseUrl);
        listedLicenseModificationLock.readLock().lock();
        try {
            if (this.listedLicenseCache.containsKey(id)) {
                SpdxListedLicense spdxListedLicense = this.listedLicenseCache.get(id);
                return spdxListedLicense;
            }
        }
        finally {
            listedLicenseModificationLock.readLock().unlock();
        }
        String base = LISTED_LICENSE_ID_URL + id;
        final Model localLicenseModel = this.getLicenseModel(uri, base);
        if (localLicenseModel == null) {
            throw new InvalidSPDXAnalysisException("No listed license was found at " + uri);
        }
        Resource licResource = localLicenseModel.getResource(base);
        if (licResource == null || !localLicenseModel.containsResource(localLicenseModel.asRDFNode(licResource.asNode()))) {
            throw new InvalidSPDXAnalysisException("No listed license was found at " + uri);
        }
        final String localLicenseNamespace = this.getDocumentNamespace();
        IModelContainer localLicenseContainer = new IModelContainer(){

            @Override
            public Model getModel() {
                return localLicenseModel;
            }

            @Override
            public String getDocumentNamespace() {
                return localLicenseNamespace;
            }

            @Override
            public String getNextSpdxElementRef() {
                return null;
            }

            @Override
            public boolean spdxElementRefExists(String elementRef) {
                return false;
            }

            @Override
            public void addSpdxElementRef(String elementRef) {
            }

            @Override
            public String documentNamespaceToId(String externalNamespace) {
                return null;
            }

            @Override
            public String externalDocumentIdToNamespace(String docId) {
                return null;
            }

            @Override
            public Resource createResource(Resource duplicate, String uri, Resource type, IRdfModel modelObject) {
                return null;
            }

            @Override
            public boolean addCheckNodeObject(Node node, IRdfModel rdfModelObject) {
                return true;
            }
        };
        if (this.getModel().equals((Object)localLicenseModel)) {
            retval = new SpdxListedLicense(localLicenseContainer, licResource.asNode());
        } else {
            SpdxListedLicense localLicense = new SpdxListedLicense(localLicenseContainer, licResource.asNode());
            retval = (SpdxListedLicense)localLicense.clone();
            retval.createResource(this);
        }
        listedLicenseModificationLock.writeLock().lock();
        try {
            this.listedLicenseCache.put(id, retval);
        }
        finally {
            listedLicenseModificationLock.writeLock().unlock();
        }
        return retval;
    }

    private String urlToId(URL licenseUrl) {
        String[] pathParts = licenseUrl.getFile().split("/");
        String id = pathParts[pathParts.length - 1];
        if (id.endsWith(JSONLD_URL_SUFFIX)) {
            id = id.substring(0, id.length() - JSONLD_URL_SUFFIX.length());
        }
        return id;
    }

    /*
     * Exception decompiling
     */
    private Model getLicenseModel(String uri, String base) throws NoListedLicenseRdfModel {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getNestedURL(String stringUrl) throws MalformedURLException {
        URL url = new URL(stringUrl);
        try {
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setInstanceFollowRedirects(false);
            con.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/62.0.3202.94 Safari/537.36");
            con.addRequestProperty("Accept-Language", "en-US,en;q=0.8");
            con.addRequestProperty("Referer", "https://www.google.com/");
            con.connect();
            int resultCode = con.getResponseCode();
            if (resultCode == 303 || resultCode == 301 || resultCode == 302) {
                String Location2 = con.getHeaderField("Location");
                if (Location2.startsWith("/")) {
                    Location2 = url.getProtocol() + "://" + url.getHost() + Location2;
                }
                return ListedLicenses.getNestedURL(Location2);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return url.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadListedLicenseIDs() {
        listedLicenseModificationLock.writeLock().lock();
        try {
            this.listedLicenseCache = Maps.newHashMap();
            this.listdLicenseIds = Maps.newHashMap();
            InputStream tocStream = null;
            BufferedReader reader = null;
            try {
                String line;
                if (this.onlyUseLocalLicenses) {
                    if (Objects.nonNull(this.localLicensesDir)) {
                        try {
                            tocStream = new FileInputStream(new File(this.localLicensesDir.getAbsolutePath() + File.separator + LICENSE_TOC_FILENAME));
                        }
                        catch (IOException e) {
                            logger.error("Json TOC local file missing or invalid - using installed licenses");
                        }
                    }
                } else {
                    try {
                        URL tocUrl = new URL("https://spdx.org/licenses/licenses.json");
                        tocStream = tocUrl.openStream();
                    }
                    catch (MalformedURLException e) {
                        logger.error("Json TOC URL invalid, using local TOC file");
                        tocStream = null;
                    }
                    catch (IOException e) {
                        logger.error("I/O error opening Json TOC URL, using local TOC file");
                        tocStream = null;
                    }
                }
                if (tocStream == null) {
                    String fileName = "resources/stdlicenses/licenses.json";
                    tocStream = LicenseInfoFactory.class.getResourceAsStream("/" + fileName);
                }
                if (tocStream == null) {
                    logger.error("Unable to load license ID's from JSON TOC file");
                }
                reader = new BufferedReader(new InputStreamReader(tocStream));
                StringBuilder tocJsonStr = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    tocJsonStr.append(line);
                }
                Gson gson = new Gson();
                LicenseJsonTOC jsonToc = (LicenseJsonTOC)gson.fromJson(tocJsonStr.toString(), LicenseJsonTOC.class);
                this.listdLicenseIds = jsonToc.getLicenseIds();
                this.licenseListVersion = jsonToc.getLicenseListVersion();
            }
            catch (IOException e) {
                logger.error("I/O error reading JSON TOC file");
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        logger.warn("Unable to close JSON TOC reader");
                    }
                } else if (tocStream != null) {
                    try {
                        tocStream.close();
                    }
                    catch (IOException e) {
                        logger.warn("Unable to close JSON TOC input stream");
                    }
                }
            }
        }
        finally {
            listedLicenseModificationLock.writeLock().unlock();
        }
    }

    public boolean isSpdxListedLicenseID(String licenseID) {
        try {
            listedLicenseModificationLock.readLock().lock();
            boolean bl = this.listdLicenseIds.containsKey(licenseID.toLowerCase());
            return bl;
        }
        finally {
            listedLicenseModificationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadLicenseProperties() {
        listedLicenseModificationLock.writeLock().lock();
        try {
            Properties licenseProperties = new Properties();
            InputStream in = null;
            try {
                in = LicenseInfoFactory.class.getResourceAsStream("/resources/stdlicenses/licenses.properties");
                if (in != null) {
                    licenseProperties.load(in);
                }
            }
            catch (IOException e) {
                logger.warn("IO Exception reading listed license properties file: " + e.getMessage());
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        logger.warn("Unable to close listed license properties file: " + e.getMessage());
                    }
                }
            }
            Properties properties = licenseProperties;
            return properties;
        }
        finally {
            listedLicenseModificationLock.writeLock().unlock();
        }
    }

    public String[] getSpdxListedLicenseIds() {
        listedLicenseModificationLock.readLock().lock();
        try {
            String[] stringArray = this.listdLicenseIds.values().toArray(new String[this.listdLicenseIds.size()]);
            return stringArray;
        }
        finally {
            listedLicenseModificationLock.readLock().unlock();
        }
    }

    public String getLicenseListVersion() {
        return this.licenseListVersion;
    }

    public SpdxListedLicense getListedLicenseById(String licenseId) throws InvalidSPDXAnalysisException {
        SpdxListedLicense retval = this.getLicenseFromUri(LISTED_LICENSE_URI_PREFIX + this.listdLicenseIds.get(licenseId.toLowerCase()) + JSONLD_URL_SUFFIX);
        if (retval != null) {
            retval = (SpdxListedLicense)retval.clone();
        }
        return retval;
    }

    public AnyLicenseInfo getLicenseFromStdLicModel(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        HashMap modelNodeCache = this.listedLicenseNodeCache.get(modelContainer);
        if (modelNodeCache == null) {
            modelNodeCache = Maps.newHashMap();
            this.listedLicenseNodeCache.put(modelContainer, modelNodeCache);
        }
        if (modelNodeCache.containsKey(node)) {
            return (AnyLicenseInfo)modelNodeCache.get(node);
        }
        SpdxListedLicense retval = new SpdxListedLicense(modelContainer, node);
        if (!this.equals(modelContainer)) {
            String licenseId = retval.getLicenseId();
            if (licenseId == null) {
                URL licenseUrl;
                try {
                    licenseUrl = new URL(node.getURI());
                }
                catch (MalformedURLException e) {
                    throw new InvalidSPDXAnalysisException("Invalid license URL");
                }
                licenseId = this.urlToId(licenseUrl);
            }
            try {
                SpdxListedLicense licenseFromModel = this.getListedLicenseById(licenseId);
                retval.copyFrom(licenseFromModel);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        modelNodeCache.put(node, retval);
        return retval;
    }

    @Override
    public String getDocumentNamespace() {
        return LISTED_LICENSE_ID_URL;
    }

    @Override
    public synchronized String getNextSpdxElementRef() {
        ++this.nextId;
        return "SpdxLicenseGeneratedId-" + String.valueOf(this.nextId);
    }

    @Override
    public boolean spdxElementRefExists(String elementRef) {
        return this.listdLicenseIds.values().contains(elementRef);
    }

    @Override
    public void addSpdxElementRef(String elementRef) {
        this.listdLicenseIds.put(elementRef.toLowerCase(), elementRef);
    }

    @Override
    public String documentNamespaceToId(String externalNamespace) {
        return null;
    }

    @Override
    public String externalDocumentIdToNamespace(String docId) {
        return null;
    }

    @Override
    public Resource createResource(Resource duplicate, String uri, Resource type, IRdfModel modelObject) {
        if (duplicate != null) {
            return duplicate;
        }
        if (uri == null) {
            return this.listedLicenseModel.createResource(this.getType(this.listedLicenseModel));
        }
        return this.listedLicenseModel.createResource(uri, this.getType(this.listedLicenseModel));
    }

    private Resource getType(Model model) {
        return model.createResource("http://spdx.org/rdf/terms#License");
    }

    @Override
    public boolean addCheckNodeObject(Node node, IRdfModel rdfModelObject) {
        return true;
    }
}

