/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.license;

import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.spdx.html.InvalidLicenseTemplateException;
import org.spdx.licenseTemplate.LicenseTemplateRuleException;
import org.spdx.licenseTemplate.SpdxLicenseTemplateHelper;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.License;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.model.IRdfModel;

public class SpdxListedLicense
extends License {
    private String licenseTextHtml = null;
    private String licenseHeaderHtml = null;
    private String deprecatedVersion = null;

    public SpdxListedLicense(String name, String id, String text, String[] sourceUrl, String comments, String standardLicenseHeader, String template, boolean osiApproved, Boolean fsfLibre, String licenseTextHtml, boolean isDeprecated, String deprecatedVersion) throws InvalidSPDXAnalysisException {
        super(name, id, text, sourceUrl, comments, standardLicenseHeader, template, osiApproved, fsfLibre);
        this.licenseTextHtml = licenseTextHtml;
        this.setDeprecated(isDeprecated);
        this.deprecatedVersion = deprecatedVersion;
    }

    public SpdxListedLicense(String name, String id, String text, String[] sourceUrl, String comments, String standardLicenseHeader, String template, boolean osiApproved, String licenseTextHtml) throws InvalidSPDXAnalysisException {
        this(name, id, text, sourceUrl, comments, standardLicenseHeader, template, osiApproved, (Boolean)false, licenseTextHtml, false, null);
    }

    public SpdxListedLicense(String name, String id, String text, String[] sourceUrl, String comments, String standardLicenseHeader, String template, boolean osiApproved, boolean fsfLibre) throws InvalidSPDXAnalysisException {
        this(name, id, text, sourceUrl, comments, standardLicenseHeader, template, osiApproved, (Boolean)fsfLibre, null, false, null);
    }

    public SpdxListedLicense(String name, String id, String text, String[] sourceUrl, String comments, String standardLicenseHeader, String template, boolean osiApproved) throws InvalidSPDXAnalysisException {
        this(name, id, text, sourceUrl, comments, standardLicenseHeader, template, osiApproved, (Boolean)false, null, false, null);
    }

    public SpdxListedLicense(IModelContainer modelContainer, Node licenseNode) throws InvalidSPDXAnalysisException {
        super(modelContainer, licenseNode);
    }

    public SpdxListedLicense(String name, String id, String text, String[] sourceUrl, String comments, String standardLicenseHeader, String template, String licenseHeaderTemplate, boolean osiApproved, boolean fsfLibre, String licenseTextHtml, String licenseHeaderHtml) throws InvalidSPDXAnalysisException {
        super(name, id, text, sourceUrl, comments, standardLicenseHeader, template, licenseHeaderTemplate, osiApproved, fsfLibre);
        this.licenseTextHtml = licenseTextHtml;
        this.licenseHeaderHtml = licenseHeaderHtml;
    }

    public SpdxListedLicense(String name, String id, String text, String[] sourceUrl, String comments, String standardLicenseHeader, String template, String licenseHeaderTemplate, boolean osiApproved, Boolean fsfLibre) throws InvalidSPDXAnalysisException {
        super(name, id, text, sourceUrl, comments, standardLicenseHeader, template, licenseHeaderTemplate, osiApproved, fsfLibre);
    }

    public SpdxListedLicense(String name, String id, String text, String[] sourceUrl, String[] sourceUrlDetails, String comments, String standardLicenseHeader, String template, String licenseHeaderTemplate, boolean osiApproved, Boolean fsfLibre) throws InvalidSPDXAnalysisException {
        super(name, id, text, sourceUrl, sourceUrlDetails, comments, standardLicenseHeader, template, licenseHeaderTemplate, osiApproved, fsfLibre);
    }

    @Override
    public List<String> verify() {
        List<String> retval = super.verify();
        if (!LicenseInfoFactory.isSpdxListedLicenseID(this.getLicenseId())) {
            retval.add("License " + this.getLicenseId() + " is not a listed license at spdx.org/licenses");
        }
        if (this.isDeprecated()) {
            retval.add(this.licenseId + " is deprecated.");
        }
        return retval;
    }

    private String createStdLicenseUri(String id) {
        return "http://spdx.org/licenses/" + id;
    }

    @Override
    public Resource getType(Model model) {
        return model.createResource("http://spdx.org/rdf/terms#License");
    }

    @Override
    public String getUri(IModelContainer modelContainer) throws InvalidSPDXAnalysisException {
        return this.createStdLicenseUri(this.licenseId);
    }

    @Override
    public boolean equivalent(IRdfModel compare) {
        if (!(compare instanceof SpdxListedLicense)) {
            return false;
        }
        SpdxListedLicense sCompare = (SpdxListedLicense)compare;
        if (this.licenseId == null) {
            return sCompare.getLicenseId() == null;
        }
        if (sCompare.getLicenseId() == null) {
            return false;
        }
        return this.licenseId.equalsIgnoreCase(sCompare.getLicenseId());
    }

    public String getLicenseTextHtml() throws InvalidLicenseTemplateException {
        if (this.licenseTextHtml == null) {
            String templateText = this.getStandardLicenseTemplate();
            if (templateText != null && !templateText.trim().isEmpty()) {
                try {
                    this.licenseTextHtml = SpdxLicenseTemplateHelper.templateTextToHtml(templateText);
                }
                catch (LicenseTemplateRuleException ex) {
                    throw new InvalidLicenseTemplateException("Invalid license expression found in license text for license " + this.getName() + ":" + ex.getMessage());
                }
            } else {
                this.licenseTextHtml = SpdxLicenseTemplateHelper.formatEscapeHTML(this.getLicenseText());
            }
        }
        return this.licenseTextHtml;
    }

    public void setLicenseTextHtml(String licenseTextHtml) {
        this.licenseTextHtml = licenseTextHtml;
    }

    public String getLicenseHeaderHtml() throws InvalidLicenseTemplateException {
        if (this.licenseHeaderHtml == null) {
            String templateText = this.getStandardLicenseHeaderTemplate();
            if (templateText != null && !templateText.trim().isEmpty()) {
                try {
                    this.licenseHeaderHtml = SpdxLicenseTemplateHelper.templateTextToHtml(templateText);
                }
                catch (LicenseTemplateRuleException ex) {
                    throw new InvalidLicenseTemplateException("Invalid license expression found in standard license header for license " + this.getName() + ":" + ex.getMessage());
                }
            } else {
                this.licenseHeaderHtml = this.getStandardLicenseHeader() == null ? "" : SpdxLicenseTemplateHelper.formatEscapeHTML(this.getStandardLicenseHeader());
            }
        }
        return this.licenseHeaderHtml;
    }

    public void setLicenseHeaderHtml(String licenseHeaderHtml) {
        this.licenseHeaderHtml = licenseHeaderHtml;
    }

    public String getDeprecatedVersion() {
        return this.deprecatedVersion;
    }

    public void setDeprecatedVersion(String deprecatedVersion) {
        this.deprecatedVersion = deprecatedVersion;
    }
}

