/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.spdxspreadsheet.AbstractSpreadsheet;
import org.spdx.spdxspreadsheet.AnnotationsSheet;
import org.spdx.spdxspreadsheet.DocumentInfoSheet;
import org.spdx.spdxspreadsheet.ExternalRefsSheet;
import org.spdx.spdxspreadsheet.NonStandardLicensesSheet;
import org.spdx.spdxspreadsheet.NonStandardLicensesSheetV0d9d4;
import org.spdx.spdxspreadsheet.PackageInfoSheet;
import org.spdx.spdxspreadsheet.PackageInfoSheetV09d2;
import org.spdx.spdxspreadsheet.PerFileSheet;
import org.spdx.spdxspreadsheet.PerFileSheetV09d3;
import org.spdx.spdxspreadsheet.RelationshipsSheet;
import org.spdx.spdxspreadsheet.ReviewersSheet;
import org.spdx.spdxspreadsheet.SnippetSheet;
import org.spdx.spdxspreadsheet.SpreadsheetException;

public class SPDXSpreadsheet
extends AbstractSpreadsheet {
    public static final String CURRENT_VERSION = "2.2.0";
    public static final String VERSION_2_1_0 = "2.1.0";
    public static final String VERSION_2_0_0 = "2.0.0";
    public static final String VERSION_1_2_0 = "1.2.0";
    public static final String VERSION_1_1_0 = "1.1.0";
    public static final String VERSION_0_9_4 = "0.9.4";
    public static final String VERSION_0_9_3 = "0.9.3";
    public static final String VERSION_0_9_2 = "0.9.2";
    public static final String VERSION_0_9_1 = "0.9.1";
    public static final ImmutableList<String> SUPPORTED_VERSIONS = new ImmutableList.Builder().add((Object)"2.2.0").add((Object)"0.9.4").add((Object)"0.9.3").add((Object)"0.9.2").add((Object)"0.9.1").add((Object)"2.0.0").add((Object)"2.1.0").build();
    public static final String UNKNOWN_VERSION = "UNKNOWN";
    private DocumentInfoSheet documentInfoSheet;
    static final String DOCUMENT_INFO_NAME = "Document Info";
    private PackageInfoSheet packageInfoSheet;
    static final String PACKAGE_INFO_SHEET_NAME = "Package Info";
    private NonStandardLicensesSheet nonStandardLicensesSheet;
    static final String NON_STANDARD_LICENSE_SHEET_NAME = "Extracted License Info";
    private PerFileSheet perFileSheet;
    static final String PER_FILE_SHEET_NAME = "Per File Info";
    private RelationshipsSheet relationshipsSheet;
    static final String RELATIONSHIPS_SHEET_NAME = "Relationships";
    private AnnotationsSheet annotationsSheet;
    static final String ANNOTATIONS_SHEET_NAME = "Annotations";
    private ReviewersSheet reviewersSheet;
    static final String REVIEWERS_SHEET_NAME = "Reviewers";
    private SnippetSheet snippetSheet;
    static final String SNIPPET_SHEET_NAME = "Snippets";
    private ExternalRefsSheet externalRefsSheet;
    static final String EXTERNAL_REFS_SHEET_NAME = "External Refs";
    private String version;

    public SPDXSpreadsheet(File spreadsheetFile, boolean create, boolean readonly) throws SpreadsheetException {
        super(spreadsheetFile, create, readonly);
        this.version = this.readVersion(this.workbook, DOCUMENT_INFO_NAME);
        if (this.version.equals(UNKNOWN_VERSION)) {
            throw new SpreadsheetException("The version for the SPDX spreadsheet could not be read.");
        }
        this.documentInfoSheet = DocumentInfoSheet.openVersion(this.workbook, DOCUMENT_INFO_NAME, this.version);
        String verifyMsg = this.documentInfoSheet.verify();
        if (verifyMsg != null) {
            logger.error(verifyMsg);
            throw new SpreadsheetException(verifyMsg);
        }
        this.packageInfoSheet = PackageInfoSheet.openVersion(this.workbook, PACKAGE_INFO_SHEET_NAME, this.version);
        this.nonStandardLicensesSheet = NonStandardLicensesSheetV0d9d4.openVersion(this.workbook, NON_STANDARD_LICENSE_SHEET_NAME, this.version);
        this.perFileSheet = PerFileSheet.openVersion(this.workbook, PER_FILE_SHEET_NAME, this.version);
        this.relationshipsSheet = new RelationshipsSheet(this.workbook, RELATIONSHIPS_SHEET_NAME);
        this.annotationsSheet = new AnnotationsSheet(this.workbook, ANNOTATIONS_SHEET_NAME);
        this.reviewersSheet = new ReviewersSheet(this.workbook, REVIEWERS_SHEET_NAME, this.version);
        this.snippetSheet = new SnippetSheet(this.workbook, SNIPPET_SHEET_NAME);
        this.externalRefsSheet = new ExternalRefsSheet(this.workbook, EXTERNAL_REFS_SHEET_NAME);
        verifyMsg = this.verifyWorkbook();
        if (verifyMsg != null) {
            logger.error(verifyMsg);
            throw new SpreadsheetException(verifyMsg);
        }
    }

    private String readVersion(Workbook workbook, String originSheetName) throws SpreadsheetException {
        Sheet sheet = workbook.getSheet(originSheetName);
        if (sheet == null) {
            throw new SpreadsheetException("Invalid SPDX spreadsheet.  Sheet " + originSheetName + " does not exist.");
        }
        int firstRowNum = sheet.getFirstRowNum();
        Row dataRow = sheet.getRow(firstRowNum + 1);
        if (dataRow == null) {
            return UNKNOWN_VERSION;
        }
        Cell versionCell = dataRow.getCell(0);
        if (versionCell == null) {
            return UNKNOWN_VERSION;
        }
        return versionCell.getStringCellValue();
    }

    public static boolean verifyVersion(String versionToCheck) {
        String trVersion = versionToCheck.trim();
        return SUPPORTED_VERSIONS.contains((Object)trVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(File spreadsheetFile) throws IOException, SpreadsheetException {
        if (!spreadsheetFile.createNewFile()) {
            logger.error("Unable to create " + spreadsheetFile.getName());
            throw new SpreadsheetException("Unable to create " + spreadsheetFile.getName());
        }
        try (FileOutputStream excelOut = null;){
            excelOut = new FileOutputStream(spreadsheetFile);
            HSSFWorkbook wb = new HSSFWorkbook();
            DocumentInfoSheet.create((Workbook)wb, DOCUMENT_INFO_NAME);
            PackageInfoSheet.create((Workbook)wb, PACKAGE_INFO_SHEET_NAME);
            ExternalRefsSheet.create((Workbook)wb, EXTERNAL_REFS_SHEET_NAME);
            NonStandardLicensesSheet.create((Workbook)wb, NON_STANDARD_LICENSE_SHEET_NAME);
            PerFileSheet.create((Workbook)wb, PER_FILE_SHEET_NAME);
            RelationshipsSheet.create((Workbook)wb, RELATIONSHIPS_SHEET_NAME);
            AnnotationsSheet.create((Workbook)wb, ANNOTATIONS_SHEET_NAME);
            SnippetSheet.create((Workbook)wb, SNIPPET_SHEET_NAME);
            ReviewersSheet.create((Workbook)wb, REVIEWERS_SHEET_NAME);
            wb.write((OutputStream)excelOut);
        }
    }

    @Override
    public void clear() {
        this.documentInfoSheet.clear();
        this.packageInfoSheet.clear();
        this.nonStandardLicensesSheet.clear();
        this.perFileSheet.clear();
        this.relationshipsSheet.clear();
        this.annotationsSheet.clear();
        this.reviewersSheet.clear();
        this.snippetSheet.clear();
        this.externalRefsSheet.clear();
    }

    @Override
    public String verifyWorkbook() {
        String retval = this.documentInfoSheet.verify();
        if (retval == null || retval.isEmpty()) {
            retval = this.packageInfoSheet.verify();
        }
        if (retval == null || retval.isEmpty()) {
            retval = this.nonStandardLicensesSheet.verify();
        }
        if (retval == null || retval.isEmpty()) {
            retval = this.perFileSheet.verify();
        }
        if (retval == null || retval.isEmpty()) {
            retval = this.reviewersSheet.verify();
        }
        if (retval == null || retval.isEmpty()) {
            retval = this.relationshipsSheet.verify();
        }
        if (retval == null || retval.isEmpty()) {
            retval = this.annotationsSheet.verify();
        }
        if ((retval == null || retval.isEmpty()) && VERSION_2_0_0.compareTo(this.version) < 0) {
            retval = this.snippetSheet.verify();
        }
        if ((retval == null || retval.isEmpty()) && VERSION_2_0_0.compareTo(this.version) < 0) {
            retval = this.externalRefsSheet.verify();
        }
        return retval;
    }

    public DocumentInfoSheet getOriginsSheet() {
        return this.documentInfoSheet;
    }

    public void setOriginsSheet(DocumentInfoSheet originsSheet) {
        this.documentInfoSheet = originsSheet;
    }

    public PackageInfoSheet getPackageInfoSheet() {
        return this.packageInfoSheet;
    }

    public void setPackageInfoSheet(PackageInfoSheetV09d2 packageInfoSheet) {
        this.packageInfoSheet = packageInfoSheet;
    }

    public NonStandardLicensesSheet getNonStandardLicensesSheet() {
        return this.nonStandardLicensesSheet;
    }

    public void setNonStandardLicensesSheet(NonStandardLicensesSheetV0d9d4 nonStandardLicensesSheet) {
        this.nonStandardLicensesSheet = nonStandardLicensesSheet;
    }

    public PerFileSheet getPerFileSheet() {
        return this.perFileSheet;
    }

    public void setPerFileSheet(PerFileSheetV09d3 perFileSheet) {
        this.perFileSheet = perFileSheet;
    }

    public ReviewersSheet getReviewersSheet() {
        return this.reviewersSheet;
    }

    public void setReviewersSheet(ReviewersSheet reviewersSheet) {
        this.reviewersSheet = reviewersSheet;
    }

    public RelationshipsSheet getRelationshipsSheet() {
        return this.relationshipsSheet;
    }

    public void setRelationshipsSheet(RelationshipsSheet relationshipsSheet) {
        this.relationshipsSheet = relationshipsSheet;
    }

    public AnnotationsSheet getAnnotationsSheet() {
        return this.annotationsSheet;
    }

    public void setAnnotationsSheet(AnnotationsSheet annotationsSheet) {
        this.annotationsSheet = annotationsSheet;
    }

    public void setPackageInfoSheet(PackageInfoSheet packageInfoSheet) {
        this.packageInfoSheet = packageInfoSheet;
    }

    public void setNonStandardLicensesSheet(NonStandardLicensesSheet nonStandardLicensesSheet) {
        this.nonStandardLicensesSheet = nonStandardLicensesSheet;
    }

    public void setPerFileSheet(PerFileSheet perFileSheet) {
        this.perFileSheet = perFileSheet;
    }

    public SnippetSheet getSnippetSheet() {
        return this.snippetSheet;
    }

    public void setSnippetSheet(SnippetSheet snippetSheet) {
        this.snippetSheet = snippetSheet;
    }

    public ExternalRefsSheet getExternalRefsSheet() {
        return this.externalRefsSheet;
    }

    public void setExternaRefsSheet(ExternalRefsSheet externalRefsSheet) {
        this.externalRefsSheet = externalRefsSheet;
    }

    public void resizeRow() {
        this.nonStandardLicensesSheet.resizeRows();
        this.packageInfoSheet.resizeRows();
        this.perFileSheet.resizeRows();
        this.relationshipsSheet.resizeRows();
        this.annotationsSheet.resizeRows();
        if (this.snippetSheet != null) {
            this.snippetSheet.resizeRows();
        }
        if (this.externalRefsSheet != null) {
            this.externalRefsSheet.resizeRows();
        }
    }
}

