/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import com.google.common.base.Joiner;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.compare.SpdxFileComparer;
import org.spdx.compare.SpdxItemDifference;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.Checksum;
import org.spdx.rdfparser.model.DoapProject;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxFile;

public class SpdxFileDifference
extends SpdxItemDifference {
    private DoapProject[] artifactsOfA;
    private DoapProject[] artifactsOfB;
    private boolean artifactOfsEquals;
    private DoapProject[] uniqueArtifactOfA;
    private DoapProject[] uniqueArtifactOfB;
    private SpdxFile.FileType[] fileTypeA;
    private SpdxFile.FileType[] fileTypeB;
    private String[] contributorsA;
    private String noticeA;
    private String[] contributorsB;
    private String noticeB;
    private String[] dependantFileNamesA;
    private String[] dependantFileNamesB;
    private boolean checksumsEquals;
    private Checksum[] uniqueChecksumsA;
    private Checksum[] uniqueChecksumsB;
    private String spdxIdA;
    private String spdxIdB;

    public SpdxFileDifference(SpdxFile fileA, SpdxFile fileB, boolean concludedLicensesEqual, boolean seenLicensesEqual, AnyLicenseInfo[] uniqueSeenLicensesA, AnyLicenseInfo[] uniqueSeenLicensesB, boolean artifactOfsEquals, DoapProject[] uniqueArtifactOfA2, DoapProject[] uniqueArtifactOfB2, boolean checksumsEquals, Checksum[] uniqueChecksumsA, Checksum[] uniqueChecksumsB, boolean relationshipsEquals, Relationship[] uniqueRelationshipA, Relationship[] uniqueRelationshipB, boolean annotationsEquals, Annotation[] uniqueAnnotationsA, Annotation[] uniqueAnnotationsB) throws InvalidSPDXAnalysisException, SpdxCompareException {
        super(fileA, fileB, concludedLicensesEqual, seenLicensesEqual, uniqueSeenLicensesA, uniqueSeenLicensesB, relationshipsEquals, uniqueRelationshipA, uniqueRelationshipB, annotationsEquals, uniqueAnnotationsA, uniqueAnnotationsB);
        this.artifactsOfA = fileA.getArtifactOf();
        if (this.artifactsOfA == null) {
            this.artifactsOfA = new DoapProject[0];
        }
        this.artifactsOfB = fileB.getArtifactOf();
        if (this.artifactsOfB == null) {
            this.artifactsOfB = new DoapProject[0];
        }
        this.artifactOfsEquals = artifactOfsEquals;
        this.uniqueArtifactOfA = uniqueArtifactOfA2;
        this.uniqueArtifactOfB = uniqueArtifactOfB2;
        this.fileTypeA = fileA.getFileTypes();
        this.fileTypeB = fileB.getFileTypes();
        this.contributorsA = fileA.getFileContributors();
        this.contributorsB = fileB.getFileContributors();
        this.noticeA = fileA.getNoticeText();
        this.noticeB = fileB.getNoticeText();
        this.dependantFileNamesA = SpdxFileComparer.filesToFileNames(fileA.getFileDependencies());
        this.dependantFileNamesB = SpdxFileComparer.filesToFileNames(fileB.getFileDependencies());
        this.checksumsEquals = checksumsEquals;
        this.uniqueChecksumsA = uniqueChecksumsA;
        this.uniqueChecksumsB = uniqueChecksumsB;
        this.spdxIdA = fileA.getId();
        this.spdxIdB = fileB.getId();
    }

    public String getFileName() {
        return this.getName();
    }

    public DoapProject[] getArtifactsOfA() {
        return this.artifactsOfA;
    }

    public DoapProject[] getArtifactsOfB() {
        return this.artifactsOfB;
    }

    public boolean isArtifactOfsEquals() {
        return this.artifactOfsEquals;
    }

    public DoapProject[] getUniqueArtifactOfA() {
        return this.uniqueArtifactOfA;
    }

    public DoapProject[] getUniqueArtifactOfB() {
        return this.uniqueArtifactOfB;
    }

    public SpdxFile.FileType[] getFileTypeA() {
        return this.fileTypeA;
    }

    public SpdxFile.FileType[] getFileTypeB() {
        return this.fileTypeB;
    }

    public boolean isContributorsEqual() {
        return SpdxComparer.stringArraysEqual(this.contributorsA, this.contributorsB);
    }

    public boolean isNoticeTextsEqual() {
        return SpdxComparer.stringsEqual(this.noticeA, this.noticeB);
    }

    public boolean isFileDependenciesEqual() {
        return SpdxComparer.stringArraysEqual(this.dependantFileNamesA, this.dependantFileNamesB);
    }

    public boolean isTypeEqual() {
        return SpdxComparer.arraysEqual((Object[])this.fileTypeA, (Object[])this.fileTypeB);
    }

    public boolean isChecksumsEquals() {
        return this.checksumsEquals;
    }

    public String getContributorsAAsString() {
        return SpdxFileDifference.stringArrayToString(this.contributorsA);
    }

    public String getContributorsBAsString() {
        return SpdxFileDifference.stringArrayToString(this.contributorsB);
    }

    static String stringArrayToString(String[] s) {
        StringBuilder sb = new StringBuilder();
        if (s != null && s.length > 0) {
            sb.append(Joiner.on((String)", ").skipNulls().join((Object[])s));
        }
        return sb.toString();
    }

    public String getFileDependenciesAAsString() {
        return SpdxFileDifference.stringArrayToString(this.dependantFileNamesA);
    }

    public String getFileDependenciesBAsString() {
        return SpdxFileDifference.stringArrayToString(this.dependantFileNamesB);
    }

    public String[] getContributorsA() {
        return this.contributorsA;
    }

    public String getNoticeA() {
        return this.noticeA;
    }

    public String[] getContributorsB() {
        return this.contributorsB;
    }

    public String getNoticeB() {
        return this.noticeB;
    }

    public String[] getDependantFileNamesA() {
        return this.dependantFileNamesA;
    }

    public String[] getDependantFileNamesB() {
        return this.dependantFileNamesB;
    }

    public Checksum[] getUniqueChecksumsA() {
        return this.uniqueChecksumsA;
    }

    public Checksum[] getUniqueChecksumsB() {
        return this.uniqueChecksumsB;
    }

    public String getSpdxIdA() {
        return this.spdxIdA;
    }

    public String getSpdxIdB() {
        return this.spdxIdB;
    }
}

