/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.merge;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.spdx.compare.LicenseCompareHelper;
import org.spdx.merge.SpdxLicenseMapper;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.ExtractedLicenseInfo;
import org.spdx.rdfparser.model.SpdxDocument;

public class SpdxLicenseInfoMerger {
    private SpdxDocument output = null;
    private SpdxLicenseMapper mapper = null;

    public SpdxLicenseInfoMerger(SpdxDocument outputDoc, SpdxLicenseMapper mapper) {
        this.output = outputDoc;
        this.mapper = mapper;
    }

    public ExtractedLicenseInfo[] mergeNonStdLic(SpdxDocument[] subDocs) throws InvalidSPDXAnalysisException {
        Object[] masterNonStdLicInfo = this.output.getExtractedLicenseInfos();
        ArrayList retval = Lists.newArrayList((Object[])masterNonStdLicInfo);
        for (int i = 0; i < subDocs.length; ++i) {
            ExtractedLicenseInfo[] subNonStdLicInfo = this.cloneNonStdLic(subDocs[i].getExtractedLicenseInfos());
            ExtractedLicenseInfo foundLicense = null;
            for (int k = 0; k < subNonStdLicInfo.length; ++k) {
                boolean foundTextMatch = false;
                for (int p = 0; p < retval.size(); ++p) {
                    if (!LicenseCompareHelper.isLicenseTextEquivalent(subNonStdLicInfo[k].getExtractedText(), ((ExtractedLicenseInfo)retval.get(p)).getExtractedText())) continue;
                    foundTextMatch = true;
                    foundLicense = (ExtractedLicenseInfo)retval.get(p);
                    break;
                }
                if (foundTextMatch) {
                    this.mapper.mappingExistingNonStdLic(this.output, foundLicense, subDocs[i], subNonStdLicInfo[k]);
                }
                if (foundTextMatch) continue;
                retval.add(this.mapper.mappingNewNonStdLic(this.output, subDocs[i], subNonStdLicInfo[k]));
            }
        }
        ExtractedLicenseInfo[] nonStdLicMergeResult = new ExtractedLicenseInfo[retval.size()];
        retval.toArray(nonStdLicMergeResult);
        retval.clear();
        return nonStdLicMergeResult;
    }

    public ExtractedLicenseInfo[] cloneNonStdLic(ExtractedLicenseInfo[] orgNonStdLicArray) {
        ExtractedLicenseInfo[] clonedNonStdLicArray = new ExtractedLicenseInfo[orgNonStdLicArray.length];
        for (int q = 0; q < orgNonStdLicArray.length; ++q) {
            clonedNonStdLicArray[q] = (ExtractedLicenseInfo)orgNonStdLicArray[q].clone();
        }
        return clonedNonStdLicArray;
    }
}

