/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import com.google.common.base.Objects;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.model.ExternalRef;
import org.spdx.rdfparser.referencetype.ReferenceType;

public class SpdxExternalRefDifference {
    String commentA;
    String commentB;
    ExternalRef.ReferenceCategory catA;
    ExternalRef.ReferenceCategory catB;
    private String referenceLocator;
    private ReferenceType referenceType;

    SpdxExternalRefDifference(ExternalRef externalRefA, ExternalRef externalRefB) throws InvalidSPDXAnalysisException {
        this.commentA = externalRefA.getComment();
        this.commentB = externalRefB.getComment();
        this.catA = externalRefA.getReferenceCategory();
        this.catB = externalRefB.getReferenceCategory();
        this.referenceLocator = externalRefA.getReferenceLocator();
        this.referenceType = externalRefA.getReferenceType();
    }

    public boolean isCommentsEqual() {
        return SpdxComparer.stringsEqual(this.commentA, this.commentB);
    }

    public boolean isReferenceCategoriesEqual() {
        return Objects.equal((Object)((Object)this.catA), (Object)((Object)this.catB));
    }

    public String getCommentA() {
        return this.commentA;
    }

    public String getCommentB() {
        return this.commentB;
    }

    public ExternalRef.ReferenceCategory getCatA() {
        return this.catA;
    }

    public ExternalRef.ReferenceCategory getCatB() {
        return this.catB;
    }

    public String getReferenceLocator() {
        return this.referenceLocator;
    }

    public ReferenceType getReferenceType() {
        return this.referenceType;
    }
}

