/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SPDXCreatorInformation;
import org.spdx.rdfparser.model.SpdxDocument;

public class CreatorInfoContext {
    private SpdxDocument doc;

    public CreatorInfoContext(SpdxDocument doc2) {
        this.doc = doc2;
    }

    public String created() {
        try {
            return this.doc.getCreationInfo().getCreated();
        }
        catch (InvalidSPDXAnalysisException e) {
            return "Error getting creator created date: " + e.getMessage();
        }
    }

    public String licenseListVersion() {
        String retval;
        try {
            retval = this.doc.getCreationInfo().getLicenseListVersion();
        }
        catch (InvalidSPDXAnalysisException e) {
            return "Error getting license list version: " + e.getMessage();
        }
        if (retval == null) {
            retval = "";
        }
        return retval;
    }

    public List<String> creator() {
        ArrayList creators = Lists.newArrayList();
        try {
            SPDXCreatorInformation creatorInfo = this.doc.getCreationInfo();
            if (creatorInfo != null) {
                String[] creatorArray = creatorInfo.getCreators();
                for (int i = 0; i < creatorArray.length; ++i) {
                    creators.add(creatorArray[i]);
                }
            }
        }
        catch (InvalidSPDXAnalysisException ex) {
            creators.add("Error getting creators: " + ex.getMessage());
        }
        return creators;
    }

    public String comment() {
        try {
            if (this.doc.getCreationInfo() != null) {
                return this.doc.getCreationInfo().getComment();
            }
            return null;
        }
        catch (InvalidSPDXAnalysisException e) {
            return "Error getting creator comment: " + e.getMessage();
        }
    }
}

