/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection.internal.builder;

import com.github.andrewoma.dexx.collection.Builder;
import com.github.andrewoma.dexx.collection.Function;
import com.github.andrewoma.dexx.collection.Traversable;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBuilder<E, R>
implements Builder<E, R> {
    private boolean built = false;

    @Override
    @NotNull
    public Builder<E, R> addAll(@NotNull Traversable<E> elements) {
        elements.forEach(new Function<E, Object>(){

            @Override
            public Object invoke(E element) {
                AbstractBuilder.this.add(element);
                return null;
            }
        });
        return this;
    }

    @Override
    @NotNull
    public Builder<E, R> addAll(@NotNull Iterable<E> elements) {
        for (E element : elements) {
            this.add(element);
        }
        return this;
    }

    @Override
    @NotNull
    public Builder<E, R> addAll(@NotNull Iterator<E> iterator) {
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        return this;
    }

    @Override
    @NotNull
    public Builder<E, R> addAll(E e1, E e2, E ... es) {
        this.add(e1);
        this.add(e2);
        for (E e3 : es) {
            this.add(e3);
        }
        return this;
    }

    @Override
    @NotNull
    public final R build() {
        if (this.built) {
            throw new IllegalStateException("Builders do not support multiple calls to build()");
        }
        this.built = true;
        return this.doBuild();
    }

    @NotNull
    public abstract R doBuild();
}

