/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.codes;

import com.github.mustachejava.Code;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.ObjectHandler;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.codes.PartialCode;
import com.github.mustachejava.reflect.MissingWrapper;
import com.github.mustachejava.util.GuardException;
import com.github.mustachejava.util.Wrapper;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;

public class DefaultCode
implements Code {
    protected String appended;
    protected final ObjectHandler oh;
    protected final String name;
    protected final TemplateContext tc;
    protected final Mustache mustache;
    protected final String type;
    protected final boolean returnThis;
    protected static boolean debug = Boolean.getBoolean("mustache.debug");
    protected static Logger logger = Logger.getLogger("mustache");
    private Set<Wrapper> previousSet = new CopyOnWriteArraySet<Wrapper>();
    private volatile Wrapper[] prevWrappers;
    private ThreadLocal<Object[]> localScopes = new ThreadLocal();

    public DefaultCode() {
        this(null, null, null, null, null);
    }

    public DefaultCode(TemplateContext tc, ObjectHandler oh, Mustache mustache, String name, String type) {
        this.oh = oh;
        this.mustache = mustache;
        this.type = type;
        this.name = name;
        this.tc = tc;
        this.returnThis = ".".equals(name);
    }

    @Override
    public Code[] getCodes() {
        return this.mustache == null ? null : this.mustache.getCodes();
    }

    @Override
    public synchronized void init() {
        Code[] codes = this.getCodes();
        if (codes != null) {
            for (Code code : codes) {
                code.init();
            }
        }
    }

    @Override
    public void setCodes(Code[] newcodes) {
        this.mustache.setCodes(newcodes);
    }

    public Object get(Object[] scopes) {
        if (this.returnThis) {
            return scopes[scopes.length - 1];
        }
        Wrapper current = null;
        Wrapper[] wrappers = this.prevWrappers;
        if (wrappers != null) {
            for (Wrapper prevWrapper : wrappers) {
                try {
                    current = prevWrapper;
                    return this.oh.coerce(prevWrapper.call(scopes));
                }
                catch (GuardException ge) {
                }
                catch (MustacheException me) {
                    throw new MustacheException("Failed: " + current, me);
                }
            }
        }
        return this.createAndGet(scopes);
    }

    private Object createAndGet(Object[] scopes) {
        Wrapper wrapper = this.getWrapper(this.name, scopes);
        this.previousSet.add(wrapper);
        if (this.prevWrappers == null || this.prevWrappers.length != this.previousSet.size()) {
            this.prevWrappers = this.previousSet.toArray(new Wrapper[this.previousSet.size()]);
        }
        try {
            return this.oh.coerce(wrapper.call(scopes));
        }
        catch (GuardException e2) {
            throw new AssertionError((Object)("Unexpected guard failure: " + this.previousSet + " " + Arrays.asList(scopes)));
        }
    }

    protected synchronized Wrapper getWrapper(String name, Object[] scopes) {
        Wrapper wrapper = this.oh.find(name, scopes);
        if (wrapper instanceof MissingWrapper && debug && !(this instanceof PartialCode)) {
            StringBuilder sb = new StringBuilder("Failed to find: ");
            sb.append(name).append(" (").append(this.tc.file()).append(":").append(this.tc.line()).append(") ").append("in");
            for (Object scope : scopes) {
                if (scope == null) continue;
                sb.append(" ").append(scope.getClass().getSimpleName());
            }
            logger.warning(sb.toString());
        }
        return wrapper;
    }

    @Override
    public Writer execute(Writer writer, Object scope) {
        return this.execute(writer, new Object[]{scope});
    }

    @Override
    public Writer execute(Writer writer, Object[] scopes) {
        return this.appendText(this.runCodes(writer, scopes));
    }

    @Override
    public void identity(Writer writer) {
        try {
            if (this.name != null) {
                this.tag(writer, this.type);
                if (this.getCodes() != null) {
                    this.runIdentity(writer);
                    this.tag(writer, "/");
                }
            }
            this.appendText(writer);
        }
        catch (IOException e2) {
            throw new MustacheException(e2);
        }
    }

    protected void runIdentity(Writer writer) {
        int length = this.getCodes().length;
        for (int i = 0; i < length; ++i) {
            this.getCodes()[i].identity(writer);
        }
    }

    private void tag(Writer writer, String tag) throws IOException {
        writer.write(this.tc.startChars());
        writer.write(tag);
        writer.write(this.name);
        writer.write(this.tc.endChars());
    }

    protected Writer appendText(Writer writer) {
        if (this.appended != null) {
            try {
                writer.write(this.appended);
            }
            catch (IOException e2) {
                throw new MustacheException(e2);
            }
        }
        return writer;
    }

    protected Writer runCodes(Writer writer, Object[] scopes) {
        Code[] codes = this.getCodes();
        if (codes != null) {
            for (Code code : codes) {
                writer = code.execute(writer, scopes);
            }
        }
        return writer;
    }

    @Override
    public void append(String text) {
        this.appended = this.appended == null ? text : this.appended + text;
    }

    protected Object[] addScope(Object next, Object[] scopes) {
        Object[] iteratorScopes = scopes;
        if (next != null) {
            int srcPos;
            iteratorScopes = this.localScopes.get();
            if (iteratorScopes == null) {
                iteratorScopes = new Object[scopes.length + 1];
                this.localScopes.set(iteratorScopes);
            } else if (iteratorScopes.length < scopes.length + 1) {
                iteratorScopes = new Object[scopes.length + 1];
                this.localScopes.set(iteratorScopes);
            }
            System.arraycopy(scopes, 0, iteratorScopes, srcPos, scopes.length);
            for (srcPos = iteratorScopes.length - scopes.length - 1; srcPos > 0; --srcPos) {
                iteratorScopes[srcPos - 1] = null;
            }
            iteratorScopes[iteratorScopes.length - 1] = next;
        }
        return iteratorScopes;
    }
}

