/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Err;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceConstant;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.query.Declaration;
import net.sf.saxon.query.GlobalVariableDefinition;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.UndeclaredVariable;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.SequenceType;

public class QueryReader {
    private QueryReader() {
    }

    public static String readSourceQuery(StreamSource streamSource, NameChecker nameChecker) throws StaticError {
        String string;
        if (streamSource.getInputStream() != null) {
            InputStream inputStream = streamSource.getInputStream();
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            String string2 = QueryReader.readEncoding(inputStream);
            string = QueryReader.readInputStream(inputStream, string2, nameChecker);
        } else if (streamSource.getReader() != null) {
            string = QueryReader.readQueryFromReader(streamSource.getReader(), nameChecker);
        } else {
            throw new StaticError("Module URI Resolver must supply either an InputSource or a Reader");
        }
        return string.toString();
    }

    public static String readEncoding(InputStream inputStream) throws StaticError {
        try {
            if (!inputStream.markSupported()) {
                throw new IllegalArgumentException("InputStream must have markSupported() = true");
            }
            inputStream.mark(100);
            byte[] byArray = new byte[100];
            int n = inputStream.read(byArray, 0, 100);
            if (n == -1) {
                StaticError staticError = new StaticError("Query source file is empty");
                throw staticError;
            }
            inputStream.reset();
            return QueryReader.inferEncoding(byArray, n);
        }
        catch (IOException iOException) {
            StaticError staticError = new StaticError("Failed to read query source file", iOException);
            throw staticError;
        }
    }

    public static String readInputStream(InputStream inputStream, String string, NameChecker nameChecker) throws StaticError {
        if (string == null) {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            string = QueryReader.readEncoding(inputStream);
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
            return QueryReader.readQueryFromReader(bufferedReader, nameChecker);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            StaticError staticError = new StaticError("Unknown encoding " + Err.wrap(string), unsupportedEncodingException);
            throw staticError;
        }
    }

    private static String readQueryFromReader(Reader reader, NameChecker nameChecker) throws StaticError {
        try {
            int n;
            FastStringBuffer fastStringBuffer = new FastStringBuffer(2048);
            char[] cArray = new char[2048];
            boolean bl = true;
            int n2 = 1;
            int n3 = 1;
            while ((n = reader.read(cArray, 0, 2048)) >= 0) {
                int n4 = 0;
                while (n4 < n) {
                    int n5;
                    if ((n5 = cArray[n4++]) == 10) {
                        ++n2;
                        n3 = 0;
                    }
                    ++n3;
                    if (XMLChar.isHighSurrogate(n5)) {
                        char c = cArray[n4++];
                        n5 = XMLChar.supplemental((char)n5, c);
                    }
                    if (nameChecker.isValidChar(n5)) continue;
                    StaticError staticError = new StaticError("The query file contains a character illegal in XML " + nameChecker.getXMLVersion() + " (line=" + n2 + " column=" + n3 + " value=x" + Integer.toHexString(n5) + ')');
                    staticError.setErrorCode("XPST0003");
                    throw staticError;
                }
                if (bl) {
                    bl = false;
                    if (cArray[0] == '\ufeff') {
                        fastStringBuffer.append(cArray, 1, n - 1);
                        continue;
                    }
                    fastStringBuffer.append(cArray, 0, n);
                    continue;
                }
                fastStringBuffer.append(cArray, 0, n);
            }
            return ((Object)fastStringBuffer.condense()).toString();
        }
        catch (IOException iOException) {
            StaticError staticError = new StaticError("Failed to read input file", iOException);
            throw staticError;
        }
    }

    private static String inferEncoding(byte[] byArray, int n) throws StaticError {
        if (n >= 2) {
            if (QueryReader.ch(byArray[0]) == 254 && QueryReader.ch(byArray[1]) == 255) {
                return "UTF-16";
            }
            if (QueryReader.ch(byArray[0]) == 255 && QueryReader.ch(byArray[1]) == 254) {
                return "UTF-16LE";
            }
        }
        if (n >= 3 && QueryReader.ch(byArray[0]) == 239 && QueryReader.ch(byArray[1]) == 187 && QueryReader.ch(byArray[2]) == 191) {
            return "UTF-8";
        }
        if (n >= 8 && byArray[0] == 0 && byArray[2] == 0 && byArray[4] == 0 && byArray[6] == 0) {
            return "UTF-16";
        }
        if (n >= 8 && byArray[1] == 0 && byArray[3] == 0 && byArray[5] == 0 && byArray[7] == 0) {
            return "UTF-16LE";
        }
        int n2 = 0;
        String string = QueryReader.readToken(byArray, n2, n);
        if (string.trim().equals("xquery")) {
            n2 += string.length();
        } else {
            return "UTF-8";
        }
        string = QueryReader.readToken(byArray, n2, n);
        if (string.trim().equals("version")) {
            n2 += string.length();
        } else {
            return "UTF-8";
        }
        string = QueryReader.readToken(byArray, n2, n);
        if (string == null) {
            return "UTF-8";
        }
        if ((string = QueryReader.readToken(byArray, n2 += string.length(), n)).trim().equals("encoding")) {
            n2 += string.length();
        } else {
            return "UTF-8";
        }
        string = QueryReader.readToken(byArray, n2, n).trim();
        if (string.startsWith("\"") && string.endsWith("\"") && string.length() > 2) {
            return string.substring(1, string.length() - 1);
        }
        if (string.startsWith("'") && string.endsWith("'") && string.length() > 2) {
            return string.substring(1, string.length() - 1);
        }
        throw new StaticError("Unrecognized encoding " + Err.wrap(string) + " in query prolog");
    }

    private static String readToken(byte[] byArray, int n, int n2) {
        int n3;
        for (n3 = n; n3 < n2 && " \n\r\t".indexOf(QueryReader.ch(byArray[n3])) >= 0; ++n3) {
        }
        if (QueryReader.ch(byArray[n3]) == 34) {
            ++n3;
            while (n3 < n2 && QueryReader.ch(byArray[n3]) != 34) {
                ++n3;
            }
        } else if (QueryReader.ch(byArray[n3]) == 39) {
            ++n3;
            while (n3 < n2 && QueryReader.ch(byArray[n3]) != 39) {
                ++n3;
            }
        } else {
            while (n3 < n2 && " \n\r\t".indexOf(QueryReader.ch(byArray[n3])) < 0) {
                ++n3;
            }
        }
        if (n3 >= n2) {
            return new String(byArray, n, n2 - n);
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(n3 - n + 1);
        for (int i = n; i <= n3; ++i) {
            fastStringBuffer.append((char)QueryReader.ch(byArray[i]));
        }
        return fastStringBuffer.toString();
    }

    private static int ch(byte by) {
        return by & 0xFF;
    }

    public static void importModuleContents(StaticQueryContext staticQueryContext, StaticQueryContext staticQueryContext2) throws StaticError {
        Declaration declaration;
        short s2 = staticQueryContext.getModuleNamespaceCode();
        NamePool namePool = staticQueryContext2.getNamePool();
        Iterator iterator = staticQueryContext.getLocalFunctionLibrary().getFunctionDefinitions();
        while (iterator.hasNext()) {
            declaration = (XQueryFunction)iterator.next();
            if (namePool.getURICode(((XQueryFunction)declaration).getFunctionFingerprint()) != s2 || ((XQueryFunction)declaration).getSystemId() != staticQueryContext.getLocationURI()) continue;
            QueryReader.checkImportedType(staticQueryContext2, ((XQueryFunction)declaration).getResultType(), declaration);
            for (int i = 0; i < ((XQueryFunction)declaration).getNumberOfArguments(); ++i) {
                SequenceType sequenceType = ((XQueryFunction)declaration).getArgumentTypes()[i];
                QueryReader.checkImportedType(staticQueryContext2, sequenceType, declaration);
            }
        }
        iterator = staticQueryContext.getModuleVariables();
        while (iterator.hasNext()) {
            declaration = (GlobalVariableDefinition)iterator.next();
            if (declaration instanceof UndeclaredVariable || namePool.getURICode(((GlobalVariableDefinition)declaration).getNameCode()) != s2 || ((GlobalVariableDefinition)declaration).getSystemId().equals(staticQueryContext2.getLocationURI())) continue;
            QueryReader.checkImportedType(staticQueryContext2, ((GlobalVariableDefinition)declaration).getRequiredType(), declaration);
        }
    }

    private static void checkImportedType(StaticQueryContext staticQueryContext, SequenceType sequenceType, Declaration declaration) throws StaticError {
        ItemType itemType = sequenceType.getPrimaryType();
        if (itemType instanceof AnyItemType) {
            return;
        }
        if (itemType instanceof AtomicType) {
            int n = ((AtomicType)itemType).getFingerprint();
            QueryReader.checkSchemaNamespaceImported(staticQueryContext, n, declaration);
        } else if (itemType instanceof ContentTypeTest) {
            SchemaType schemaType = ((ContentTypeTest)itemType).getSchemaType();
            int n = schemaType.getFingerprint();
            QueryReader.checkSchemaNamespaceImported(staticQueryContext, n, declaration);
        } else if (itemType instanceof CombinedNodeTest) {
            NodeTest[] nodeTestArray = ((CombinedNodeTest)itemType).getComponentNodeTests();
            for (int i = 0; i < nodeTestArray.length; ++i) {
                SequenceType sequenceType2 = SequenceType.makeSequenceType(nodeTestArray[1], 16384);
                QueryReader.checkImportedType(staticQueryContext, sequenceType2, declaration);
            }
        }
    }

    static void checkSchemaNamespaceImported(StaticQueryContext staticQueryContext, int n, Declaration declaration) throws StaticError {
        String string = staticQueryContext.getNamePool().getURI(n);
        if (string.equals("http://www.w3.org/2001/XMLSchema")) {
            return;
        }
        if (NamespaceConstant.isXDTNamespace(string)) {
            return;
        }
        if (staticQueryContext.isImportedSchema(string)) {
            return;
        }
        String string2 = "Schema component " + staticQueryContext.getNamePool().getDisplayName(n) + " used in ";
        string2 = declaration instanceof GlobalVariableDefinition ? string2 + "declaration of imported variable " + staticQueryContext.getNamePool().getDisplayName(((GlobalVariableDefinition)declaration).getNameCode()) : string2 + "signature of imported function " + staticQueryContext.getNamePool().getDisplayName(((XQueryFunction)declaration).getNameCode());
        string2 = string2 + " is not declared in any schema imported by ";
        String string3 = staticQueryContext.getModuleNamespace();
        string2 = string3 == null ? string2 + "the main query module" : string2 + "query module " + string3;
        StaticError staticError = new StaticError(string2);
        staticError.setErrorCode("XQST0036");
        staticError.setLocator(declaration);
        throw staticError;
    }
}

