/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.math.BigDecimal;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.style.AbsentExtensionElement;
import net.sf.saxon.style.DataElement;
import net.sf.saxon.style.ExtensionElementFactory;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.SaxonAssign;
import net.sf.saxon.style.SaxonCallTemplate;
import net.sf.saxon.style.SaxonCollation;
import net.sf.saxon.style.SaxonDoctype;
import net.sf.saxon.style.SaxonEntityRef;
import net.sf.saxon.style.SaxonImportQuery;
import net.sf.saxon.style.SaxonScript;
import net.sf.saxon.style.SaxonWhile;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLAnalyzeString;
import net.sf.saxon.style.XSLApplyImports;
import net.sf.saxon.style.XSLApplyTemplates;
import net.sf.saxon.style.XSLAttribute;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLCallTemplate;
import net.sf.saxon.style.XSLCharacterMap;
import net.sf.saxon.style.XSLChoose;
import net.sf.saxon.style.XSLComment;
import net.sf.saxon.style.XSLCopy;
import net.sf.saxon.style.XSLCopyOf;
import net.sf.saxon.style.XSLDecimalFormat;
import net.sf.saxon.style.XSLDocument;
import net.sf.saxon.style.XSLElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLForEach;
import net.sf.saxon.style.XSLForEachGroup;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLIf;
import net.sf.saxon.style.XSLImport;
import net.sf.saxon.style.XSLImportSchema;
import net.sf.saxon.style.XSLInclude;
import net.sf.saxon.style.XSLKey;
import net.sf.saxon.style.XSLMatchingSubstring;
import net.sf.saxon.style.XSLMessage;
import net.sf.saxon.style.XSLNamespace;
import net.sf.saxon.style.XSLNamespaceAlias;
import net.sf.saxon.style.XSLNextMatch;
import net.sf.saxon.style.XSLNumber;
import net.sf.saxon.style.XSLOtherwise;
import net.sf.saxon.style.XSLOutput;
import net.sf.saxon.style.XSLOutputCharacter;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.style.XSLPerformSort;
import net.sf.saxon.style.XSLPreserveSpace;
import net.sf.saxon.style.XSLProcessingInstruction;
import net.sf.saxon.style.XSLResultDocument;
import net.sf.saxon.style.XSLSequence;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.style.XSLText;
import net.sf.saxon.style.XSLValueOf;
import net.sf.saxon.style.XSLVariable;
import net.sf.saxon.style.XSLWhen;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.ElementImpl;
import net.sf.saxon.tree.NodeFactory;

public class StyleNodeFactory
implements NodeFactory {
    IntHashMap userStyles = new IntHashMap(4);
    Configuration config;
    NamePool namePool;
    boolean allowExtensions;
    static /* synthetic */ Class class$net$sf$saxon$style$LiteralResultElement;
    static /* synthetic */ Class class$net$sf$saxon$style$AbsentExtensionElement;

    public StyleNodeFactory(Configuration configuration) {
        this.config = configuration;
        this.namePool = configuration.getNamePool();
        this.allowExtensions = configuration.isAllowExternalFunctions();
    }

    public ElementImpl makeElementNode(NodeInfo nodeInfo, int n, AttributeCollectionImpl attributeCollectionImpl, int[] nArray, int n2, LocationProvider locationProvider, int n3, int n4) {
        Object object;
        Class clazz;
        boolean bl = nodeInfo instanceof XSLStylesheet;
        String string = null;
        int n5 = -1;
        if (locationProvider != null) {
            string = locationProvider.getSystemId(n3);
            n5 = locationProvider.getLineNumber(n3);
        }
        if (nodeInfo instanceof DataElement) {
            DataElement dataElement = new DataElement();
            dataElement.setNamespaceDeclarations(nArray, n2);
            dataElement.initialise(n, attributeCollectionImpl, nodeInfo, string, n5, n4);
            return dataElement;
        }
        int n6 = n & 0xFFFFF;
        StyleElement styleElement = this.makeXSLElement(n6);
        if (styleElement != null) {
            try {
                styleElement.setNamespaceDeclarations(nArray, n2);
                styleElement.setLineNumber(n5);
                styleElement.initialise(n, attributeCollectionImpl, nodeInfo, string, -1, n4);
                styleElement.processDefaultCollationAttribute("default-collation");
                styleElement.processExtensionElementAttribute("extension-element-prefixes");
                styleElement.processExcludedNamespaces("exclude-result-prefixes");
                styleElement.processVersionAttribute("version");
                styleElement.processDefaultXPathNamespaceAttribute("xpath-default-namespace");
            }
            catch (TransformerException transformerException) {
                styleElement.setValidationError(transformerException, 1);
            }
            return styleElement;
        }
        short s2 = this.namePool.getURICode(n);
        String string2 = this.namePool.getLocalName(n);
        StyleElement styleElement2 = null;
        if (s2 == 2 && nodeInfo instanceof XSLStylesheet && ((XSLStylesheet)nodeInfo).getVersion().compareTo(BigDecimal.valueOf(50L)) <= 0) {
            styleElement2 = new AbsentExtensionElement();
            styleElement2.setValidationError(new StaticError("Unknown top-level XSLT declaration"), 2);
        }
        Class clazz2 = class$net$sf$saxon$style$LiteralResultElement == null ? (class$net$sf$saxon$style$LiteralResultElement = StyleNodeFactory.class$("net.sf.saxon.style.LiteralResultElement")) : class$net$sf$saxon$style$LiteralResultElement;
        boolean bl2 = false;
        if (styleElement2 == null) {
            if (s2 == 3) {
                styleElement2 = this.makeSaxonElement(n6);
                if (styleElement2 != null) {
                    clazz2 = styleElement2.getClass();
                    bl2 = true;
                }
            } else if (bl && s2 != 0) {
                DataElement dataElement = new DataElement();
                dataElement.setNamespaceDeclarations(nArray, n2);
                dataElement.initialise(n, attributeCollectionImpl, nodeInfo, string, n5, n4);
                return dataElement;
            }
        }
        if (styleElement2 == null) {
            styleElement2 = new LiteralResultElement();
        }
        styleElement2.setNamespaceDeclarations(nArray, n2);
        try {
            styleElement2.initialise(n, attributeCollectionImpl, nodeInfo, string, n5, n4);
            styleElement2.setLineNumber(n5);
            styleElement2.processDefaultCollationAttribute("{http://www.w3.org/1999/XSL/Transform}default-collation");
            styleElement2.processExtensionElementAttribute("{http://www.w3.org/1999/XSL/Transform}extension-element-prefixes");
            styleElement2.processExcludedNamespaces("{http://www.w3.org/1999/XSL/Transform}exclude-result-prefixes");
            styleElement2.processVersionAttribute("{http://www.w3.org/1999/XSL/Transform}version");
            styleElement2.processDefaultXPathNamespaceAttribute("{http://www.w3.org/1999/XSL/Transform}xpath-default-namespace");
        }
        catch (XPathException xPathException) {
            styleElement2.setValidationError(xPathException, 1);
        }
        if (s2 == 2) {
            StaticError staticError = new StaticError("Unknown XSLT element: " + string2);
            staticError.setErrorCode("XTSE0010");
            clazz = class$net$sf$saxon$style$AbsentExtensionElement == null ? (class$net$sf$saxon$style$AbsentExtensionElement = StyleNodeFactory.class$("net.sf.saxon.style.AbsentExtensionElement")) : class$net$sf$saxon$style$AbsentExtensionElement;
            styleElement2.setValidationError(staticError, 4);
        } else if (s2 == 3) {
            if (bl || styleElement2.isExtensionNamespace(s2)) {
                if (bl2) {
                    clazz = clazz2;
                } else {
                    clazz = class$net$sf$saxon$style$AbsentExtensionElement == null ? (class$net$sf$saxon$style$AbsentExtensionElement = StyleNodeFactory.class$("net.sf.saxon.style.AbsentExtensionElement")) : class$net$sf$saxon$style$AbsentExtensionElement;
                    StaticError staticError = new StaticError("Unknown Saxon extension element: " + string2);
                    styleElement2.setValidationError(staticError, 4);
                }
            } else {
                clazz = class$net$sf$saxon$style$LiteralResultElement == null ? (class$net$sf$saxon$style$LiteralResultElement = StyleNodeFactory.class$("net.sf.saxon.style.LiteralResultElement")) : class$net$sf$saxon$style$LiteralResultElement;
            }
        } else if (styleElement2.isExtensionNamespace(s2) && !bl) {
            clazz = (Class)this.userStyles.get(n & 0xFFFFF);
            if (clazz == null) {
                Object object2;
                if (this.allowExtensions) {
                    object = this.getFactory(s2);
                    if (object != null && (clazz = object.getExtensionClass(string2)) != null) {
                        this.userStyles.put(n & 0xFFFFF, clazz);
                    }
                } else {
                    clazz = class$net$sf$saxon$style$AbsentExtensionElement == null ? (class$net$sf$saxon$style$AbsentExtensionElement = StyleNodeFactory.class$("net.sf.saxon.style.AbsentExtensionElement")) : class$net$sf$saxon$style$AbsentExtensionElement;
                    object2 = new StaticError("Extension elements are disabled");
                    styleElement2.setValidationError((TransformerException)object2, 3);
                }
                if (clazz == null) {
                    clazz = class$net$sf$saxon$style$AbsentExtensionElement == null ? (class$net$sf$saxon$style$AbsentExtensionElement = StyleNodeFactory.class$("net.sf.saxon.style.AbsentExtensionElement")) : class$net$sf$saxon$style$AbsentExtensionElement;
                    object = new StaticError("Unknown extension element", styleElement2);
                    ((XPathException)object).setErrorCode("XTDE1450");
                    object2 = object;
                    styleElement2.setValidationError((TransformerException)object2, 3);
                }
            }
        } else {
            Class clazz3 = clazz = class$net$sf$saxon$style$LiteralResultElement == null ? (class$net$sf$saxon$style$LiteralResultElement = StyleNodeFactory.class$("net.sf.saxon.style.LiteralResultElement")) : class$net$sf$saxon$style$LiteralResultElement;
        }
        if (clazz.equals(clazz2)) {
            object = styleElement2;
        } else {
            try {
                object = (StyleElement)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new TransformerFactoryConfigurationError(instantiationException, "Failed to create instance of " + clazz.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new TransformerFactoryConfigurationError(illegalAccessException, "Failed to access class " + clazz.getName());
            }
            ((StyleElement)object).substituteFor(styleElement2);
        }
        return object;
    }

    private StyleElement makeXSLElement(int n) {
        switch (n) {
            case 128: {
                return new XSLAnalyzeString();
            }
            case 129: {
                return new XSLApplyImports();
            }
            case 130: {
                return new XSLApplyTemplates();
            }
            case 131: {
                return new XSLAttribute();
            }
            case 132: {
                return new XSLAttributeSet();
            }
            case 133: {
                return new XSLCallTemplate();
            }
            case 134: {
                return new XSLCharacterMap();
            }
            case 135: {
                return new XSLChoose();
            }
            case 138: {
                return new XSLComment();
            }
            case 139: {
                return new XSLCopy();
            }
            case 140: {
                return new XSLCopyOf();
            }
            case 141: {
                return new XSLDecimalFormat();
            }
            case 142: {
                return new XSLDocument();
            }
            case 143: {
                return new XSLElement();
            }
            case 144: {
                return new XSLFallback();
            }
            case 145: {
                return new XSLForEach();
            }
            case 148: {
                return new XSLForEachGroup();
            }
            case 149: {
                return new XSLFunction();
            }
            case 150: {
                return new XSLIf();
            }
            case 151: {
                return new XSLImport();
            }
            case 152: {
                return new XSLImportSchema();
            }
            case 153: {
                return new XSLInclude();
            }
            case 154: {
                return new XSLKey();
            }
            case 155: {
                return new XSLMatchingSubstring();
            }
            case 158: {
                return new XSLMessage();
            }
            case 159: {
                return new XSLNextMatch();
            }
            case 163: {
                return new XSLMatchingSubstring();
            }
            case 160: {
                return new XSLNumber();
            }
            case 161: {
                return new XSLNamespace();
            }
            case 162: {
                return new XSLNamespaceAlias();
            }
            case 164: {
                return new XSLOtherwise();
            }
            case 165: {
                return new XSLOutput();
            }
            case 169: {
                return new XSLOutputCharacter();
            }
            case 170: {
                return new XSLParam();
            }
            case 171: {
                return new XSLPerformSort();
            }
            case 172: {
                return new XSLPreserveSpace();
            }
            case 173: {
                return new XSLProcessingInstruction();
            }
            case 174: {
                return new XSLResultDocument();
            }
            case 175: {
                return new XSLSequence();
            }
            case 178: {
                return new XSLSort();
            }
            case 179: {
                return new XSLPreserveSpace();
            }
            case 180: {
                return new XSLStylesheet();
            }
            case 181: {
                return new XSLTemplate();
            }
            case 182: {
                return new XSLText();
            }
            case 183: {
                return new XSLStylesheet();
            }
            case 184: {
                return new XSLValueOf();
            }
            case 185: {
                return new XSLVariable();
            }
            case 188: {
                return new XSLWithParam();
            }
            case 189: {
                return new XSLWhen();
            }
        }
        return null;
    }

    private StyleElement makeSaxonElement(int n) {
        switch (n) {
            case 257: {
                return new SaxonAssign();
            }
            case 261: {
                return new SaxonEntityRef();
            }
            case 258: {
                return new SaxonCallTemplate();
            }
            case 259: {
                return new SaxonCollation();
            }
            case 260: {
                return new SaxonDoctype();
            }
            case 262: {
                return new SaxonImportQuery();
            }
            case 263: {
                return new SaxonScript();
            }
            case 265: {
                return new SaxonWhile();
            }
        }
        return null;
    }

    private ExtensionElementFactory getFactory(short s2) {
        ExtensionElementFactory extensionElementFactory;
        String string = this.namePool.getURIFromNamespaceCode(s2);
        int n = string.lastIndexOf(47);
        if (n < 0 || n == string.length() - 1) {
            return null;
        }
        String string2 = string.substring(n + 1);
        try {
            extensionElementFactory = (ExtensionElementFactory)this.config.getInstance(string2, null);
        }
        catch (XPathException xPathException) {
            return null;
        }
        return extensionElementFactory;
    }

    public boolean isElementAvailable(String string, String string2) {
        StyleElement styleElement;
        int n = this.namePool.getFingerprint(string, string2);
        if (string.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (n == -1) {
                return false;
            }
            styleElement = this.makeXSLElement(n);
            if (styleElement != null) {
                return styleElement.isInstruction();
            }
        }
        if (string.equals("http://saxon.sf.net/")) {
            if (n == -1) {
                return false;
            }
            styleElement = this.makeSaxonElement(n);
            if (styleElement != null) {
                return styleElement.isInstruction();
            }
        }
        if (!this.allowExtensions) {
            return false;
        }
        short s2 = this.namePool.getCodeForURI(string);
        ExtensionElementFactory extensionElementFactory = this.getFactory(s2);
        if (extensionElementFactory == null) {
            return false;
        }
        Class clazz = extensionElementFactory.getExtensionClass(string2);
        return clazz != null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

