/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.misc;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.antlr.misc.IntSet;
import org.antlr.misc.Interval;
import org.antlr.misc.IntervalSet;
import org.antlr.tool.Grammar;

public class BitSet
implements IntSet,
Cloneable {
    protected static final int BITS = 64;
    protected static final int LOG_BITS = 6;
    protected static final int MOD_MASK = 63;
    protected long[] bits;

    public BitSet() {
        this(64);
    }

    public BitSet(long[] bits_) {
        this.bits = bits_;
    }

    public BitSet(int nbits) {
        this.bits = new long[(nbits - 1 >> 6) + 1];
    }

    public void add(int el) {
        int n = BitSet.wordNumber(el);
        if (n >= this.bits.length) {
            this.growToInclude(el);
        }
        int n2 = n;
        this.bits[n2] = this.bits[n2] | BitSet.bitMask(el);
    }

    public void addAll(IntSet set) {
        if (set instanceof BitSet) {
            this.orInPlace((BitSet)set);
        } else if (set instanceof IntervalSet) {
            IntervalSet other = (IntervalSet)set;
            Iterator<Interval> iter = other.intervals.iterator();
            while (iter.hasNext()) {
                Interval I = iter.next();
                this.orInPlace(BitSet.range(I.a, I.b));
            }
        } else {
            throw new IllegalArgumentException("can't add " + set.getClass().getName() + " to BitSet");
        }
    }

    public void addAll(int[] elements) {
        if (elements == null) {
            return;
        }
        for (int i = 0; i < elements.length; ++i) {
            int e2 = elements[i];
            this.add(e2);
        }
    }

    public void addAll(Iterable elements) {
        if (elements == null) {
            return;
        }
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof Integer)) {
                throw new IllegalArgumentException();
            }
            Integer eI = (Integer)o;
            this.add(eI);
        }
    }

    public IntSet and(IntSet a) {
        BitSet s2 = (BitSet)this.clone();
        s2.andInPlace((BitSet)a);
        return s2;
    }

    public void andInPlace(BitSet a) {
        int i;
        int min2 = Math.min(this.bits.length, a.bits.length);
        for (i = min2 - 1; i >= 0; --i) {
            int n = i;
            this.bits[n] = this.bits[n] & a.bits[i];
        }
        for (i = min2; i < this.bits.length; ++i) {
            this.bits[i] = 0L;
        }
    }

    private static final long bitMask(int bitNumber) {
        int bitPosition = bitNumber & 0x3F;
        return 1L << bitPosition;
    }

    public void clear() {
        for (int i = this.bits.length - 1; i >= 0; --i) {
            this.bits[i] = 0L;
        }
    }

    public void clear(int el) {
        int n = BitSet.wordNumber(el);
        if (n >= this.bits.length) {
            this.growToInclude(el);
        }
        int n2 = n;
        this.bits[n2] = this.bits[n2] & (BitSet.bitMask(el) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public Object clone() {
        BitSet s2;
        try {
            s2 = (BitSet)super.clone();
            s2.bits = new long[this.bits.length];
            System.arraycopy(this.bits, 0, s2.bits, 0, this.bits.length);
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
        return s2;
    }

    public int size() {
        int deg = 0;
        for (int i = this.bits.length - 1; i >= 0; --i) {
            long word = this.bits[i];
            if (word == 0L) continue;
            for (int bit = 63; bit >= 0; --bit) {
                if ((word & 1L << bit) == 0L) continue;
                ++deg;
            }
        }
        return deg;
    }

    public boolean equals(Object other) {
        block5: {
            int i;
            int n;
            BitSet otherSet;
            block4: {
                if (other == null || !(other instanceof BitSet)) {
                    return false;
                }
                otherSet = (BitSet)other;
                n = Math.min(this.bits.length, otherSet.bits.length);
                for (i = 0; i < n; ++i) {
                    if (this.bits[i] == otherSet.bits[i]) continue;
                    return false;
                }
                if (this.bits.length <= n) break block4;
                for (i = n + 1; i < this.bits.length; ++i) {
                    if (this.bits[i] == 0L) continue;
                    return false;
                }
                break block5;
            }
            if (otherSet.bits.length <= n) break block5;
            for (i = n + 1; i < otherSet.bits.length; ++i) {
                if (otherSet.bits[i] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public void growToInclude(int bit) {
        int newSize = Math.max(this.bits.length << 1, this.numWordsToHold(bit));
        long[] newbits = new long[newSize];
        System.arraycopy(this.bits, 0, newbits, 0, this.bits.length);
        this.bits = newbits;
    }

    public boolean member(int el) {
        int n = BitSet.wordNumber(el);
        if (n >= this.bits.length) {
            return false;
        }
        return (this.bits[n] & BitSet.bitMask(el)) != 0L;
    }

    public int getSingleElement() {
        for (int i = 0; i < this.bits.length << 6; ++i) {
            if (!this.member(i)) continue;
            return i;
        }
        return -7;
    }

    public boolean isNil() {
        for (int i = this.bits.length - 1; i >= 0; --i) {
            if (this.bits[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public IntSet complement() {
        BitSet s2 = (BitSet)this.clone();
        s2.notInPlace();
        return s2;
    }

    public IntSet complement(IntSet set) {
        if (set == null) {
            return this.complement();
        }
        return set.subtract(this);
    }

    public void notInPlace() {
        for (int i = this.bits.length - 1; i >= 0; --i) {
            this.bits[i] = this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public void notInPlace(int maxBit) {
        this.notInPlace(0, maxBit);
    }

    public void notInPlace(int minBit, int maxBit) {
        this.growToInclude(maxBit);
        for (int i = minBit; i <= maxBit; ++i) {
            int n;
            int n2 = n = BitSet.wordNumber(i);
            this.bits[n2] = this.bits[n2] ^ BitSet.bitMask(i);
        }
    }

    private final int numWordsToHold(int el) {
        return (el >> 6) + 1;
    }

    public static BitSet of(int el) {
        BitSet s2 = new BitSet(el + 1);
        s2.add(el);
        return s2;
    }

    public static BitSet of(Collection elements) {
        BitSet s2 = new BitSet();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Integer el = (Integer)iter.next();
            s2.add(el);
        }
        return s2;
    }

    public static BitSet of(IntSet set) {
        if (set == null) {
            return null;
        }
        if (set instanceof BitSet) {
            return (BitSet)set;
        }
        if (set instanceof IntervalSet) {
            BitSet s2 = new BitSet();
            s2.addAll(set);
            return s2;
        }
        throw new IllegalArgumentException("can't create BitSet from " + set.getClass().getName());
    }

    public static BitSet of(Map elements) {
        return BitSet.of(elements.keySet());
    }

    public static BitSet range(int a, int b) {
        BitSet s2 = new BitSet(b + 1);
        for (int i = a; i <= b; ++i) {
            int n;
            int n2 = n = BitSet.wordNumber(i);
            s2.bits[n2] = s2.bits[n2] | BitSet.bitMask(i);
        }
        return s2;
    }

    public IntSet or(IntSet a) {
        if (a == null) {
            return this;
        }
        BitSet s2 = (BitSet)this.clone();
        s2.orInPlace((BitSet)a);
        return s2;
    }

    public void orInPlace(BitSet a) {
        if (a == null) {
            return;
        }
        if (a.bits.length > this.bits.length) {
            this.setSize(a.bits.length);
        }
        int min2 = Math.min(this.bits.length, a.bits.length);
        for (int i = min2 - 1; i >= 0; --i) {
            int n = i;
            this.bits[n] = this.bits[n] | a.bits[i];
        }
    }

    public void remove(int el) {
        int n = BitSet.wordNumber(el);
        if (n >= this.bits.length) {
            this.growToInclude(el);
        }
        int n2 = n;
        this.bits[n2] = this.bits[n2] & (BitSet.bitMask(el) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private void setSize(int nwords) {
        long[] newbits = new long[nwords];
        int n = Math.min(nwords, this.bits.length);
        System.arraycopy(this.bits, 0, newbits, 0, n);
        this.bits = newbits;
    }

    public int numBits() {
        return this.bits.length << 6;
    }

    public int lengthInLongWords() {
        return this.bits.length;
    }

    public boolean subset(BitSet a) {
        if (a == null) {
            return false;
        }
        return ((Object)this.and(a)).equals(this);
    }

    public void subtractInPlace(BitSet a) {
        if (a == null) {
            return;
        }
        for (int i = 0; i < this.bits.length && i < a.bits.length; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] & (a.bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public IntSet subtract(IntSet a) {
        if (a == null || !(a instanceof BitSet)) {
            return null;
        }
        BitSet s2 = (BitSet)this.clone();
        s2.subtractInPlace((BitSet)a);
        return s2;
    }

    public List toList() {
        throw new NoSuchMethodError("BitSet.toList() unimplemented");
    }

    public int[] toArray() {
        int[] elems = new int[this.size()];
        int en = 0;
        for (int i = 0; i < this.bits.length << 6; ++i) {
            if (!this.member(i)) continue;
            elems[en++] = i;
        }
        return elems;
    }

    public long[] toPackedArray() {
        return this.bits;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Grammar g2) {
        StringBuffer buf = new StringBuffer();
        String separator = ",";
        boolean havePrintedAnElement = false;
        buf.append('{');
        for (int i = 0; i < this.bits.length << 6; ++i) {
            if (!this.member(i)) continue;
            if (i > 0 && havePrintedAnElement) {
                buf.append(separator);
            }
            if (g2 != null) {
                buf.append(g2.getTokenDisplayName(i));
            } else {
                buf.append(i);
            }
            havePrintedAnElement = true;
        }
        buf.append('}');
        return buf.toString();
    }

    public String toString(String separator, List vocabulary) {
        if (vocabulary == null) {
            return this.toString(null);
        }
        String str2 = "";
        for (int i = 0; i < this.bits.length << 6; ++i) {
            if (!this.member(i)) continue;
            if (str2.length() > 0) {
                str2 = str2 + separator;
            }
            str2 = i >= vocabulary.size() ? str2 + "'" + (char)i + "'" : (vocabulary.get(i) == null ? str2 + "'" + (char)i + "'" : str2 + (String)vocabulary.get(i));
        }
        return str2;
    }

    public String toStringOfHalfWords() {
        StringBuffer s2 = new StringBuffer();
        for (int i = 0; i < this.bits.length; ++i) {
            if (i != 0) {
                s2.append(", ");
            }
            long tmp = this.bits[i];
            s2.append(tmp &= 0xFFFFFFFFL);
            s2.append("UL");
            s2.append(", ");
            tmp = this.bits[i] >>> 32;
            s2.append(tmp &= 0xFFFFFFFFL);
            s2.append("UL");
        }
        return s2.toString();
    }

    public String toStringOfWords() {
        StringBuffer s2 = new StringBuffer();
        for (int i = 0; i < this.bits.length; ++i) {
            if (i != 0) {
                s2.append(", ");
            }
            s2.append(this.bits[i]);
            s2.append("L");
        }
        return s2.toString();
    }

    public String toStringWithRanges() {
        return this.toString();
    }

    private static final int wordNumber(int bit) {
        return bit >> 6;
    }
}

