/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.InterfaceLexer;
import org.antlr.stringtemplate.language.InterfaceParser;

public class StringTemplateGroupInterface {
    protected String name;
    protected Map templates = new LinkedHashMap();
    protected StringTemplateGroupInterface superInterface = null;
    protected StringTemplateErrorListener listener = DEFAULT_ERROR_LISTENER;
    public static StringTemplateErrorListener DEFAULT_ERROR_LISTENER = new StringTemplateErrorListener(){

        public void error(String s2, Throwable e2) {
            System.err.println(s2);
            if (e2 != null) {
                e2.printStackTrace(System.err);
            }
        }

        public void warning(String s2) {
            System.out.println(s2);
        }
    };

    public StringTemplateGroupInterface(Reader r) {
        this(r, DEFAULT_ERROR_LISTENER, null);
    }

    public StringTemplateGroupInterface(Reader r, StringTemplateErrorListener errors) {
        this(r, errors, null);
    }

    public StringTemplateGroupInterface(Reader r, StringTemplateErrorListener errors, StringTemplateGroupInterface superInterface) {
        this.listener = errors;
        this.setSuperInterface(superInterface);
        this.parseInterface(r);
    }

    public StringTemplateGroupInterface getSuperInterface() {
        return this.superInterface;
    }

    public void setSuperInterface(StringTemplateGroupInterface superInterface) {
        this.superInterface = superInterface;
    }

    protected void parseInterface(Reader r) {
        try {
            InterfaceLexer lexer = new InterfaceLexer(r);
            InterfaceParser parser = new InterfaceParser(lexer);
            parser.groupInterface(this);
        }
        catch (Exception e2) {
            String name = "<unknown>";
            if (this.getName() != null) {
                name = this.getName();
            }
            this.error("problem parsing group " + name + ": " + e2, e2);
        }
    }

    public void defineTemplate(String name, LinkedHashMap formalArgs, boolean optional) {
        TemplateDefinition d = new TemplateDefinition(name, formalArgs, optional);
        this.templates.put(d.name, d);
    }

    public List getMissingTemplates(StringTemplateGroup group) {
        ArrayList<String> missing = new ArrayList<String>();
        Iterator it = this.templates.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            TemplateDefinition d = (TemplateDefinition)this.templates.get(name);
            if (d.optional || group.isDefined(d.name)) continue;
            missing.add(d.name);
        }
        if (missing.size() == 0) {
            missing = null;
        }
        return missing;
    }

    public List getMismatchedTemplates(StringTemplateGroup group) {
        ArrayList<String> mismatched = new ArrayList<String>();
        Iterator it = this.templates.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            TemplateDefinition d = (TemplateDefinition)this.templates.get(name);
            if (!group.isDefined(d.name)) continue;
            StringTemplate defST = group.getTemplateDefinition(d.name);
            Map formalArgs = defST.getFormalArguments();
            boolean ack = false;
            if (d.formalArgs != null && formalArgs == null || d.formalArgs == null && formalArgs != null || d.formalArgs.size() != formalArgs.size()) {
                ack = true;
            }
            if (!ack) {
                Iterator it2 = formalArgs.keySet().iterator();
                while (it2.hasNext()) {
                    String argName = (String)it2.next();
                    if (d.formalArgs.get(argName) != null) continue;
                    ack = true;
                    break;
                }
            }
            if (!ack) continue;
            mismatched.add(this.getTemplateSignature(d));
        }
        if (mismatched.size() == 0) {
            mismatched = null;
        }
        return mismatched;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void error(String msg) {
        this.error(msg, null);
    }

    public void error(String msg, Exception e2) {
        if (this.listener != null) {
            this.listener.error(msg, e2);
        } else {
            System.err.println("StringTemplate: " + msg);
            if (e2 != null) {
                e2.printStackTrace();
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("interface ");
        buf.append(this.getName());
        buf.append(";\n");
        Iterator it = this.templates.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            TemplateDefinition d = (TemplateDefinition)this.templates.get(name);
            buf.append(this.getTemplateSignature(d));
            buf.append(";\n");
        }
        return buf.toString();
    }

    protected String getTemplateSignature(TemplateDefinition d) {
        StringBuffer buf = new StringBuffer();
        if (d.optional) {
            buf.append("optional ");
        }
        buf.append(d.name);
        if (d.formalArgs != null) {
            StringBuffer args = new StringBuffer();
            args.append('(');
            int i = 1;
            Iterator it = d.formalArgs.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                if (i > 1) {
                    args.append(", ");
                }
                args.append(name);
                ++i;
            }
            args.append(')');
            buf.append(args);
        } else {
            buf.append("()");
        }
        return buf.toString();
    }

    static class TemplateDefinition {
        public String name;
        public LinkedHashMap formalArgs;
        public boolean optional = false;

        public TemplateDefinition(String name, LinkedHashMap formalArgs, boolean optional) {
            this.name = name;
            this.formalArgs = formalArgs;
            this.optional = optional;
        }
    }
}

