/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate.language;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateWriter;
import org.antlr.stringtemplate.language.ASTExpr;
import org.antlr.stringtemplate.language.ActionEvaluator;

public class ConditionalExpr
extends ASTExpr {
    StringTemplate subtemplate = null;
    List elseIfSubtemplates = null;
    StringTemplate elseSubtemplate = null;

    public ConditionalExpr(StringTemplate enclosingTemplate, AST tree) {
        super(enclosingTemplate, tree, null);
    }

    public void setSubtemplate(StringTemplate subtemplate) {
        this.subtemplate = subtemplate;
    }

    public void addElseIfSubtemplate(final ASTExpr conditionalTree, final StringTemplate subtemplate) {
        if (this.elseIfSubtemplates == null) {
            this.elseIfSubtemplates = new ArrayList();
        }
        ElseIfClauseData d = new ElseIfClauseData(){
            {
                this.expr = conditionalTree;
                this.st = subtemplate;
            }
        };
        this.elseIfSubtemplates.add(d);
    }

    public StringTemplate getSubtemplate() {
        return this.subtemplate;
    }

    public StringTemplate getElseSubtemplate() {
        return this.elseSubtemplate;
    }

    public void setElseSubtemplate(StringTemplate elseSubtemplate) {
        this.elseSubtemplate = elseSubtemplate;
    }

    public int write(StringTemplate self, StringTemplateWriter out) throws IOException {
        if (this.exprTree == null || self == null || out == null) {
            return 0;
        }
        ActionEvaluator eval2 = new ActionEvaluator(self, this, out);
        int n = 0;
        try {
            boolean testedTrue = false;
            AST cond = this.exprTree.getFirstChild();
            boolean includeSubtemplate = eval2.ifCondition(cond);
            if (includeSubtemplate) {
                n = this.writeSubTemplate(self, out, this.subtemplate);
                testedTrue = true;
            } else if (this.elseIfSubtemplates != null && this.elseIfSubtemplates.size() > 0) {
                for (int i = 0; i < this.elseIfSubtemplates.size(); ++i) {
                    ElseIfClauseData elseIfClause = (ElseIfClauseData)this.elseIfSubtemplates.get(i);
                    includeSubtemplate = eval2.ifCondition(elseIfClause.expr.exprTree);
                    if (!includeSubtemplate) continue;
                    this.writeSubTemplate(self, out, elseIfClause.st);
                    testedTrue = true;
                    break;
                }
            }
            if (!testedTrue && this.elseSubtemplate != null) {
                StringTemplate s2 = this.elseSubtemplate.getInstanceOf();
                s2.setEnclosingInstance(self);
                s2.setGroup(self.getGroup());
                s2.setNativeGroup(self.getNativeGroup());
                n = s2.write(out);
            }
            if (!testedTrue && this.elseSubtemplate == null) {
                n = -1;
            }
        }
        catch (RecognitionException re) {
            self.error("can't evaluate tree: " + this.exprTree.toStringList(), re);
        }
        return n;
    }

    protected int writeSubTemplate(StringTemplate self, StringTemplateWriter out, StringTemplate subtemplate) throws IOException {
        StringTemplate s2 = subtemplate.getInstanceOf();
        s2.setEnclosingInstance(self);
        s2.setGroup(self.getGroup());
        s2.setNativeGroup(self.getNativeGroup());
        return s2.write(out);
    }

    protected static class ElseIfClauseData {
        ASTExpr expr;
        StringTemplate st;

        protected ElseIfClauseData() {
        }
    }
}

