/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.assembler.assemblers;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Content;
import org.apache.jena.assembler.JA;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.assembler.exceptions.UnknownEncodingException;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.util.FileManager;
import org.apache.jena.util.ResourceUtils;
import org.apache.jena.vocabulary.DC_11;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class ContentAssembler
extends AssemblerBase
implements Assembler {
    protected final FileManager defaultFileManager;
    public static final Set<Property> contentProperties = new HashSetWith<Property>().with(JA.content).with(JA.literalContent).with(JA.externalContent).with(JA.quotedContent);
    static final String preamble = "@prefix rdf: <" + RDF.getURI() + "> .\n@prefix rdfs: <" + RDFS.getURI() + "> .\n@prefix owl: <" + OWL.getURI() + "> .\n@prefix xsd: <http://www.w3.org/2001/XMLSchema#> .\n@prefix dc: <" + DC_11.getURI() + "> .";

    public ContentAssembler() {
        this(null);
    }

    public ContentAssembler(FileManager fm) {
        this.defaultFileManager = fm;
    }

    @Override
    public Object open(Assembler a, Resource root2, Mode irrelevant) {
        this.checkType(root2, JA.Content);
        return new Content(this.loadContent(new ArrayList<Content>(), a, root2));
    }

    public List<Content> loadContent(List<Content> contents, Assembler a, Resource root2) {
        FileManager fm = this.getFileManager(a, root2);
        ContentAssembler.addLiteralContent(contents, root2);
        ContentAssembler.addQuotedContent(contents, root2);
        this.addExternalContents(contents, fm, root2);
        ContentAssembler.addIndirectContent(contents, a, root2);
        return contents;
    }

    private static void addIndirectContent(List<Content> contents, Assembler a, Resource root2) {
        StmtIterator it = root2.listProperties(JA.content);
        while (it.hasNext()) {
            contents.add((Content)a.open(ContentAssembler.getResource(it.nextStatement())));
        }
    }

    protected void addExternalContents(List<Content> contents, FileManager fm, Resource root2) {
        StmtIterator it = root2.listProperties(JA.externalContent);
        while (it.hasNext()) {
            contents.add(this.objectAsContent(fm, it.nextStatement()));
        }
    }

    private static void addQuotedContent(List<Content> contents, Resource root2) {
        StmtIterator it = root2.listProperties(JA.quotedContent);
        while (it.hasNext()) {
            Resource q = ContentAssembler.getResource(it.nextStatement());
            Model m3 = ResourceUtils.reachableClosure(q);
            contents.add(ContentAssembler.newModelContent(m3));
        }
    }

    protected static void addLiteralContent(List<Content> contents, Resource root2) {
        String encoding = ContentAssembler.getEncoding(root2);
        StmtIterator it = root2.listProperties(JA.literalContent);
        while (it.hasNext()) {
            String s2 = ContentAssembler.getString(it.nextStatement());
            Model model = ContentAssembler.parseAs(root2, encoding, s2);
            contents.add(ContentAssembler.newModelContent(model));
        }
    }

    private static Model parseAs(Resource root2, String encoding, String lexicalForm) {
        String enc;
        String string = enc = encoding == null ? ContentAssembler.guessFrom(lexicalForm) : encoding;
        if (enc.equals("N3")) {
            return ContentAssembler.parseAsN3(lexicalForm);
        }
        if (enc.equals("RDF/XML")) {
            return ContentAssembler.parseAsXML(lexicalForm);
        }
        throw new UnknownEncodingException(root2, encoding);
    }

    private static Model parseAsXML(String lexicalForm) {
        String pre = "<?xml version='1.0'?><rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#' xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#' xmlns:xsd='http://www.w3.org/2001/XMLSchema#' xmlns:owl='http://www.w3.org/2002/07/owl#' xmlns:dc='http://purl.org/dc/elements/1.1/'>";
        String post = "</rdf:RDF>";
        StringReader r = new StringReader(pre + lexicalForm + post);
        return ModelFactory.createDefaultModel().read(r, "", "RDF/XML");
    }

    private static String guessFrom(String lexicalForm) {
        return "N3";
    }

    private static String getEncoding(Resource root2) {
        Literal L2 = ContentAssembler.getUniqueLiteral(root2, JA.contentEncoding);
        return L2 == null ? null : L2.getLexicalForm();
    }

    protected static Content newModelContent(final Model m3) {
        return new Content(){

            @Override
            public Model fill(Model x) {
                x.setNsPrefixes(m3);
                return x.add(m3);
            }

            @Override
            public boolean isEmpty() {
                return m3.isEmpty();
            }
        };
    }

    protected Content objectAsContent(FileManager fm, Statement s2) {
        Model m3 = fm.loadModel(this.getModelName(s2));
        return ContentAssembler.newModelContent(m3);
    }

    private String getModelName(Statement s2) {
        Node o = s2.getObject().asNode();
        return o.isLiteral() ? o.getLiteralLexicalForm() : o.getURI();
    }

    private FileManager getFileManager(Assembler a, Resource root2) {
        Resource fm = ContentAssembler.getUniqueResource(root2, JA.fileManager);
        return fm != null ? (FileManager)a.open(fm) : (this.defaultFileManager == null ? FileManager.get() : this.defaultFileManager);
    }

    protected static Model parseAsN3(String value) {
        Model result = ModelFactory.createDefaultModel();
        StringReader r = new StringReader(preamble + "\n" + value);
        result.read(r, "", "N3");
        return result;
    }

    public Object getFileManager() {
        return this.defaultFileManager;
    }

    static class HashSetWith<T>
    extends HashSet<T> {
        HashSetWith() {
        }

        public HashSetWith<T> with(T x) {
            this.add(x);
            return this;
        }
    }
}

