/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.assembler.assemblers;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.JA;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.ontology.OntDocumentManager;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.FileManager;
import org.apache.jena.util.ResourceUtils;

public class DocumentManagerAssembler
extends AssemblerBase {
    @Override
    public Object open(Assembler a, Resource root2, Mode irrelevant) {
        this.checkType(root2, JA.DocumentManager);
        OntDocumentManager result = this.createDocumentManager();
        result.setMetadataSearchPath(this.getPath(a, root2), false);
        result.configure(ResourceUtils.reachableClosure(root2), false);
        result.setFileManager(this.getFileManager(a, root2));
        return result;
    }

    private String getPath(Assembler a, Resource root2) {
        String s2 = DocumentManagerAssembler.getUniqueString(root2, JA.policyPath);
        return s2 == null ? "file:ont-policy.rdf;file:etc/ont-policy.rdf;ont-policy.rdf" : s2;
    }

    private FileManager getFileManager(Assembler a, Resource root2) {
        Resource fm = DocumentManagerAssembler.getUniqueResource(root2, JA.fileManager);
        return fm == null ? FileManager.get() : (FileManager)a.open(fm);
    }

    protected OntDocumentManager createDocumentManager() {
        return new OntDocumentManager("");
    }
}

