/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph.impl;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEventManager;
import org.apache.jena.graph.GraphListener;
import org.apache.jena.graph.Triple;
import org.apache.jena.mem.TrackingTripleIterator;
import org.apache.jena.util.IteratorCollection;
import org.apache.jena.util.iterator.ExtendedIterator;

public class SimpleEventManager
implements GraphEventManager {
    @Deprecated
    protected Graph graph = null;
    protected List<GraphListener> listeners = new CopyOnWriteArrayList<GraphListener>();

    @Deprecated
    public SimpleEventManager(Graph graph) {
        this();
        this.graph = graph;
    }

    public SimpleEventManager() {
    }

    @Override
    public GraphEventManager register(GraphListener listener) {
        this.listeners.add(listener);
        return this;
    }

    @Override
    public GraphEventManager unregister(GraphListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    @Override
    public boolean listening() {
        return this.listeners.size() > 0;
    }

    @Override
    public void notifyAddTriple(Graph g2, Triple t) {
        for (GraphListener l : this.listeners) {
            l.notifyAddTriple(g2, t);
        }
    }

    @Override
    public void notifyAddArray(Graph g2, Triple[] ts) {
        for (GraphListener l : this.listeners) {
            l.notifyAddArray(g2, ts);
        }
    }

    @Override
    public void notifyAddList(Graph g2, List<Triple> L2) {
        for (GraphListener l : this.listeners) {
            l.notifyAddList(g2, L2);
        }
    }

    @Override
    public void notifyAddIterator(Graph g2, List<Triple> it) {
        for (GraphListener l : this.listeners) {
            l.notifyAddIterator(g2, it.iterator());
        }
    }

    @Override
    public void notifyAddIterator(Graph g2, Iterator<Triple> it) {
        this.notifyAddIterator(g2, IteratorCollection.iteratorToList(it));
    }

    @Override
    public void notifyAddGraph(Graph g2, Graph added) {
        for (GraphListener l : this.listeners) {
            l.notifyAddGraph(g2, added);
        }
    }

    @Override
    public void notifyDeleteTriple(Graph g2, Triple t) {
        for (GraphListener l : this.listeners) {
            l.notifyDeleteTriple(g2, t);
        }
    }

    @Override
    public void notifyDeleteArray(Graph g2, Triple[] ts) {
        for (GraphListener l : this.listeners) {
            l.notifyDeleteArray(g2, ts);
        }
    }

    @Override
    public void notifyDeleteList(Graph g2, List<Triple> L2) {
        for (GraphListener l : this.listeners) {
            l.notifyDeleteList(g2, L2);
        }
    }

    @Override
    public void notifyDeleteIterator(Graph g2, List<Triple> L2) {
        for (GraphListener l : this.listeners) {
            l.notifyDeleteIterator(g2, L2.iterator());
        }
    }

    @Override
    public void notifyDeleteIterator(Graph g2, Iterator<Triple> it) {
        this.notifyDeleteIterator(g2, IteratorCollection.iteratorToList(it));
    }

    @Override
    public void notifyDeleteGraph(Graph g2, Graph removed) {
        for (GraphListener l : this.listeners) {
            l.notifyDeleteGraph(g2, removed);
        }
    }

    @Override
    public void notifyEvent(Graph source, Object event) {
        for (GraphListener l : this.listeners) {
            l.notifyEvent(source, event);
        }
    }

    public static ExtendedIterator<Triple> notifyingRemove(final Graph g2, Iterator<Triple> i) {
        return new TrackingTripleIterator(i){
            protected final GraphEventManager gem;
            {
                super(it);
                this.gem = g2.getEventManager();
            }

            @Override
            public void remove() {
                super.remove();
                this.gem.notifyDeleteTriple(g2, this.current);
            }
        };
    }
}

