/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontology;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.shared.JenaException;
import org.apache.jena.util.iterator.ExtendedIterator;

public class OntTools {
    public static OntClass getLCA(OntModel m3, OntClass u, OntClass v) {
        Resource root2 = m3.getProfile().THING();
        if (root2 == null) {
            throw new JenaException("The given OntModel has a language profile that does not define a generic root class (such as owl:Thing)");
        }
        root2 = root2.inModel(m3);
        return OntTools.getLCA(m3, root2.as(OntClass.class), u, v);
    }

    public static OntClass getLCA(OntModel m3, OntClass root2, OntClass u, OntClass v) {
        if (u.equals(root2) || v.equals(root2)) {
            return root2;
        }
        if (u.hasSubClass(v)) {
            return u;
        }
        if (v.hasSubClass(u)) {
            return v;
        }
        LCAIndex index = new LCAIndex();
        OntTools.lca(root2, u, v, index);
        return (OntClass)index.getLCA(u, v);
    }

    public static Path findShortestPath(Model m3, Resource start, RDFNode end, Predicate<Statement> onPath) {
        LinkedList<Path> bfs = new LinkedList<Path>();
        HashSet<Resource> seen = new HashSet<Resource>();
        ExtendedIterator<Statement> i = m3.listStatements(start, null, (RDFNode)null).filterKeep(onPath);
        while (i.hasNext()) {
            bfs.add(new Path().append((Statement)i.next()));
        }
        Path solution = null;
        while (solution == null && !bfs.isEmpty()) {
            Path candidate = (Path)bfs.remove(0);
            if (candidate.hasTerminus(end)) {
                solution = candidate;
                continue;
            }
            Resource terminus = candidate.getTerminalResource();
            if (terminus == null) continue;
            seen.add(terminus);
            ExtendedIterator<Statement> i2 = terminus.listProperties().filterKeep(onPath);
            while (i2.hasNext()) {
                Statement link = (Statement)i2.next();
                if (seen.contains(link.getObject())) continue;
                bfs.add(candidate.append(link));
            }
        }
        return solution;
    }

    public static List<OntClass> namedHierarchyRoots(OntModel m3) {
        ArrayList<OntClass> nhr = new ArrayList<OntClass>();
        ArrayList<OntClass> ahr = new ArrayList<OntClass>();
        OntTools.partitionByNamed(m3.listHierarchyRootClasses(), nhr, ahr);
        while (!ahr.isEmpty()) {
            OntClass c = (OntClass)ahr.remove(0);
            OntTools.partitionByNamed(c.listSubClasses(true), nhr, ahr);
        }
        return nhr;
    }

    protected static DisjointSet lca(OntClass cls, OntClass uCls, OntClass vCls, LCAIndex index) {
        DisjointSet clsSet = index.getSet(cls);
        if (clsSet.isBlack()) {
            return clsSet;
        }
        clsSet.setAncestor(clsSet);
        ExtendedIterator<OntClass> i = cls.listSubClasses(true);
        while (i.hasNext()) {
            OntClass child = (OntClass)i.next();
            if (child.equals(cls) || child.equals(cls.getProfile().NOTHING())) continue;
            DisjointSet v = OntTools.lca(child, uCls, vCls, index);
            clsSet.union(v);
            clsSet.find().setAncestor(clsSet);
        }
        clsSet.setBlack();
        if (cls.equals(uCls)) {
            OntTools.checkSolution(uCls, vCls, index);
        } else if (cls.equals(vCls)) {
            OntTools.checkSolution(vCls, uCls, index);
        }
        return clsSet;
    }

    protected static void checkSolution(OntClass uCls, OntClass vCls, LCAIndex index) {
        DisjointSet vSet = index.getSet(vCls);
        DisjointSet uSet = index.getSet(uCls);
        if (vSet != null && vSet.isBlack() && !vSet.used() && uSet != null && uSet.isBlack() && !uSet.used()) {
            vSet.setUsed();
            uSet.setUsed();
            OntClass lca = (OntClass)vSet.find().getAncestor().getNode();
            index.setLCA(uCls, vCls, lca);
        }
    }

    protected static void partitionByNamed(Iterator<? extends OntClass> i, List<OntClass> named, List<OntClass> anon2) {
        while (i.hasNext()) {
            OntClass c = i.next();
            boolean ignore = false;
            if (named.contains(c)) {
                ignore = true;
            }
            Resource thing = c.getProfile().THING();
            ExtendedIterator<OntClass> j = c.listSuperClasses();
            while (!ignore && j.hasNext()) {
                OntClass sup = (OntClass)j.next();
                if (thing != null && sup.equals(thing) || sup.isAnon() || sup.equals(c)) continue;
                ignore = true;
            }
            if (ignore) continue;
            (c.isAnon() ? anon2 : named).add(c);
        }
    }

    public static class PredicatesFilter
    implements Predicate<Statement> {
        public Collection<Property> m_preds;

        public PredicatesFilter(Collection<Property> preds) {
            this.m_preds = preds;
        }

        public PredicatesFilter(Property[] preds) {
            this.m_preds = new HashSet<Property>();
            for (Property pred : preds) {
                this.m_preds.add(pred);
            }
        }

        public PredicatesFilter(Property pred) {
            this.m_preds = new HashSet<Property>();
            this.m_preds.add(pred);
        }

        @Override
        public boolean test(Statement s2) {
            return this.m_preds.contains(s2.getPredicate());
        }
    }

    public static class Path
    extends ArrayList<Statement> {
        public Path() {
        }

        public Path(Path basePath) {
            super(basePath);
        }

        public Statement getStatement(int i) {
            return (Statement)this.get(i);
        }

        public Path append(Statement s2) {
            Path newPath = new Path(this);
            newPath.add(s2);
            return newPath;
        }

        public boolean hasTerminus(RDFNode n) {
            return n != null && n.equals(this.getTerminal());
        }

        public RDFNode getTerminal() {
            return this.size() > 0 ? ((Statement)this.get(this.size() - 1)).getObject() : null;
        }

        public Resource getTerminalResource() {
            RDFNode n = this.getTerminal();
            return n != null && n.isResource() ? (Resource)n : null;
        }
    }

    public static class LCAIndex {
        private Map<Resource, DisjointSet> m_setIndex = new HashMap<Resource, DisjointSet>();
        private Map<Resource, Map<Resource, Resource>> m_lcaIndex = new HashMap<Resource, Map<Resource, Resource>>();

        public Resource getLCA(Resource u, Resource v) {
            Resource lca;
            Map<Resource, Resource> map = this.m_lcaIndex.get(u);
            Resource resource = lca = map == null ? null : map.get(v);
            if (lca == null) {
                map = this.m_lcaIndex.get(v);
                lca = map == null ? null : map.get(u);
            }
            return lca;
        }

        public void setLCA(Resource u, Resource v, Resource lca) {
            Map<Resource, Resource> uMap = this.m_lcaIndex.get(u);
            if (uMap == null) {
                uMap = new HashMap<Resource, Resource>();
                this.m_lcaIndex.put(u, uMap);
            }
            uMap.put(v, lca);
        }

        public DisjointSet getSet(Resource r) {
            DisjointSet s2 = this.m_setIndex.get(r);
            if (s2 == null) {
                s2 = new DisjointSet(r);
                this.m_setIndex.put(r, s2);
            }
            return s2;
        }
    }

    public static class DisjointSet {
        private Resource m_node;
        private DisjointSet m_parent;
        private int m_rank;
        private DisjointSet m_ancestor;
        private boolean m_black = false;
        private boolean m_used = false;

        public DisjointSet(Resource node) {
            this.m_node = node;
            this.m_rank = 0;
            this.m_parent = this;
        }

        public Resource getNode() {
            return this.m_node;
        }

        public DisjointSet getParent() {
            return this.m_parent;
        }

        public void setParent(DisjointSet parent) {
            this.m_parent = parent;
        }

        public int getRank() {
            return this.m_rank;
        }

        public void incrementRank() {
            ++this.m_rank;
        }

        public DisjointSet getAncestor() {
            return this.m_ancestor;
        }

        public void setAncestor(DisjointSet anc) {
            this.m_ancestor = anc;
        }

        public void setBlack() {
            this.m_black = true;
        }

        public boolean isBlack() {
            return this.m_black;
        }

        public boolean used() {
            return this.m_used;
        }

        public void setUsed() {
            this.m_used = true;
        }

        public DisjointSet find() {
            DisjointSet root2;
            if (this.getParent() == this) {
                root2 = this;
            } else {
                root2 = this.getParent().find();
                this.setParent(root2);
            }
            return root2;
        }

        public void union(DisjointSet y) {
            DisjointSet xRoot = this.find();
            DisjointSet yRoot = y.find();
            if (xRoot.getRank() > yRoot.getRank()) {
                yRoot.setParent(xRoot);
            } else if (yRoot.getRank() > xRoot.getRank()) {
                xRoot.setParent(yRoot);
            } else if (xRoot != yRoot) {
                yRoot.setParent(xRoot);
                xRoot.incrementRank();
            }
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("DisjointSet{node=");
            buf.append(this.m_node);
            buf.append(",anc=");
            buf.append(this.getAncestor() == this ? "self" : (this.getAncestor() == null ? "null" : this.getAncestor().toShortString()));
            buf.append(",parent=");
            buf.append(this.getParent() == this ? "self" : (this.getParent() == null ? "null" : this.getParent().toShortString()));
            buf.append(",rank=");
            buf.append(this.getRank());
            buf.append(this.m_black ? ",black" : ",white");
            buf.append("}");
            return buf.toString();
        }

        public String toShortString() {
            StringBuilder buf = new StringBuilder();
            buf.append("DisjointSet{node=");
            buf.append(this.m_node);
            buf.append(",parent=");
            buf.append(this.getParent() == this ? "self" : (this.getParent() == null ? "null" : this.getParent().toShortString()));
            buf.append("...}");
            return buf.toString();
        }
    }
}

