/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphExtract;
import org.apache.jena.graph.TripleBoundary;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.StatementBoundary;

public class ModelExtract {
    protected StatementBoundary boundary;

    public ModelExtract(StatementBoundary b) {
        this.boundary = b;
    }

    public Model extract(Resource r, Model s2) {
        return this.extractInto(ModelFactory.createDefaultModel(), r, s2);
    }

    public Model extractInto(Model model, Resource r, Model s2) {
        TripleBoundary tb = this.boundary.asTripleBoundary(s2);
        Graph g2 = this.getGraphExtract(tb).extractInto(model.getGraph(), r.asNode(), s2.getGraph());
        return ModelFactory.createModelForGraph(g2);
    }

    protected GraphExtract getGraphExtract(TripleBoundary tb) {
        return new GraphExtract(tb);
    }
}

