/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfconnection.examples;

import java.io.OutputStream;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.system.Txn;

public class RDFConnectionExample2 {
    public static void main(String ... args) {
        Query query = QueryFactory.create("SELECT * { {?s ?p ?o } UNION { GRAPH ?g { ?s ?p ?o } } }");
        Dataset dataset = DatasetFactory.createTxnMem();
        try (RDFConnection conn = RDFConnectionFactory.connect(dataset);){
            System.out.println("** Load a file");
            Txn.executeWrite(conn, () -> conn.load("data.ttl"));
            conn.begin(ReadWrite.WRITE);
            conn.load("http://example/g0", "data.ttl");
            System.out.println("** Inside multistep transaction - query dataset");
            conn.queryResultSet(query, ResultSetFormatter::out);
            conn.abort();
            conn.end();
            System.out.println("** After abort 1");
            Txn.executeWrite(conn, () -> {
                conn.load("http://example/g0", "data.ttl");
                System.out.println("** Inside multistep transaction - fetch dataset");
                Dataset ds2 = conn.fetchDataset();
                RDFDataMgr.write((OutputStream)System.out, ds2, Lang.TRIG);
                conn.abort();
            });
            System.out.println("** After abort 2");
            conn.queryResultSet(query, ResultSetFormatter::out);
        }
    }
}

