/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import java.io.OutputStream;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.Sink;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterNT;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.system.Prologue;
import org.apache.jena.sparql.core.Quad;

public class SinkQuadOutput
implements Sink<Quad> {
    private Prologue prologue = null;
    private AWriter out;
    private NodeToLabel labelPolicy = null;
    private NodeFormatter nodeFmt = new NodeFormatterNT();

    public SinkQuadOutput(OutputStream outs, Prologue prologue, NodeToLabel labels) {
        this.out = IO.wrapUTF8(outs);
        this.setPrologue(prologue);
        this.setLabelPolicy(labels);
    }

    public void setPrologue(Prologue prologue) {
        this.prologue = prologue;
    }

    public void setLabelPolicy(NodeToLabel labels) {
        this.labelPolicy = labels;
    }

    @Override
    public void send(Quad quad) {
        Node s2 = quad.getSubject();
        Node p = quad.getPredicate();
        Node o = quad.getObject();
        Node g2 = quad.getGraph();
        this.nodeFmt.format(this.out, s2);
        this.out.print(" ");
        this.nodeFmt.format(this.out, p);
        this.out.print(" ");
        this.nodeFmt.format(this.out, o);
        if (SinkQuadOutput.outputGraphSlot(g2)) {
            this.out.print(" ");
            this.nodeFmt.format(this.out, g2);
        }
        this.out.print(" .\n");
    }

    private static boolean outputGraphSlot(Node g2) {
        return g2 != null && g2 != Quad.tripleInQuad && !Quad.isDefaultGraph(g2);
    }

    @Override
    public void flush() {
        IO.flush(this.out);
    }

    @Override
    public void close() {
        IO.flush(this.out);
    }
}

