/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.system.SerializerRDF;
import org.apache.jena.riot.thrift.TRDF;
import org.apache.jena.riot.thrift.wire.RDF_Term;
import org.apache.thrift.protocol.TProtocol;

public final class STriple
implements Serializable {
    private static final long serialVersionUID = -6877221872561743747L;
    private transient Triple triple;

    public STriple(Triple triple) {
        this.triple = triple;
    }

    public Triple getTriple() {
        return this.triple;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        TProtocol protocol = TRDF.protocol(out);
        RDF_Term tterm = new RDF_Term();
        SerializerRDF.write(protocol, tterm, this.triple.getSubject());
        SerializerRDF.write(protocol, tterm, this.triple.getPredicate());
        SerializerRDF.write(protocol, tterm, this.triple.getObject());
        TRDF.flush(protocol);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        TProtocol protocol = TRDF.protocol(in);
        RDF_Term tterm = new RDF_Term();
        Node s2 = SerializerRDF.read(protocol, tterm);
        Node p = SerializerRDF.read(protocol, tterm);
        Node o = SerializerRDF.read(protocol, tterm);
        this.triple = Triple.create(s2, p, o);
    }

    Object readResolve() throws ObjectStreamException {
        return this.triple;
    }
}

