/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system.stream;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.LocationMappingVocab;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationMapper {
    static Logger log = LoggerFactory.getLogger(LocationMapper.class);
    Map<String, String> altLocations = new HashMap<String, String>();
    Map<String, String> altPrefixes = new HashMap<String, String>();

    public LocationMapper clone() {
        return LocationMapper.clone(this);
    }

    private static LocationMapper clone(LocationMapper other) {
        LocationMapper mapper = new LocationMapper();
        mapper.altLocations.putAll(other.altLocations);
        mapper.altPrefixes.putAll(other.altPrefixes);
        return mapper;
    }

    public void copyFrom(LocationMapper lmap2) {
        this.altLocations.putAll(lmap2.altLocations);
        this.altPrefixes.putAll(lmap2.altPrefixes);
    }

    public String altMapping(String uri) {
        return this.altMapping(uri, uri);
    }

    public String altMapping(String uri, String otherwise) {
        if (this.altLocations.containsKey(uri)) {
            return this.altLocations.get(uri);
        }
        String newStart = null;
        String oldStart = null;
        for (String prefix : this.altPrefixes.keySet()) {
            if (!uri.startsWith(prefix)) continue;
            String s2 = this.altPrefixes.get(prefix);
            if (newStart != null && newStart.length() >= s2.length()) continue;
            oldStart = prefix;
            newStart = s2;
        }
        if (newStart != null) {
            return newStart + uri.substring(oldStart.length());
        }
        return otherwise;
    }

    public void addAltEntry(String uri, String alt2) {
        this.altLocations.put(uri, alt2);
    }

    public void addAltPrefix(String uriPrefix, String altPrefix) {
        this.altPrefixes.put(uriPrefix, altPrefix);
    }

    public Iterator<String> listAltEntries() {
        return this.altLocations.keySet().iterator();
    }

    public Iterator<String> listAltPrefixes() {
        return this.altPrefixes.keySet().iterator();
    }

    public void removeAltEntry(String uri) {
        this.altLocations.remove(uri);
    }

    public void removeAltPrefix(String uriPrefix) {
        this.altPrefixes.remove(uriPrefix);
    }

    public String getAltEntry(String uri) {
        return this.altLocations.get(uri);
    }

    public String getAltPrefix(String uriPrefix) {
        return this.altPrefixes.get(uriPrefix);
    }

    public int hashCode() {
        int x = 0;
        x ^= this.altLocations.hashCode();
        return x ^= this.altPrefixes.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LocationMapper)) {
            return false;
        }
        LocationMapper other = (LocationMapper)obj;
        if (!this.altLocations.equals(other.altLocations)) {
            return false;
        }
        return this.altPrefixes.equals(other.altPrefixes);
    }

    public String toString() {
        String v;
        String s2 = "";
        for (String k : this.altLocations.keySet()) {
            v = this.altLocations.get(k);
            s2 = s2 + "(Loc:" + k + "=>" + v + ") ";
        }
        for (String k : this.altPrefixes.keySet()) {
            v = this.altPrefixes.get(k);
            s2 = s2 + "(Prefix:" + k + "=>" + v + ") ";
        }
        return s2;
    }

    public Model toModel() {
        Model m3 = ModelFactory.createDefaultModel();
        m3.setNsPrefix("lmap", "http://jena.hpl.hp.com/2004/08/location-mapping#");
        this.toModel(m3);
        return m3;
    }

    public void toModel(Model model) {
        String v;
        String k;
        Resource e2;
        Resource r;
        for (String s1 : this.altLocations.keySet()) {
            r = model.createResource();
            e2 = model.createResource();
            model.add(r, LocationMappingVocab.mapping, e2);
            k = s1;
            v = this.altLocations.get(k);
            model.add(e2, LocationMappingVocab.name, k);
            model.add(e2, LocationMappingVocab.altName, v);
        }
        for (String s2 : this.altPrefixes.keySet()) {
            r = model.createResource();
            e2 = model.createResource();
            model.add(r, LocationMappingVocab.mapping, e2);
            k = s2;
            v = this.altPrefixes.get(k);
            model.add(e2, LocationMappingVocab.prefix, k);
            model.add(e2, LocationMappingVocab.altPrefix, v);
        }
    }
}

