/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shared.uuid;

import java.util.Locale;
import java.util.UUID;
import org.apache.jena.atlas.lib.BitsLong;
import org.apache.jena.shared.uuid.UUIDFactory;
import org.apache.jena.shared.uuid.UUID_V1_Gen;
import org.apache.jena.shared.uuid.UUID_V4_Gen;
import org.apache.jena.shared.uuid.UUID_nil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JenaUUID {
    static final int HEX = 16;
    static final int Var_NCS = 0;
    static final int Var_Std = 2;
    static final int Var_DCE = 2;
    static final int Var_MS_GUID = 6;
    static final int Var_Reserved = 7;
    static UUIDFactory factory = new UUID_V1_Gen();

    public abstract int getVersion();

    public abstract int getVariant();

    public abstract long getMostSignificantBits();

    public abstract long getLeastSignificantBits();

    protected int _getVersion(long mostSigBits, long leastSigBits) {
        int version2 = (int)BitsLong.unpack(mostSigBits, 12, 16);
        return version2;
    }

    protected int _getVariant(long mostSigBits, long leastSigBits) {
        int variant = (int)BitsLong.unpack(leastSigBits, 62, 64);
        return variant;
    }

    protected JenaUUID() {
    }

    public String asString() {
        return this.toString();
    }

    public String asURI() {
        return "uuid:" + this.toString();
    }

    public String asURN() {
        return "urn:uuid:" + this.toString();
    }

    public UUID asUUID() {
        return new UUID(this.getMostSignificantBits(), this.getLeastSignificantBits());
    }

    public String toString() {
        return JenaUUID.toString(this);
    }

    public int hashCode() {
        return (int)BitsLong.unpack(this.getMostSignificantBits(), 32, 64);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof JenaUUID)) {
            return false;
        }
        JenaUUID x = (JenaUUID)other;
        return this.getMostSignificantBits() == x.getMostSignificantBits() && this.getLeastSignificantBits() == x.getLeastSignificantBits();
    }

    public static void setFactory(UUIDFactory factory) {
        JenaUUID.factory = factory;
    }

    public static UUIDFactory getFactory() {
        return factory;
    }

    public static JenaUUID generate() {
        return factory.generate();
    }

    public static void reset() {
        factory.reset();
    }

    public static JenaUUID nil() {
        return UUID_nil.getNil();
    }

    public static String strNil() {
        return UUID_nil.getNilString();
    }

    public boolean isNil() {
        return this.equals(JenaUUID.nil());
    }

    public static JenaUUID parse(String s2) {
        if (s2.equals(JenaUUID.strNil())) {
            return JenaUUID.nil();
        }
        if ((s2 = s2.toLowerCase(Locale.ENGLISH)).startsWith("urn:")) {
            s2 = s2.substring(4);
        }
        if (s2.startsWith("uuid:")) {
            s2 = s2.substring(5);
        }
        if (s2.length() != 36) {
            throw new UUIDFormatException("UUID string is not 36 chars long: it's " + s2.length() + " [" + s2 + "]");
        }
        if (s2.charAt(8) != '-' || s2.charAt(13) != '-' || s2.charAt(18) != '-' || s2.charAt(23) != '-') {
            throw new UUIDFormatException("String does not have dashes in the right places: " + s2);
        }
        int x = (int)BitsLong.unpack(s2, 19, 23);
        int variant = x >>> 14;
        int version2 = (int)BitsLong.unpack(s2, 14, 15);
        if (variant == 2) {
            switch (version2) {
                case 1: {
                    return UUID_V1_Gen.parse$(s2);
                }
                case 4: {
                    return UUID_V4_Gen.parse$(s2);
                }
            }
            LoggerFactory.getLogger(JenaUUID.class).warn(s2 + " : Unsupported version: " + version2);
            throw new UnsupportedOperationException("String specifies unsupported UUID version: " + version2);
        }
        Logger log2 = LoggerFactory.getLogger(JenaUUID.class);
        switch (variant) {
            case 0: {
                log2.warn(s2 + " : Oh look! An NCS UUID ID.  Call the museum.");
                break;
            }
            case 2: {
                log2.warn(s2 + " : Oh look! A DCE UUID ID - but we should have already handled this");
                break;
            }
            case 6: {
                log2.warn(s2 + " : Microsoft UUID ID.");
                break;
            }
            case 7: {
                log2.warn(s2 + " : Reserved variant");
                break;
            }
            default: {
                log2.warn(s2 + " : Unknown variant: " + variant);
            }
        }
        throw new UnsupportedOperationException("String specifies unsupported UUID variant: " + variant);
    }

    public static String toString(JenaUUID uuid2) {
        return JenaUUID.toString(uuid2.getMostSignificantBits(), uuid2.getLeastSignificantBits());
    }

    public static String toString(long mostSignificantBits, long leastSignificantBits) {
        StringBuffer sb = new StringBuffer(36);
        JenaUUID.toHex(sb, BitsLong.unpack(mostSignificantBits, 32, 64), 4);
        sb.append('-');
        JenaUUID.toHex(sb, BitsLong.unpack(mostSignificantBits, 16, 32), 2);
        sb.append('-');
        JenaUUID.toHex(sb, BitsLong.unpack(mostSignificantBits, 0, 16), 2);
        sb.append('-');
        JenaUUID.toHex(sb, BitsLong.unpack(leastSignificantBits, 48, 64), 2);
        sb.append('-');
        JenaUUID.toHex(sb, BitsLong.unpack(leastSignificantBits, 0, 48), 6);
        return sb.toString();
    }

    static void toHex(StringBuffer sBuff, long value, int lenBytes) {
        for (int i = 2 * lenBytes - 1; i >= 0; --i) {
            int shift = 4 * i;
            int x = (int)(value >>> shift & 0xFL);
            sBuff.append(Character.forDigit(x, 16));
        }
    }

    public static class UUIDFormatException
    extends RuntimeException {
        public UUIDFormatException() {
        }

        public UUIDFormatException(String msg) {
            super(msg);
        }
    }
}

