/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.core.DatasetChanges;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphWrapper;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadAction;
import org.apache.jena.util.iterator.ExtendedIterator;

public class DatasetGraphMonitor
extends DatasetGraphWrapper {
    private boolean CheckFirst = true;
    private boolean RecordNoAction = true;
    private final DatasetChanges monitor;
    private static int SLICE = 1000;

    public DatasetGraphMonitor(DatasetGraph dsg, DatasetChanges monitor) {
        super(dsg);
        this.monitor = monitor;
    }

    public DatasetGraphMonitor(DatasetGraph dsg, DatasetChanges monitor, boolean recordOnlyIfRealChange) {
        super(dsg);
        this.CheckFirst = recordOnlyIfRealChange;
        this.monitor = monitor;
    }

    public DatasetChanges getMonitor() {
        return this.monitor;
    }

    public DatasetGraph monitored() {
        return this.getWrapped();
    }

    @Override
    public void add(Quad quad) {
        if (this.CheckFirst && this.contains(quad)) {
            if (this.RecordNoAction) {
                this.record(QuadAction.NO_ADD, quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
            }
            return;
        }
        this.add$(quad);
    }

    @Override
    public void add(Node g2, Node s2, Node p, Node o) {
        if (this.CheckFirst && this.contains(g2, s2, p, o)) {
            if (this.RecordNoAction) {
                this.record(QuadAction.NO_ADD, g2, s2, p, o);
            }
            return;
        }
        this.add$(g2, s2, p, o);
    }

    private void add$(Node g2, Node s2, Node p, Node o) {
        super.add(g2, s2, p, o);
        this.record(QuadAction.ADD, g2, s2, p, o);
    }

    private void add$(Quad quad) {
        super.add(quad);
        this.record(QuadAction.ADD, quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    @Override
    public void delete(Quad quad) {
        if (this.CheckFirst && !this.contains(quad)) {
            if (this.RecordNoAction) {
                this.record(QuadAction.NO_DELETE, quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
            }
            return;
        }
        this.delete$(quad);
    }

    @Override
    public void delete(Node g2, Node s2, Node p, Node o) {
        if (this.CheckFirst && !this.contains(g2, s2, p, o)) {
            if (this.RecordNoAction) {
                this.record(QuadAction.NO_DELETE, g2, s2, p, o);
            }
            return;
        }
        this.delete$(g2, s2, p, o);
    }

    private void delete$(Quad quad) {
        super.delete(quad);
        this.record(QuadAction.DELETE, quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    private void delete$(Node g2, Node s2, Node p, Node o) {
        super.delete(g2, s2, p, o);
        this.record(QuadAction.DELETE, g2, s2, p, o);
    }

    @Override
    public void deleteAny(Node g2, Node s2, Node p, Node o) {
        List<Quad> some;
        do {
            Iterator<Quad> iter = this.find(g2, s2, p, o);
            some = Iter.take(iter, SLICE);
            for (Quad q : some) {
                this.delete$(q);
            }
        } while (some.size() >= SLICE);
    }

    @Override
    public void addGraph(Node gn, Graph g2) {
        ExtendedIterator<Triple> iter = g2.find(Node.ANY, Node.ANY, Node.ANY);
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            this.add(gn, t.getSubject(), t.getPredicate(), t.getObject());
        }
    }

    @Override
    public void removeGraph(Node gn) {
        this.deleteAny(gn, Node.ANY, Node.ANY, Node.ANY);
    }

    private void record(QuadAction action, Node g2, Node s2, Node p, Node o) {
        this.monitor.change(action, g2, s2, p, o);
    }

    @Override
    public void sync() {
        SystemARQ.syncObject(this.monitor);
        super.sync();
    }
}

