/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.sparql.util.Symbol;

public class Context {
    public static final Context emptyContext = new Context(true);
    protected Map<Symbol, Object> context = new ConcurrentHashMap<Symbol, Object>();
    protected boolean readonly = false;

    public Context() {
    }

    private Context(boolean readonly) {
        this.readonly = readonly;
    }

    public Context(Context cxt) {
        this.putAll(cxt);
    }

    protected Object mapGet(Symbol property) {
        return this.context.get(property);
    }

    protected void mapPut(Symbol property, Object value) {
        if (this.readonly) {
            throw new ARQException("Context is readonly");
        }
        if (property == null) {
            throw new ARQException("Context key is null");
        }
        if (value == null) {
            this.mapRemove(property);
            return;
        }
        this.context.put(property, value);
    }

    protected void mapRemove(Symbol property) {
        this.context.remove(property);
    }

    protected boolean mapContains(Symbol property) {
        return this.context.containsKey(property);
    }

    protected Set<Symbol> mapKeySet() {
        return this.context.keySet();
    }

    protected int mapSize() {
        return this.context.size();
    }

    protected void mapForEach(BiConsumer<Symbol, Object> action) {
        this.context.forEach(action);
    }

    public Context copy() {
        return new Context(this);
    }

    public <T> T get(Symbol property) {
        return (T)this.mapGet(property);
    }

    public Object get(Symbol property, Object defaultValue) {
        Object x = this.mapGet(property);
        if (x == null) {
            return defaultValue;
        }
        return x;
    }

    public void put(Symbol property, Object value) {
        this.mapPut(property, value);
    }

    public void set(Symbol property, Object value) {
        this.mapPut(property, value);
    }

    public void set(Symbol property, boolean value) {
        if (value) {
            this.setTrue(property);
        } else {
            this.setFalse(property);
        }
    }

    public void setIfUndef(Symbol property, Object value) {
        Object x = this.mapGet(property);
        if (x == null) {
            this.put(property, value);
        }
    }

    public void remove(Symbol property) {
        this.mapRemove(property);
    }

    public void unset(Symbol property) {
        this.remove(property);
    }

    public boolean isDefined(Symbol property) {
        return this.mapContains(property);
    }

    public boolean isUndef(Symbol property) {
        return !this.isDefined(property);
    }

    public String getAsString(Symbol property, String defaultValue) {
        String x = this.getAsString(property);
        if (x == null) {
            return defaultValue;
        }
        return x;
    }

    public String getAsString(Symbol property) {
        Object x = this.mapGet(property);
        if (x == null) {
            return null;
        }
        return x.toString();
    }

    public int getInt(Symbol symbol, int defaultValue) {
        if (this.isUndef(symbol)) {
            return defaultValue;
        }
        Object obj = this.mapGet(symbol);
        if (obj instanceof String) {
            return Integer.parseInt((String)obj);
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        throw new ARQException("Value for " + symbol + " is not a recoginized class: " + Lib.className(obj));
    }

    public long getLong(Symbol symbol, long defaultValue) {
        if (this.isUndef(symbol)) {
            return defaultValue;
        }
        Object obj = this.mapGet(symbol);
        if (obj instanceof String) {
            return Long.parseLong((String)obj);
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).intValue();
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        throw new ARQException("Value for " + symbol + " is not a recognized class: " + Lib.className(obj));
    }

    public void putAll(Context other) {
        if (this.readonly) {
            throw new ARQException("Context is readonly");
        }
        if (other != null) {
            other.mapForEach(this::put);
        }
    }

    public void setTrue(Symbol property) {
        this.set(property, Boolean.TRUE);
    }

    public void setFalse(Symbol property) {
        this.set(property, Boolean.FALSE);
    }

    public boolean isTrue(Symbol property) {
        return this.isTrue(property, false);
    }

    public boolean isTrueOrUndef(Symbol property) {
        return this.isTrue(property, true);
    }

    private boolean isTrue(Symbol property, boolean dft) {
        String s2;
        Object x = this.get(property);
        if (x == null) {
            return dft;
        }
        if (x instanceof String && (s2 = (String)x).equalsIgnoreCase("true")) {
            return true;
        }
        return x.equals(Boolean.TRUE);
    }

    public boolean isFalse(Symbol property) {
        return this.isFalse(property, false);
    }

    public boolean isFalseOrUndef(Symbol property) {
        return this.isFalse(property, true);
    }

    private boolean isFalse(Symbol property, boolean dft) {
        String s2;
        Object x = this.get(property);
        if (x == null) {
            return dft;
        }
        if (x instanceof String && (s2 = (String)x).equalsIgnoreCase("false")) {
            return true;
        }
        return x.equals(Boolean.FALSE);
    }

    public boolean hasValue(Symbol property, Object value) {
        Object x = this.get(property);
        if (x == null && value == null) {
            return true;
        }
        if (x == null || value == null) {
            return false;
        }
        return x.equals(value);
    }

    public boolean hasValueAsString(Symbol property, String value) {
        return this.hasValueAsString(property, value, false);
    }

    public boolean hasValueAsString(Symbol property, String value, boolean ignoreCase) {
        String s2 = this.getAsString(property);
        if (s2 == null && value == null) {
            return true;
        }
        if (s2 == null || value == null) {
            return false;
        }
        if (ignoreCase) {
            return s2.equalsIgnoreCase(value);
        }
        return s2.equals(value);
    }

    public Set<Symbol> keys() {
        return this.mapKeySet();
    }

    public int size() {
        return this.mapSize();
    }

    public String toString() {
        String x = "";
        String sep = "";
        for (Symbol s2 : this.keys()) {
            Object value = this.get(s2);
            x = x + sep + s2 + " = " + value;
            sep = "\n";
        }
        return x;
    }

    public static Context setupContextExec(Context globalContext, DatasetGraph dataset) {
        if (globalContext == null) {
            globalContext = ARQ.getContext();
        }
        Context dsgCxt = dataset != null && dataset.getContext() != null ? dataset.getContext() : null;
        Context context = Context.mergeCopy(globalContext, dsgCxt);
        context.set(ARQConstants.sysCurrentTime, NodeFactoryExtra.nowAsDateTime());
        return context;
    }

    public static Context mergeCopy(Context contextGlobal, Context contextLocal) {
        if (contextGlobal == null) {
            contextGlobal = ARQ.getContext();
        }
        Context context = contextGlobal.copy();
        if (contextLocal != null) {
            context.putAll(contextLocal);
        }
        return context;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        result = 31 * result + (this.readonly ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Context other = (Context)obj;
        if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
            return false;
        }
        return this.readonly == other.readonly;
    }
}

