/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;

public class PrefixMapping2
implements PrefixMapping {
    PrefixMapping pmapGlobal;
    PrefixMapping pmapLocal;

    public PrefixMapping2(PrefixMapping globalMapping, PrefixMapping localMapping) {
        this.pmapGlobal = globalMapping;
        this.pmapLocal = localMapping;
    }

    public PrefixMapping2(PrefixMapping globalMapping) {
        this(globalMapping, new PrefixMappingImpl());
    }

    public PrefixMapping getLocalPrefixMapping() {
        return this.pmapLocal;
    }

    public PrefixMapping getGlobalPrefixMapping() {
        return this.pmapGlobal;
    }

    public void setLocalPrefixMapping(PrefixMapping x) {
        this.pmapLocal = x;
    }

    public void setGlobalPrefixMapping(PrefixMapping x) {
        this.pmapGlobal = x;
    }

    @Override
    public PrefixMapping setNsPrefix(String prefix, String uri) {
        this.pmapLocal.setNsPrefix(prefix, uri);
        return this;
    }

    @Override
    public PrefixMapping removeNsPrefix(String prefix) {
        this.pmapLocal.removeNsPrefix(prefix);
        if (this.pmapGlobal != null && this.pmapGlobal.getNsPrefixURI(prefix) != null) {
            throw new UnsupportedOperationException("PrefixMapping2: prefix '" + prefix + "' in the immutable map");
        }
        return this;
    }

    @Override
    public PrefixMapping clearNsPrefixMap() {
        this.getLocalPrefixMapping().clearNsPrefixMap();
        return this;
    }

    @Override
    public PrefixMapping setNsPrefixes(PrefixMapping other) {
        this.pmapLocal.setNsPrefixes(other);
        return this;
    }

    @Override
    public PrefixMapping setNsPrefixes(Map<String, String> map) {
        this.pmapLocal.setNsPrefixes(map);
        return this;
    }

    @Override
    public String getNsPrefixURI(String prefix) {
        String s2 = this.pmapLocal.getNsPrefixURI(prefix);
        if (s2 != null) {
            return s2;
        }
        if (this.pmapGlobal != null) {
            return this.pmapGlobal.getNsPrefixURI(prefix);
        }
        return null;
    }

    @Override
    public String getNsURIPrefix(String uri) {
        String s2 = this.pmapLocal.getNsURIPrefix(uri);
        if (s2 != null) {
            return s2;
        }
        if (this.pmapGlobal == null) {
            return null;
        }
        if (this.pmapGlobal != null) {
            return this.pmapGlobal.getNsURIPrefix(uri);
        }
        return null;
    }

    @Override
    public Map<String, String> getNsPrefixMap() {
        return this.getNsPrefixMap(true);
    }

    public Map<String, String> getNsPrefixMap(boolean includeGlobalMap) {
        Map<String, String> m1 = this.pmapLocal.getNsPrefixMap();
        if (this.pmapGlobal == null) {
            return m1;
        }
        if (includeGlobalMap) {
            Map<String, String> m22 = this.pmapGlobal.getNsPrefixMap();
            m1.putAll(m22);
        }
        return m1;
    }

    @Override
    public String expandPrefix(String prefixed) {
        String s2 = this.pmapLocal.expandPrefix(prefixed);
        if (this.pmapGlobal == null) {
            return s2;
        }
        if ((s2 == null || s2.equals(prefixed)) && this.pmapGlobal != null) {
            s2 = this.pmapGlobal.expandPrefix(prefixed);
        }
        return s2;
    }

    @Override
    public String shortForm(String uri) {
        String s2 = this.pmapLocal.shortForm(uri);
        if (this.pmapGlobal == null) {
            return s2;
        }
        if (s2 == null || s2.equals(uri)) {
            s2 = this.pmapGlobal.shortForm(uri);
        }
        return s2;
    }

    @Override
    public String qnameFor(String uri) {
        String s2 = this.pmapLocal.qnameFor(uri);
        if (this.pmapGlobal == null) {
            return s2;
        }
        if (s2 != null) {
            return s2;
        }
        if (this.pmapGlobal != null) {
            return this.pmapGlobal.qnameFor(uri);
        }
        return null;
    }

    @Override
    public boolean hasNoMappings() {
        return this.pmapLocal.hasNoMappings() && this.pmapGlobal.hasNoMappings();
    }

    @Override
    public int numPrefixes() {
        HashMap<String, String> x = new HashMap<String, String>();
        x.putAll(this.pmapLocal.getNsPrefixMap());
        x.putAll(this.pmapGlobal.getNsPrefixMap());
        return x.size();
    }

    @Override
    public PrefixMapping lock() {
        this.pmapLocal.lock();
        return this;
    }

    @Override
    public PrefixMapping withDefaultMappings(PrefixMapping map) {
        for (Map.Entry<String, String> e2 : map.getNsPrefixMap().entrySet()) {
            String prefix = e2.getKey();
            String uri = e2.getValue();
            if (this.getNsPrefixURI(prefix) != null || this.getNsURIPrefix(uri) != null) continue;
            this.setNsPrefix(prefix, uri);
        }
        return this;
    }

    @Override
    public boolean samePrefixMappingAs(PrefixMapping other) {
        if (other == null) {
            return false;
        }
        if (other instanceof PrefixMapping2) {
            PrefixMapping2 other2 = (PrefixMapping2)other;
            return this.pmapGlobal.samePrefixMappingAs(other2.pmapGlobal) && this.pmapLocal.samePrefixMappingAs(other2.pmapLocal);
        }
        return this.getNsPrefixMap().equals(other.getNsPrefixMap());
    }
}

