/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RomanNumeral {
    int intValue;
    static String numeralPattern = "M*(CM|DC{0,3}|CD|C{0,3})(XC|LX{0,3}|XL|X{0,3})(IX|VI{0,3}|IV|I{0,4})";
    static Pattern pattern = Pattern.compile(numeralPattern);

    public RomanNumeral(String lexicalForm) {
        if (!RomanNumeral.isValid(lexicalForm)) {
            throw new NumberFormatException("Invalid Roman Numeral: " + lexicalForm);
        }
        this.intValue = RomanNumeral.r2i(lexicalForm);
    }

    public RomanNumeral(int i) {
        if (i <= 0) {
            throw new NumberFormatException("Roman numerals are 1-3999 (" + i + ")");
        }
        if (i > 3999) {
            throw new NumberFormatException("Roman numerals are 1-3999 (" + i + ")");
        }
        this.intValue = i;
    }

    public String toString() {
        return RomanNumeral.i2r(this.intValue);
    }

    public int intValue() {
        return this.intValue;
    }

    public static boolean isValid(String lex) {
        lex = lex.toUpperCase(Locale.ENGLISH);
        Matcher m3 = pattern.matcher(lex);
        return m3.matches();
    }

    public static int parse(String lex) {
        return RomanNumeral.r2i(lex);
    }

    public static int r2i(String lex) {
        lex = lex.toUpperCase(Locale.ROOT);
        int current = 0;
        int v = 0;
        for (int i = lex.length() - 1; i >= 0; --i) {
            char ch = lex.charAt(i);
            int x = RomanNumeral.charToNum(ch);
            if (x < current) {
                v -= x;
                continue;
            }
            v += x;
            current = x;
        }
        return v;
    }

    public static String asRomanNumerals(int i) {
        return RomanNumeral.i2r(i);
    }

    public static String i2r(int i) {
        if (i <= 0) {
            throw new NumberFormatException("Roman numerals are 1-3999 (" + i + ")");
        }
        if (i > 3999) {
            throw new NumberFormatException("Roman numerals are 1-3999 (" + i + ")");
        }
        StringBuffer sbuff = new StringBuffer();
        i = RomanNumeral.i2r(sbuff, i, "M", 1000, "CM", 900, "D", 500, "CD", 400);
        i = RomanNumeral.i2r(sbuff, i, "C", 100, "XC", 90, "L", 50, "XL", 40);
        for (i = RomanNumeral.i2r(sbuff, i, "X", 10, "IX", 9, "V", 5, "IV", 4); i >= 1; --i) {
            sbuff.append("I");
        }
        return sbuff.toString();
    }

    private static int i2r(StringBuffer sbuff, int i, String tens, int iTens, String nines, int iNines, String fives, int iFives, String fours, int iFours) {
        while (i >= iTens) {
            sbuff.append(tens);
            i -= iTens;
        }
        if (i >= iNines) {
            sbuff.append(nines);
            i -= iNines;
        }
        if (i >= iFives) {
            sbuff.append(fives);
            i -= iFives;
        }
        if (i >= iFours) {
            sbuff.append(fours);
            i -= iFours;
        }
        return i;
    }

    private static int charToNum(char ch) {
        if (ch == '\u0000') {
            return 0;
        }
        for (int i = 0; i < RValue.table.length; ++i) {
            if (RValue.table[i].lex != ch) continue;
            return RValue.table[i].val;
        }
        return 0;
    }

    static class RValue {
        static RValue[] table = new RValue[]{new RValue('M', 1000), new RValue('D', 500), new RValue('C', 100), new RValue('L', 50), new RValue('X', 10), new RValue('V', 5), new RValue('I', 1)};
        char lex;
        int val;

        RValue(char s2, int v) {
            this.lex = s2;
            this.val = v;
        }
    }
}

