/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store.nodetable;

import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.SSEParseException;
import org.apache.jena.tdb.lib.NodeLib;

public class NodecLib {
    private static final char MarkerChar = '_';
    private static final char[] invalidIRIChars = new char[]{'_', ' '};

    private static String encode(Node node) {
        return NodecLib.encode(node, null);
    }

    private static String encode(Node node, PrefixMapping pmap) {
        String x;
        if (node.isBlank()) {
            return "_:" + node.getBlankNodeLabel();
        }
        if (node.isURI() && (x = StrUtils.encodeHex(node.getURI(), '_', invalidIRIChars)) != node.getURI()) {
            node = NodeFactory.createURI(x);
        }
        return NodeFmtLib.str(node);
    }

    private static Node decode(String s2) {
        return NodecLib.decode(s2, null);
    }

    private static Node decode(String s2, PrefixMapping pmap) {
        if (s2.startsWith("_:")) {
            s2 = s2.substring(2);
            return NodeFactory.createBlankNode(s2);
        }
        if (s2.startsWith("<")) {
            s2 = s2.substring(1, s2.length() - 1);
            s2 = StrUtils.decodeHex(s2, '_');
            return NodeFactory.createURI(s2);
        }
        try {
            Node n = SSE.parseNode(s2, pmap);
            return n;
        }
        catch (SSEParseException ex) {
            Log.error(NodeLib.class, "decode: Failed to parse: " + s2);
            throw ex;
        }
    }
}

