/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphWrapper;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.tdb2.store.GraphViewSwitchable;

public final class DatasetGraphSwitchable
extends DatasetGraphWrapper {
    private final AtomicReference<DatasetGraph> dsgx = new AtomicReference();
    private final Path basePath;
    private final Location location;
    private Graph dftGraph = GraphViewSwitchable.createDefaultGraph(this);
    private Cache<Node, Graph> ngCache = CacheFactory.createOneSlotCache();

    public DatasetGraphSwitchable(Path base, Location location, DatasetGraph dsg) {
        super(null, dsg.getContext());
        this.dsgx.set(dsg);
        this.basePath = base;
        this.location = location;
    }

    public boolean hasContainerPath() {
        return this.basePath != null;
    }

    public Path getContainerPath() {
        return this.basePath;
    }

    public Location getLocation() {
        return this.location;
    }

    @Override
    public DatasetGraph get() {
        return this.dsgx.get();
    }

    public DatasetGraph set(DatasetGraph dsg) {
        return this.dsgx.getAndSet(dsg);
    }

    @Override
    public void close() {
    }

    public boolean change(DatasetGraph oldDSG, DatasetGraph newDSG) {
        return this.dsgx.compareAndSet(oldDSG, newDSG);
    }

    @Override
    public Graph getDefaultGraph() {
        return this.dftGraph;
    }

    @Override
    public Graph getGraph(Node gn) {
        Node key = gn != null ? gn : Quad.defaultGraphNodeGenerated;
        return this.ngCache.getOrFill(key, () -> GraphViewSwitchable.createNamedGraph(this, key));
    }
}

