/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.tdb2.lib.TupleLib;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.TableBase;
import org.apache.jena.tdb2.store.nodetable.NodeTable;
import org.apache.jena.tdb2.store.tupletable.TupleIndex;

public class QuadTable
extends TableBase {
    public QuadTable(TupleIndex[] indexes, NodeTable nodeTable) {
        super(4, indexes, nodeTable);
    }

    public void add(Quad quad) {
        this.add(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    public void add(Node gn, Triple triple) {
        this.add(gn, triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public void add(Node g2, Node s2, Node p, Node o) {
        this.table.addRow(g2, s2, p, o);
    }

    public void delete(Quad quad) {
        this.delete(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    public void delete(Node gn, Triple triple) {
        this.delete(gn, triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public void delete(Node g2, Node s2, Node p, Node o) {
        this.table.deleteRow(g2, s2, p, o);
    }

    public Iterator<Quad> find(Node g2, Node s2, Node p, Node o) {
        Iterator<Tuple<NodeId>> iter = this.table.findAsNodeIds(g2, s2, p, o);
        if (iter == null) {
            return Iter.nullIterator();
        }
        Iterator<Quad> iter2 = TupleLib.convertToQuads(this.table.getNodeTable(), iter);
        return iter2;
    }

    public void clearQuads() {
        this.table.clear();
    }
}

