/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.web;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.DatasetAccessor;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.web.DatasetGraphAccessor;

public class DatasetAdapter
implements DatasetAccessor {
    private final DatasetGraphAccessor updater;

    public DatasetAdapter(DatasetGraphAccessor updater) {
        this.updater = updater;
    }

    @Override
    public Model getModel() {
        Graph g2 = this.updater.httpGet();
        return ModelFactory.createModelForGraph(g2);
    }

    @Override
    public Model getModel(String graphUri) {
        Graph g2 = this.updater.httpGet(NodeFactory.createURI(graphUri));
        if (g2 == null) {
            return null;
        }
        return ModelFactory.createModelForGraph(g2);
    }

    @Override
    public boolean containsModel(String graphUri) {
        return this.updater.httpHead(NodeFactory.createURI(graphUri));
    }

    @Override
    public void putModel(Model data) {
        this.updater.httpPut(data.getGraph());
    }

    @Override
    public void putModel(String graphUri, Model data) {
        this.updater.httpPut(NodeFactory.createURI(graphUri), data.getGraph());
    }

    @Override
    public void deleteDefault() {
        this.updater.httpDelete();
    }

    @Override
    public void deleteModel(String graphUri) {
        this.updater.httpDelete(NodeFactory.createURI(graphUri));
    }

    @Override
    public void add(Model data) {
        this.updater.httpPost(data.getGraph());
    }

    @Override
    public void add(String graphUri, Model data) {
        this.updater.httpPost(NodeFactory.createURI(graphUri), data.getGraph());
    }
}

