/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.extractor;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.POIOLE2TextExtractor;
import org.apache.poi.POITextExtractor;
import org.apache.poi.POIXMLRelation;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.extractor.OLE2ExtractorFactory;
import org.apache.poi.hsmf.MAPIMessage;
import org.apache.poi.hsmf.datatypes.AttachmentChunks;
import org.apache.poi.hsmf.extractor.OutlookTextExtactor;
import org.apache.poi.hssf.extractor.ExcelExtractor;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.hwpf.extractor.WordExtractor;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.NotOLE2FileException;
import org.apache.poi.poifs.filesystem.OPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.NotImplemented;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.xdgf.extractor.XDGFVisioExtractor;
import org.apache.poi.xslf.extractor.XSLFPowerPointExtractor;
import org.apache.poi.xslf.usermodel.XSLFRelation;
import org.apache.poi.xslf.usermodel.XSLFSlideShow;
import org.apache.poi.xssf.extractor.XSSFBEventBasedExcelExtractor;
import org.apache.poi.xssf.extractor.XSSFEventBasedExcelExtractor;
import org.apache.poi.xssf.extractor.XSSFExcelExtractor;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.xmlbeans.XmlException;

public class ExtractorFactory {
    private static final POILogger logger = POILogFactory.getLogger(ExtractorFactory.class);
    public static final String CORE_DOCUMENT_REL = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument";
    protected static final String VISIO_DOCUMENT_REL = "http://schemas.microsoft.com/visio/2010/relationships/document";
    protected static final String STRICT_DOCUMENT_REL = "http://purl.oclc.org/ooxml/officeDocument/relationships/officeDocument";

    public static boolean getThreadPrefersEventExtractors() {
        return OLE2ExtractorFactory.getThreadPrefersEventExtractors();
    }

    public static Boolean getAllThreadsPreferEventExtractors() {
        return OLE2ExtractorFactory.getAllThreadsPreferEventExtractors();
    }

    public static void setThreadPrefersEventExtractors(boolean preferEventExtractors) {
        OLE2ExtractorFactory.setThreadPrefersEventExtractors(preferEventExtractors);
    }

    public static void setAllThreadsPreferEventExtractors(Boolean preferEventExtractors) {
        OLE2ExtractorFactory.setAllThreadsPreferEventExtractors(preferEventExtractors);
    }

    protected static boolean getPreferEventExtractor() {
        return OLE2ExtractorFactory.getPreferEventExtractor();
    }

    public static POITextExtractor createExtractor(File f) throws IOException, OpenXML4JException, XmlException {
        NPOIFSFileSystem fs = null;
        try {
            fs = new NPOIFSFileSystem(f);
            if (fs.getRoot().hasEntry("EncryptedPackage")) {
                return ExtractorFactory.createEncyptedOOXMLExtractor(fs);
            }
            POIOLE2TextExtractor extractor = ExtractorFactory.createExtractor(fs);
            extractor.setFilesystem(fs);
            return extractor;
        }
        catch (OfficeXmlFileException e2) {
            IOUtils.closeQuietly(fs);
            return ExtractorFactory.createExtractor(OPCPackage.open(f.toString(), PackageAccess.READ));
        }
        catch (NotOLE2FileException ne) {
            IOUtils.closeQuietly(fs);
            throw new IllegalArgumentException("Your File was neither an OLE2 file, nor an OOXML file");
        }
        catch (OpenXML4JException e3) {
            IOUtils.closeQuietly(fs);
            throw e3;
        }
        catch (XmlException e4) {
            IOUtils.closeQuietly(fs);
            throw e4;
        }
        catch (IOException e5) {
            IOUtils.closeQuietly(fs);
            throw e5;
        }
        catch (RuntimeException e6) {
            IOUtils.closeQuietly(fs);
            throw e6;
        }
        catch (Error e7) {
            IOUtils.closeQuietly(fs);
            throw e7;
        }
    }

    public static POITextExtractor createExtractor(InputStream inp) throws IOException, OpenXML4JException, XmlException {
        InputStream is = FileMagic.prepareToCheckMagic(inp);
        FileMagic fm = FileMagic.valueOf(is);
        switch (fm) {
            case OLE2: {
                NPOIFSFileSystem fs = new NPOIFSFileSystem(is);
                boolean isEncrypted = fs.getRoot().hasEntry("EncryptedPackage");
                return isEncrypted ? ExtractorFactory.createEncyptedOOXMLExtractor(fs) : ExtractorFactory.createExtractor(fs);
            }
            case OOXML: {
                return ExtractorFactory.createExtractor(OPCPackage.open(is));
            }
        }
        throw new IllegalArgumentException("Your InputStream was neither an OLE2 stream, nor an OOXML stream");
    }

    public static POIXMLTextExtractor createExtractor(OPCPackage pkg) throws IOException, OpenXML4JException, XmlException {
        try {
            PackageRelationshipCollection core = pkg.getRelationshipsByType(CORE_DOCUMENT_REL);
            if (core.size() == 0) {
                core = pkg.getRelationshipsByType(STRICT_DOCUMENT_REL);
            }
            if (core.size() == 0 && (core = pkg.getRelationshipsByType(VISIO_DOCUMENT_REL)).size() == 1) {
                return new XDGFVisioExtractor(pkg);
            }
            if (core.size() != 1) {
                throw new IllegalArgumentException("Invalid OOXML Package received - expected 1 core document, found " + core.size());
            }
            PackagePart corePart = pkg.getPart(core.getRelationship(0));
            String contentType = corePart.getContentType();
            for (XSSFRelation xSSFRelation : XSSFExcelExtractor.SUPPORTED_TYPES) {
                if (!xSSFRelation.getContentType().equals(contentType)) continue;
                if (ExtractorFactory.getPreferEventExtractor()) {
                    return new XSSFEventBasedExcelExtractor(pkg);
                }
                return new XSSFExcelExtractor(pkg);
            }
            for (POIXMLRelation pOIXMLRelation : XWPFWordExtractor.SUPPORTED_TYPES) {
                if (!pOIXMLRelation.getContentType().equals(contentType)) continue;
                return new XWPFWordExtractor(pkg);
            }
            for (POIXMLRelation pOIXMLRelation : XSLFPowerPointExtractor.SUPPORTED_TYPES) {
                if (!pOIXMLRelation.getContentType().equals(contentType)) continue;
                return new XSLFPowerPointExtractor(pkg);
            }
            if (XSLFRelation.THEME_MANAGER.getContentType().equals(contentType)) {
                return new XSLFPowerPointExtractor(new XSLFSlideShow(pkg));
            }
            for (POIXMLRelation pOIXMLRelation : XSSFBEventBasedExcelExtractor.SUPPORTED_TYPES) {
                if (!pOIXMLRelation.getContentType().equals(contentType)) continue;
                return new XSSFBEventBasedExcelExtractor(pkg);
            }
            throw new IllegalArgumentException("No supported documents found in the OOXML package (found " + contentType + ")");
        }
        catch (IOException e2) {
            pkg.revert();
            throw e2;
        }
        catch (OpenXML4JException e3) {
            pkg.revert();
            throw e3;
        }
        catch (XmlException e4) {
            pkg.revert();
            throw e4;
        }
        catch (RuntimeException e5) {
            pkg.revert();
            throw e5;
        }
        catch (Error e6) {
            pkg.revert();
            throw e6;
        }
    }

    public static POIOLE2TextExtractor createExtractor(POIFSFileSystem fs) throws IOException, OpenXML4JException, XmlException {
        return OLE2ExtractorFactory.createExtractor(fs);
    }

    public static POIOLE2TextExtractor createExtractor(NPOIFSFileSystem fs) throws IOException, OpenXML4JException, XmlException {
        return OLE2ExtractorFactory.createExtractor(fs);
    }

    public static POIOLE2TextExtractor createExtractor(OPOIFSFileSystem fs) throws IOException, OpenXML4JException, XmlException {
        return OLE2ExtractorFactory.createExtractor(fs);
    }

    public static POITextExtractor createExtractor(DirectoryNode poifsDir) throws IOException, OpenXML4JException, XmlException {
        for (String entryName : poifsDir.getEntryNames()) {
            if (!entryName.equals("Package")) continue;
            OPCPackage pkg = OPCPackage.open(poifsDir.createDocumentInputStream("Package"));
            return ExtractorFactory.createExtractor(pkg);
        }
        return OLE2ExtractorFactory.createExtractor(poifsDir);
    }

    public static POITextExtractor[] getEmbededDocsTextExtractors(POIOLE2TextExtractor ext) throws IOException, OpenXML4JException, XmlException {
        ArrayList<Entry> dirs = new ArrayList<Entry>();
        ArrayList<ByteArrayInputStream> nonPOIFS = new ArrayList<ByteArrayInputStream>();
        DirectoryEntry root2 = ext.getRoot();
        if (root2 == null) {
            throw new IllegalStateException("The extractor didn't know which POIFS it came from!");
        }
        if (ext instanceof ExcelExtractor) {
            Iterator<Entry> it = root2.getEntries();
            while (it.hasNext()) {
                Entry entry = it.next();
                if (!entry.getName().startsWith("MBD")) continue;
                dirs.add(entry);
            }
        } else if (ext instanceof WordExtractor) {
            try {
                DirectoryEntry op = (DirectoryEntry)root2.getEntry("ObjectPool");
                Iterator<Entry> it = op.getEntries();
                while (it.hasNext()) {
                    Entry entry = it.next();
                    if (!entry.getName().startsWith("_")) continue;
                    dirs.add(entry);
                }
            }
            catch (FileNotFoundException e2) {
                logger.log(3, "Ignoring FileNotFoundException while extracting Word document", e2.getLocalizedMessage());
            }
        } else if (ext instanceof OutlookTextExtactor) {
            MAPIMessage msg = ((OutlookTextExtactor)ext).getMAPIMessage();
            for (AttachmentChunks attachment : msg.getAttachmentFiles()) {
                if (attachment.getAttachData() != null) {
                    byte[] data = attachment.getAttachData().getValue();
                    nonPOIFS.add(new ByteArrayInputStream(data));
                    continue;
                }
                if (attachment.getAttachmentDirectory() == null) continue;
                dirs.add(attachment.getAttachmentDirectory().getDirectory());
            }
        }
        if (dirs.size() == 0 && nonPOIFS.size() == 0) {
            return new POITextExtractor[0];
        }
        ArrayList<POITextExtractor> textExtractors = new ArrayList<POITextExtractor>();
        for (Entry entry : dirs) {
            textExtractors.add(ExtractorFactory.createExtractor((DirectoryNode)entry));
        }
        for (InputStream inputStream : nonPOIFS) {
            try {
                textExtractors.add(ExtractorFactory.createExtractor(inputStream));
            }
            catch (IllegalArgumentException e3) {
                logger.log(3, "Format not supported yet", e3.getLocalizedMessage());
            }
            catch (XmlException e4) {
                throw new IOException(e4.getMessage(), e4);
            }
            catch (OpenXML4JException e5) {
                throw new IOException(e5.getMessage(), e5);
            }
        }
        return textExtractors.toArray(new POITextExtractor[textExtractors.size()]);
    }

    @NotImplemented
    public static POITextExtractor[] getEmbededDocsTextExtractors(POIXMLTextExtractor ext) {
        throw new IllegalStateException("Not yet supported");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static POIXMLTextExtractor createEncyptedOOXMLExtractor(NPOIFSFileSystem fs) throws IOException {
        POIXMLTextExtractor pOIXMLTextExtractor;
        String pass = Biff8EncryptionKey.getCurrentUserPassword();
        if (pass == null) {
            pass = "VelvetSweatshop";
        }
        EncryptionInfo ei = new EncryptionInfo(fs);
        Decryptor dec = ei.getDecryptor();
        InputStream is = null;
        try {
            if (!dec.verifyPassword(pass)) {
                throw new EncryptedDocumentException("Invalid password specified - use Biff8EncryptionKey.setCurrentUserPassword() before calling extractor");
            }
            is = dec.getDataStream(fs);
            pOIXMLTextExtractor = ExtractorFactory.createExtractor(OPCPackage.open(is));
        }
        catch (IOException e2) {
            try {
                throw e2;
                catch (Exception e3) {
                    throw new EncryptedDocumentException(e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(is);
        return pOIXMLTextExtractor;
    }
}

