/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf.wellknown;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.hpsf.wellknown.PropertyIDMap;
import org.apache.poi.util.Internal;

@Internal
public class SectionIDMap {
    private static ThreadLocal<Map<ClassID, PropertyIDMap>> defaultMap = new ThreadLocal();
    public static final ClassID SUMMARY_INFORMATION_ID = new ClassID("{F29F85E0-4FF9-1068-AB91-08002B27B3D9}");
    private static final ClassID DOC_SUMMARY_INFORMATION = new ClassID("{D5CDD502-2E9C-101B-9397-08002B2CF9AE}");
    private static final ClassID USER_DEFINED_PROPERTIES = new ClassID("{D5CDD505-2E9C-101B-9397-08002B2CF9AE}");
    public static final ClassID[] DOCUMENT_SUMMARY_INFORMATION_ID = new ClassID[]{DOC_SUMMARY_INFORMATION, USER_DEFINED_PROPERTIES};
    public static final String UNDEFINED = "[undefined]";

    public static SectionIDMap getInstance() {
        Map<ClassID, PropertyIDMap> m3 = defaultMap.get();
        if (m3 == null) {
            m3 = new HashMap<ClassID, PropertyIDMap>();
            m3.put(SUMMARY_INFORMATION_ID, PropertyIDMap.getSummaryInformationProperties());
            m3.put(DOCUMENT_SUMMARY_INFORMATION_ID[0], PropertyIDMap.getDocumentSummaryInformationProperties());
            defaultMap.set(m3);
        }
        return new SectionIDMap();
    }

    public static String getPIDString(ClassID sectionFormatID, long pid) {
        PropertyIDMap m3 = SectionIDMap.getInstance().get(sectionFormatID);
        if (m3 == null) {
            return UNDEFINED;
        }
        String s2 = m3.get(pid);
        if (s2 == null) {
            return UNDEFINED;
        }
        return s2;
    }

    public PropertyIDMap get(ClassID sectionFormatID) {
        return SectionIDMap.getInstance().get(sectionFormatID);
    }

    public PropertyIDMap put(ClassID sectionFormatID, PropertyIDMap propertyIDMap) {
        return SectionIDMap.getInstance().put(sectionFormatID, propertyIDMap);
    }

    protected PropertyIDMap put(String key, PropertyIDMap value) {
        return this.put(new ClassID(key), value);
    }
}

